class SBWarShell expands WarShell config(SBMutatorFastWarshell);

var config float WarshellSpeed;
var config string WarshellLaunchSound;


function PlayersPlaySoundEffect(sound Sound) {
// plays the *sound* that can be heard by all players.
local pawn P;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn)
		if (P.bIsPlayer && P.IsA('PlayerPawn'))
			PlayerPawn(P).ClientPlaySound(Sound);
}

simulated function PostBeginPlay() {

	Speed = WarshellSpeed;
	if (WarshellLaunchSound != "")
		PlayersPlaySoundEffect(Sound(DynamicLoadObject(WarshellLaunchSound, class'Sound')));
	super.PostBeginPlay();
}


defaultproperties {
	WarshellSpeed=6666
	WarshellLaunchSound="SBMutatorFastWarshell.NuclearLaunchDetected"
}
