class HGPBolt extends PBolt;

#exec TEXTURE IMPORT NAME=HGpbolt0 FILE=Textures\HGpbolt0.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=HGpbolt1 FILE=Textures\HGpbolt1.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=HGpbolt2 FILE=Textures\HGpbolt2.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=HGpbolt3 FILE=Textures\HGpbolt3.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=HGpbolt4 FILE=Textures\HGpbolt4.bmp GROUP=Skins LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=pbolt NUM=0 TEXTURE=HGpbolt0

#exec AUDIO IMPORT FILE="Sounds\PulseBolt2.WAV" NAME="PulseBolt2"
#exec AUDIO IMPORT FILE="Sounds\HGhealed.wav" NAME="HGhealed"

var string HealMessageInstigator;
var string HealMessageInstigatorMaxReached;
var class<LocalMessage> HealMessageHitActor;


simulated function CheckBeam(vector X, float DeltaTime) {
local actor HitActor;
local vector HitLocation, HitNormal;
local string s;
local int HealthIncrement;

	HitActor = Trace(HitLocation, HitNormal, Location + BeamSize * X, Location, true);
	if (
		(HitActor != None)
		&& (HitActor != Instigator)
		&& (HitActor.bProjTarget || (HitActor == Level) || (HitActor.bBlockActors && HitActor.bBlockPlayers))
		&& ((Pawn(HitActor) == None) || Pawn(HitActor).AdjustHitLocation(HitLocation, Velocity)) )
	{
		
		if (SBHealingGun(owner) != None && HealThisActor(HitActor))
		{
			if (WallEffect != None)
				WallEffect.Destroy();
			//if (Role == ROLE_Authority)
			if (Level.NetMode != NM_Client)
			{
				Damage = 0;
				HealthIncrement = Min(SBHealingGun(owner).MaxHealth - Pawn(HitActor).Health, SBHealingGun(owner).HealingAmount);
				if (HealthIncrement > 0)
				{
					Pawn(HitActor).Health += HealthIncrement;
					if (SBHealingGun(Owner).CanSendHealMessage())
					{
						Pawn(HitActor).ReceiveLocalizedMessage(HealMessageHitActor, , Pawn(HitActor).PlayerReplicationInfo, Pawn(HitActor).PlayerReplicationInfo);
						s = ReplaceText(HealMessageInstigator, "%o", TrimL(HitActor.GetHumanName()));
						s = ReplaceText(s, "%h", Pawn(HitActor).Health);
						Instigator.ClientMessage(s);
					}
					Instigator.PlayerReplicationInfo.Score += 1;
					PlaySound(sound'HGhealed', , 2.0);
					spawn(class'HGUT_SpriteSmokePuff', , , HitLocation + HitNormal * 9);
				}
				else
					if (SBHealingGun(Owner).CanSendHealMessage())
						Instigator.ClientMessage(ReplaceText(HealMessageInstigatorMaxReached, "%h", SBHealingGun(owner).MaxHealth));
			}
		}
		else if ((WallEffect == None) || WallEffect.bDeleteMe)
			 WallEffect = Spawn(class'HGPlasmaHit', , , HitLocation - 5 * X);
		else if ( ! WallEffect.IsA('HGPlasmaHit') )
		{
			WallEffect.Destroy();
			WallEffect = Spawn(class'HGPlasmaHit', , , HitLocation - 5 * X);
		}
		else
			WallEffect.SetLocation(HitLocation - 5 * X);

		if ((WallEffect != None) && (Level.NetMode != NM_DedicatedServer))
			Spawn(ExplosionDecal,,,HitLocation,rotator(HitNormal));
		if (PlasmaBeam != None)
		{
			AccumulatedDamage += PlasmaBeam.AccumulatedDamage;
			PlasmaBeam.Destroy();
			PlasmaBeam = None;
		}
		return;
	}
	if (Position >= 9)
	{
		if ( (WallEffect == None) || WallEffect.bDeleteMe )
			WallEffect = Spawn(class'HGPlasmaCap',,, Location + (BeamSize - 4) * X);
		else if ( WallEffect.IsA('HGPlasmaHit') )
		{
			WallEffect.Destroy();
			WallEffect = Spawn(class'HGPlasmaCap',,, Location + (BeamSize - 4) * X);
		}
		else
			WallEffect.SetLocation(Location + (BeamSize - 4) * X);
	}
	else
	{
		if (WallEffect != None)
		{
			WallEffect.Destroy();
			WallEffect = None;
		}
		if (PlasmaBeam == None)
		{
			PlasmaBeam = Spawn(class'HGPBolt', owner, , Location + BeamSize * X);
			PlasmaBeam.Position = Position + 1;
		}
		else
			PlasmaBeam.UpdateBeam(self, X, DeltaTime);
			//HGPBolt(PlasmaBeam).UpdateBeamA(self, X, DeltaTime);
	}
}


function bool HealThisActor(Actor A) {
	if (Pawn(A) == None)
		return false;

	if (SBHealingGun(owner).bHealTeamMembersOnly)
		return Pawn(A).PlayerReplicationInfo != None && Pawn(A).PlayerReplicationInfo.Team == Instigator.PlayerReplicationInfo.Team;
	else
		return true;
}


function string ReplaceText(string Template, string Replace, coerce string With) {
local string Result;

	Result = Template;
	if (PlayerPawn(Instigator) != None)
		PlayerPawn(Instigator).ReplaceText(Result, Replace, With);
	return result;
}


function string TrimL(string s) {
local int i;
	while (i < len(s) && Mid(s, i, 1) == " ")
		i++;
	return Right(s, Len(s) - i);
}


defaultproperties {
	HealMessageInstigator="You are healing %o to %h"
	HealMessageHitActor=Class'HGHealMessage'
	HealMessageInstigatorMaxReached="This weapon can heal only until %h"
	SpriteAnim(0)=Texture'HGpbolt0'
	SpriteAnim(1)=Texture'HGpbolt1'
	SpriteAnim(2)=Texture'HGpbolt2'
	SpriteAnim(3)=Texture'HGpbolt3'
	SpriteAnim(4)=Texture'HGpbolt4'
	Skin=Texture'HGpbolt0'
	Texture=Texture'HGpbolt0'
	Mesh=pbolt
	AmbientSound=Sound'PulseBolt2'
	// not defined in *PBolt.Default*:
	DrawType=DT_Mesh
	CollisionRadius=+00000.000000
	CollisionHeight=+00000.000000
	bGameRelevant=true
}
