Class SBHealingGun extends PulseGun;


#exec TEXTURE IMPORT NAME=HGMuzzyPulse FILE=Textures\HGMuzzyPulse.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=HGAmmoLed FILE=Textures\HGAmmoLed.bmp GROUP=Skins

#exec MESHMAP SETTEXTURE MESHMAP=PulseGunL NUM=1 TEXTURE=HGAmmoled
#exec MESHMAP SETTEXTURE MESHMAP=PulseGunR NUM=1 TEXTURE=HGAmmoled


#exec AUDIO IMPORT FILE="Sounds\HGgundown.wav" NAME="HGgundown"
#exec AUDIO IMPORT FILE="Sounds\HGaltfire.wav" NAME="HGaltfire"
#exec AUDIO IMPORT FILE="Sounds\HGpickup.wav" NAME="HGpickup"
#exec AUDIO IMPORT FILE="Sounds\HGgunup.wav" NAME="HGgunup"
#exec AUDIO IMPORT FILE="Sounds\HGPulseFire.wav" NAME="HGPulseFire"

#exec TEXTURE IMPORT NAME=HGIconPulse FILE=TEXTURES\HGIconPulse.bmp GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=HGUsePulse FILE=TEXTURES\HGUsePulse.bmp GROUP="Icons" MIPS=OFF

var() int HealingAmount;
var() bool bHealTeamMembersOnly;
var() int MaxHealth; // healing only until this maximum


var int TimeForNextHealMessage;


function bool CanSendHealMessage() {
/******************************************************************************
Introduced to avoid spammy message with every tick.
******************************************************************************/
	if (TimeForNextHealMessage < Level.TimeSeconds)
	{
		TimeForNextHealMessage = Level.TimeSeconds + 2;
		return true;
	}
	return false;
}


/***
event GainedChild(Actor Other) {
	if (HGPBolt(Other) != None)
	{
		HGPBolt(Other).HGHealingAmount = HealingAmount;
		HGPBolt(Other).bHealTeamMembersOnly = bHealTeamMembersOnly;
		HGPBolt(Other).MaxHealth = MaxHealth;
		Instigator.ClientMessage("GainedChild for Actor" @ other);
	}
}
***/

function inventory SpawnCopy(pawn Other) {
local inventory result;
	result = Super.SpawnCopy(Other);
	if (SBHealingGun(result) != None)
	{
		SBHealingGun(result).HealingAmount = HealingAmount;
		SBHealingGun(result).bHealTeamMembersOnly = bHealTeamMembersOnly;
		SBHealingGun(result).MaxHealth = MaxHealth;
	}
	Return Result;
}


function PostBeginPlay() {
local class<Actor> CheckAltProjectileClass;

	Super.PostBeginPlay();
	CheckAltProjectileClass = class<Actor>(DynamicLoadObject(string(AltProjectileClass), class'Class'));
	if ( ! ((CheckAltProjectileClass != None) && ClassIsChildOf(CheckAltProjectileClass, class'HGStarterbolt')))
	{
		AltProjectileClass = Class'HGStarterbolt';
		warn("You must not change the AltProjectileClass for" @ self $ ". AltProjectileClass reset to" @ AltProjectileClass);
	}
}


function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn) {
local Projectile Proj;
	Proj = Super.ProjectileFire(ProjClass, ProjSpeed, bWarn);
	if (Proj != None)
		if (Proj.Owner == None)
			Proj.SetOwner(Self);
	return Proj;
}


defaultproperties {
	AltFireSound=Sound'PulseBolt2'
	AltProjectileClass=Class'HGStarterbolt'
	bHealTeamMembersOnly=true
	CollisionHeight=16
	DownSound=Sound'HGgundown'
	FireSound=Sound'HGPulseFire'
	HealingAmount=1
	Icon=Texture'HGUsePulse'
	ItemName="Healing Gun"
	MaxHealth=500
	MuzzleFlashTexture=Texture'HGMuzzyPulse'
	NameColor=(R=128,G=255,B=128)
	PickupMessage="You got a Healing Gun"
	PickupSound=Sound'HGpickup'
	ProjectileClass=Class'HGPlasmaSphere'
	SelectSound=Sound'HGgunup'
	StatusIcon=Texture'HGUsePulse'
	WeaponDescription="Classification: Plasma Rifle\\n\\nPrimary Fire: Medium sized, fast moving plasma balls are fired at a fast rate of fire.\\n\\nSecondary Fire: A bolt of red is expelled for 100 meters, which will heal all teammates.\\n\\nTechniques: Firing and keeping the secondary fire's beam on a teammate will heal them in seconds."
}

