////////////////////////////////////////////////////////////////////////
//NyanCat Deemer: NyanCatWarShell
///////////////////////////////////////////////////////////////////////
class NyanCatWarshell extends Projectile;

#exec MESH IMPORT MESH=NyanCatDeemer ANIVFILE=MODELS\NyanCatDeemer_a.3d DATAFILE=MODELS\NyanCatDeemer_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=NyanCatDeemer X=0 Y=0 Z=0 Yaw=64

#exec MESH SEQUENCE MESH=NyanCatDeemer SEQ=All STARTFRAME=0 NUMFRAMES=30
//#exec MESH SEQUENCE MESH=NyanCatDeemer SEQ=??? STARTFRAME=0 NUMFRAMES=30

#exec MESHMAP NEW MESHMAP=NyanCatDeemer MESH=NyanCatDeemer
#exec MESHMAP SCALE MESHMAP=NyanCatDeemer X=0.1 Y=0.1 Z=0.2

#exec TEXTURE IMPORT NAME=NyanBody FILE=Textures\Nyan_Cat_Deemer.pcx GROUP=Skins FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=NyanCatDeemer NUM=1 TEXTURE=NyanBody

#exec TEXTURE IMPORT NAME=NyanTop FILE=Textures\Nyan_Cat_Top.pcx GROUP=Skins FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=NyanCatDeemer NUM=2 TEXTURE=NyanTop

#exec AUDIO IMPORT FILE=Sounds\NyanCatWarhead.wav NAME=NiceCat GROUP=NyanCatRedeemer

simulated function PostBeginPlay()
{
	SetTimer(0.05, True);
}

simulated function Timer()
{
	local Nyan_Smoke b;		
	
	b = Spawn(class'Nyan_Smoke');
	b.RemoteRole = ROLE_None;
}

simulated function Destroyed()
{
	Super.Destroyed();
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
						vector momentum, name damageType )
{
	if ( NDamage > 5 )
	{
		PlaySound(Sound'Expl03',,6.0);
		spawn(class'WarExplosion',,,Location);
		HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
		RemoteRole = ROLE_SimulatedProxy;	 		 		
 		Destroy();
	}
}

auto state Flying
{

	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local waterring w;
		
		if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.2;
			w.RemoteRole = ROLE_None; 
		}	
	}

	function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( Other != instigator ) 
			Explode(HitLocation,Normal(HitLocation-Other.Location));
	}

	function Explode(vector HitLocation, vector HitNormal)
	{
		if ( Role < ROLE_Authority )
			return;

		HurtRadius(Damage,300.0, MyDamageType, MomentumTransfer, HitLocation );	 		 		
 		spawn(class'RedShockWave',,,HitLocation+ HitNormal*16);	
		RemoteRole = ROLE_SimulatedProxy;	 		 		
 		Destroy();
	}

	function BeginState()
	{
		local vector InitialDir;

		initialDir = vector(Rotation);
		if ( Role == ROLE_Authority )	
			Velocity = speed*initialDir;
		Acceleration = initialDir*50;
	}
}

defaultproperties
{
     speed=600.000000
     Damage=1000.000000
     MomentumTransfer=100000
     MyDamageType=RedeemerDeath
     ExplosionDecal=Class'Botpack.NuclearMark'
     bNetTemporary=False
     RemoteRole=ROLE_SimulatedProxy
     LODBias=20.000000
     AmbientSound=Sound'NyanCatDeemer.NyanCatRedeemer.NiceCat'
     Mesh=LodMesh'NyanCatDeemer.NyanCatDeemer'
     AmbientGlow=78
     bUnlit=True
     SoundRadius=253
     SoundVolume=255
     CollisionRadius=15.000000
     CollisionHeight=8.000000
     bProjTarget=True
}
