class XM1014 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=XM1014Player ANIVFILE=MODELS\XM1014\XM1014Player_a.3d DATAFILE=MODELS\XM1014\XM1014Player_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=XM1014Player X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=XM1014Pick ANIVFILE=MODELS\XM1014\XM1014Pick_a.3d DATAFILE=MODELS\XM1014\XM1014Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=XM1014Pick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=XM10143rd ANIVFILE=MODELS\XM1014\XM10143rd_a.3d DATAFILE=MODELS\XM1014\XM10143rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=XM10143rd X=0 Y=0 Z=-5 Yaw=192

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=XM1014Player MESH=XM1014Player
#exec MESHMAP SCALE MESHMAP=XM1014Player X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=XM1014Pick MESH=XM1014Pick
#exec MESHMAP SCALE MESHMAP=XM1014Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=XM10143rd MESH=XM10143rd
#exec MESHMAP SCALE MESHMAP=XM10143rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=XM1014Player SEQ=All STARTFRAME=0 NUMFRAMES=131
#exec MESH SEQUENCE MESH=XM1014Player SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec MESH SEQUENCE MESH=XM1014Player SEQ=StartReload STARTFRAME=32 NUMFRAMES=20
#exec MESH SEQUENCE MESH=XM1014Player SEQ=InsertShell STARTFRAME=53 NUMFRAMES=12
#exec MESH SEQUENCE MESH=XM1014Player SEQ=EndReload STARTFRAME=89 NUMFRAMES=12
#exec MESH SEQUENCE MESH=XM1014Player SEQ=Still STARTFRAME=102 NUMFRAMES=8
#exec MESH SEQUENCE MESH=XM1014Player SEQ=Fire STARTFRAME=111 NUMFRAMES=20

//Pickup
#exec MESH SEQUENCE MESH=XM1014Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=XM1014Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=XM10143rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=XM10143rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=XMBarrel FILE=Textures\XM1014\barrel.bmp GROUP=XM1014 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=XMRear FILE=Textures\XM1014\rear_sight.bmp GROUP=XM1014 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=XMShell FILE=Textures\XM1014\shell.bmp GROUP=XM1014 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=XMSkin FILE=Textures\XM1014\view_skin.bmp GROUP=XM1014 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=XMFinger FILE=Textures\XM1014\view_finger.bmp GROUP=XM1014 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=XMFore FILE=Textures\XM1014\ForeArm_Barrel.bmp GROUP=XM1014 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=XMBodyGlove FILE=Textures\XM1014\Body_Glove.bmp GROUP=XM1014 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=XMW FILE=Textures\XM1014\XM1014_w.bmp GROUP=XM1014 FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=XMIcon FILE=Icons\Shotguns\XM1014Icon.bmp GROUP=XM1014 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Player NUM=1 TEXTURE=XMBarrel
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Player NUM=2 TEXTURE=XMRear
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Player NUM=3 TEXTURE=XMShell
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Player NUM=4 TEXTURE=XMSkin
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Player NUM=5 TEXTURE=XMFinger
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Player NUM=6 TEXTURE=XMFore
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Player NUM=7 TEXTURE=XMBodyGlove

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Pick NUM=1 TEXTURE=XMW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=XM10143rd NUM=1 TEXTURE=XMW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="XMFire" FILE=Sounds\XM1014\XM1014_fire.wav GROUP="XM1014"

//=========================================================================================

var() sound ReloadSounds[3];

replication
{
	reliable if(Role == ROLE_Authority)
		ClientReloadStart, ClientReloadInsert, ClientReloadEnd;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.0);
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.0,0.0);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.0);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayAnim('Fire', 1.3, 0.04);
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();
		
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	local int shots;

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		for (shots = 0; shots < 4; shots++)
			TraceFire(12.0);

		bPointing=True;
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount<=0 && AmmoType.AmmoAmount>0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

//---------------------------------------------------------------------------------------------------------------

function ReloadStart()
{
	PlayReloadStart();
	ClientReloadStart();
}

simulated function PlayReloadStart()
{
	PlayAnim('StartReload', 1.2, 0.04);
}

simulated function ClientReloadStart()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadStart();
		GoToState('ClientReloading');
	}
}

//---------------------------------------------------------------------------------------------------------------
function ReloadInsert()
{
	PlayReloadInsert();
	ClientReloadInsert();
}

simulated function PlayReloadInsert()
{
	PlayAnim('InsertShell', 1.3, 0.04);
}

simulated function ClientReloadInsert()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadInsert();
		GoToState('ClientReloading');
	}
}
//---------------------------------------------------------------------------------------------------------------
function ReloadEnd()
{
	PlayReloadEnd();
	ClientReloadEnd();
}

simulated function PlayReloadEnd()
{
	PlayAnim('EndReload', 1.2, 0.04);
}

simulated function ClientReloadEnd()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadEnd();
		GoToState('ClientReloading');
	}
}
//---------------------------------------------------------------------------------------------------------------

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
    	GoToState('NewClip');
    	ClientReload();
    }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
     }
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

Begin:
	ReloadStart();
	FinishAnim();
Shell:
	do
	{
		ReloadInsert();
		Owner.PlaySound(ReloadSounds[1], SLOT_Misc, Pawn(Owner).SoundDampening);
		FinishAnim();
		ClipCount++;
	} until (ClipCount >= Default.Clipcount)
	ReloadEnd();
	FinishAnim();
	Sleep (1.0);
	Finish();
	PlayAnim('Still', 1.5, 0.04);
	FinishAnim();
	GotoState('Idle');
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }
}

/*function AltFire(float Value)
{
	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;
Begin:
	Sleep(1.0);
	GotoState('Idle');
}*/

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local ShellsShotgun s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'ShellsShotgun', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 2.0;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));              
	}
}

defaultproperties
{
	ReloadSounds(0)=Sound'CS_v16.M3.M3Pump'
    ReloadSounds(1)=Sound'CS_v16.M3.M3Insert'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    EjectOffset=(X=25.000000,Y=10.000000,Z=-10.000000)
    FireSound=Sound'CS_v16.XM1014.XMFire'
    HitDamage=25
    VRecoil=800.00
    HRecoil=0.90
    RecoilMultiplier=0.01
    ClipCount=8
    PickupAmmoCount=24
    AmmoName=Class'CS_v16.AmmoShotgun'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-10.000000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.700000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.080000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
    AutoSwitchPriority=4
    InventoryGroup=3
    PickupMessage="You got a XM1014 Shotgun."
    ItemName="XM1014 Shotgun"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=LodMesh'XM1014Player'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'XM1014Pick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'XM10143rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
    MuzzleFlashScale=0.200000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'XM1014Pick'
    Icon=Texture'CS_v16.XM1014.XMIcon'
    StatusIcon=Texture'CS_v16.XM1014.XMIcon'
    bNoSmooth=False
    DrawScale=2.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=200.00
}