class USP extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=USPPlayer ANIVFILE=MODELS\USP\USPPlayer3_a.3d DATAFILE=MODELS\USP\USPPlayer3_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=USPPlayer X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=USPPick ANIVFILE=MODELS\USP\USPPick_a.3d DATAFILE=MODELS\USP\USPPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=USPPick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=USP3rd ANIVFILE=MODELS\USP\USP3rd_a.3d DATAFILE=MODELS\USP\USP3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=USP3rd X=0 Y=0 Z=-9 Yaw=128

//========================================================================================

//Scales
//1st Person
#exec MESHMAP NEW MESHMAP=USPPlayer MESH=USPPlayer
#exec MESHMAP SCALE MESHMAP=USPPlayer X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=USPPick MESH=USPPick
#exec MESHMAP SCALE MESHMAP=USPPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=USP3rd MESH=USP3rd
#exec MESHMAP SCALE MESHMAP=USP3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=USPPlayer SEQ=All STARTFRAME=0 NUMFRAMES=636
#exec MESH SEQUENCE MESH=USPPlayer SEQ=SelectUnsilenced STARTFRAME=0 NUMFRAMES=49
#exec MESH SEQUENCE MESH=USPPlayer SEQ=SelectSilenced STARTFRAME=50 NUMFRAMES=48
#exec MESH SEQUENCE MESH=USPPlayer SEQ=IdleUnSilenced STARTFRAME=99 NUMFRAMES=30
#exec MESH SEQUENCE MESH=USPPlayer SEQ=IdleSilenced STARTFRAME=130 NUMFRAMES=10
#exec MESH SEQUENCE MESH=USPPlayer SEQ=AddSilencer STARTFRAME=141 NUMFRAMES=115
#exec MESH SEQUENCE MESH=USPPlayer SEQ=RemoveSilencer STARTFRAME=257 NUMFRAMES=115
#exec MESH SEQUENCE MESH=USPPlayer SEQ=ReloadUnSilenced STARTFRAME=373 NUMFRAMES=100
#exec MESH SEQUENCE MESH=USPPlayer SEQ=ReloadSilenced STARTFRAME=474 NUMFRAMES=100
#exec MESH SEQUENCE MESH=USPPlayer SEQ=FireUnSilenced STARTFRAME=575 NUMFRAMES=30
#exec MESH SEQUENCE MESH=USPPlayer SEQ=FireSilenced STARTFRAME=606 NUMFRAMES=30

//Pickup
#exec MESH SEQUENCE MESH=USPPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=USPPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=USP3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=USP3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=Slide FILE=Textures\USP\Slide.bmp GROUP=USP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=Handle FILE=Textures\USP\Handle.bmp GROUP=USP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=Magazine FILE=Textures\USP\Magazine.bmp GROUP=USP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=Silencer FILE=Textures\USP\Silencer.bmp GROUP=USP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=ViewGlove FILE=Textures\USP\view_glove.bmp GROUP=USP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=ViewSkin FILE=Textures\USP\view_skin.bmp GROUP=USP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=ViewFinger FILE=Textures\USP\view_finger.bmp GROUP=USP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=USPSkin FILE=Textures\USP\USP_Skin.bmp GROUP=USP FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=USPIcon FILE=Icons\Pistols\USPIcon.bmp GROUP=USP MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=USPPlayer NUM=1 TEXTURE=Slide
#exec MESHMAP SETTEXTURE MESHMAP=USPPlayer NUM=2 TEXTURE=Handle
#exec MESHMAP SETTEXTURE MESHMAP=USPPlayer NUM=3 TEXTURE=Magazine
#exec MESHMAP SETTEXTURE MESHMAP=USPPlayer NUM=4 TEXTURE=Silencer
#exec MESHMAP SETTEXTURE MESHMAP=USPPlayer NUM=5 TEXTURE=ViewGlove
#exec MESHMAP SETTEXTURE MESHMAP=USPPlayer NUM=6 TEXTURE=ViewSkin
#exec MESHMAP SETTEXTURE MESHMAP=USPPlayer NUM=7 TEXTURE=ViewFinger

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=USPPick NUM=1 TEXTURE=USPSkin

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=USP3rd NUM=1 TEXTURE=USPSkin

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="USPFire" FILE=Sounds\USP\usp_fire.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPFireSil" FILE=Sounds\USP\usp_fire_sil.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPClipIn" FILE=Sounds\USP\usp_clipin.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPClipOut" FILE=Sounds\USP\usp_clipout.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPAddSil" FILE=Sounds\USP\usp_silencer_on.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPRemoveSil" FILE=Sounds\USP\usp_silencer_off.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPSlideBack" FILE=Sounds\USP\usp_slideback.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPSlideRelease" FILE=Sounds\USP\usp_sliderelease.wav GROUP="USP"

//=========================================================================================

var int FireMode;				//0 = Normal, 1 = Silenced
var Sound ReloadSounds[5];
var Sound AddSilencerSound;
var Sound RemoveSilencerSound;

Replication
{
	reliable if(bNetOwner && Role == ROLE_Authority)
		FireMode;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	if(FireMode == 0)
		PlayAnim('SelectUnSilenced', 1.4, 0.04);
	else if(FireMode == 1)
		PlayAnim('SelectSilenced', 1.4, 0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
	else if(EventType == 'DoSilencer')
		PlaySilencer();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		if(FireMode == 0)
			PlayAnim('SelectUnSilenced', 1.4, 0.04);
		else if(FireMode == 1)
			PlayAnim('SelectSilenced', 1.4, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	if(FireMode == 0)
		PlayAnim('SelectUnSilenced', 1.4, 0.04);
	else if(FireMode == 1)
		PlayAnim('SelectSilenced', 1.4, 0.04);
	GoToState('Selector');	
}

simulated function PlayFiring()
{
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));

	if(FireMode == 0)
		PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	else if(FireMode == 1)
		PlayOwnedSound(AltFireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	if(!Owner.IsA('Bot'))
	{
		if(FireMode == 0)
			PlayAnim('FireUnSilenced', 1.3, 0.04);
		else if(FireMode == 1)
			PlayAnim('FireSilenced', 1.3, 0.04);
	}
	else if(Owner.IsA('Bot'))
		PlayAnim('FireUnSilenced',4.5, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	//if ((PlayerPawn(Owner) != None))

	bMuzzleFlash++;
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		bCanClientFire = true;
        ClientFire(Value);
        if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');

		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

simulated function PlayReload()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		if(FireMode == 0)
			PlayAnim('ReloadUnSilenced', 1.0, 0.05);
		else if(FireMode == 1)
			PlayAnim('ReloadSilenced', 1.0, 0.05);
	}
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			bMuzzleFlashParticles = False;
			bSteadyFlash3rd = False;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		bMuzzleFlashParticles = True;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if (Pawn(Owner).bFire != 0)
	{
		bSteadyFlash3rd = False;
		bMuzzleFlashParticles = False;
		GoTo('Begin');
	}
	else
		Finish();
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

/*state ClientFiring
{
	ignores Fire, AltFire;

 	simulated function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			bMuzzleFlashParticles = False;
		}
	}

	simulated function EndState()
	{
		OldFlashCount = FlashCount;
		bMuzzleFlashParticles = True;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if (Pawn(Owner).bFire != 0)
	{
		bSteadyFlash3rd = False;
		bMuzzleFlashParticles = False;
		GoTo('Begin');
	}
	else
		Finish();
}*/

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     if(FireMode == 0)
		PlayAnim('ReloadUnSilenced', 1.0, 0.05);
	else if(FireMode == 1)
		PlayAnim('ReloadSilenced', 1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.72); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.72); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated function PlayAltFiring()
{
	if(FireMode == 0)
	{
		PlayAnim('RemoveSilencer', 1.3, 0.04);
	}
	else if(FireMode == 1)
	{
		PlayAnim('AddSilencer', 1.3, 0.04);
	}
}

simulated function PlaySilencer()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		if(FireMode == 0)
		{
			PlayAnim('AddSilencer', 1.3, 0.04);
		}
		else if(FireMode == 1)
		{
			PlayAnim('RemoveSilencer', 1.3, 0.04);
		}
	}
}

function AltFire(float Value)
{
	if(FireMode == 0)
		FireMode = 1;
	else if(FireMode == 1)
		FireMode = 0;

	if(Level.NetMode == NM_DedicatedServer)
	{
		if (PlayerPawn(Owner) != None) 
			PlayerPawn(Owner).ClientWeaponEvent('DoSilencer');
	}

	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;

Begin:
	if(FireMode == 0)
	{
		Sleep(1.0);
		Owner.PlaySound(AddSilencerSound,SLOT_None,Pawn(Owner).SoundDampening);
	}
	else if(FireMode == 1)
	{
		Sleep(0.65);
		Owner.PlaySound(RemoveSilencerSound,SLOT_None,Pawn(Owner).SoundDampening);
	}
	FinishAnim();
	Finish();
}

simulated function TweenToStill()
{
	if(FireMode == 0)
		TweenAnim('IdleUnSilenced',1.0);
	else if(FireMode == 1)
		TweenAnim('IdleSilenced',1.0);
}

simulated state Idle
{
Begin:
	if(FireMode == 0)
		TweenAnim('IdleUnSilenced',1.0);
	else if(FireMode == 1)
		TweenAnim('IdleSilenced',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	ReloadSounds(0)=Sound'CS_v16.USP.USPClipOut'
    ReloadSounds(1)=Sound'CS_v16.USP.USPClipIn'
    ReloadSounds(2)=Sound'CS_v16.USP.USPSlideBack'
    ReloadSounds(3)=Sound'CS_v16.USP.USPSlideRelease'
    AddSilencerSound=Sound'CS_v16.USP.USPRemoveSil'
    RemoveSilencerSound=Sound'CS_v16.USP.USPAddSil'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.USP.USPFire'
    AltFireSound=Sound'CS_v16.USP.USPFireSil'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=17
    ClipCount=12
    PickupAmmoCount=24
    VRecoil=550.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.250000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.012000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16.Deagle.PistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a USP."
    ItemName="USP"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=LodMesh'USPPlayer'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'USPPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'USP3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.PistolMuzz'
    MuzzleFlashScale=0.080000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'USPPick'
    bNoSmooth=False
    Icon=Texture'CS_v16.USP.USPIcon'
    StatusIcon=Texture'CS_v16.USP.USPIcon'
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=15.00
}