class TMP extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=TMPPlayer ANIVFILE=MODELS\TMP\TMPPlayer_a.3d DATAFILE=MODELS\TMP\TMPPlayer_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TMPPlayer X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=TMPPick ANIVFILE=MODELS\TMP\TMPPick_a.3d DATAFILE=MODELS\TMP\TMPPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TMPPick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=TMP3rd ANIVFILE=MODELS\TMP\TMP3rd_a.3d DATAFILE=MODELS\TMP\TMP3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TMP3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=TMPPlayer MESH=TMPPlayer
#exec MESHMAP SCALE MESHMAP=TMPPlayer X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=TMPPick MESH=TMPPick
#exec MESHMAP SCALE MESHMAP=TMPPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=TMP3rd MESH=TMP3rd
#exec MESHMAP SCALE MESHMAP=TMP3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=TMPPlayer SEQ=All STARTFRAME=0 NUMFRAMES=93
#exec MESH SEQUENCE MESH=TMPPlayer SEQ=Select STARTFRAME=0 NUMFRAMES=17
#exec MESH SEQUENCE MESH=TMPPlayer SEQ=Still STARTFRAME=18 NUMFRAMES=8
#exec MESH SEQUENCE MESH=TMPPlayer SEQ=Reload STARTFRAME=27 NUMFRAMES=53
#exec MESH SEQUENCE MESH=TMPPlayer SEQ=Fire STARTFRAME=81 NUMFRAMES=12

//Pickup
#exec MESH SEQUENCE MESH=TMPPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TMPPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=TMP3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=TMP3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=TMPBody FILE=Textures\TMP\body.bmp GROUP=TMP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=TMPMisc FILE=Textures\TMP\misc.bmp GROUP=TMP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=TMPGlove FILE=Textures\TMP\view_glove.bmp GROUP=TMP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=TMPSkin FILE=Textures\TMP\view_skin.bmp GROUP=TMP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=TMPMain FILE=Textures\TMP\TMP.bmp GROUP=TMP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=TMPW FILE=Textures\TMP\w_TMP.bmp GROUP=TMP FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=TMPIcon FILE=Icons\SMG\TMPIcon.bmp GROUP=TMP MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=TMPPlayer NUM=1 TEXTURE=TMPBody
#exec MESHMAP SETTEXTURE MESHMAP=TMPPlayer NUM=2 TEXTURE=TMPMisc
#exec MESHMAP SETTEXTURE MESHMAP=TMPPlayer NUM=3 TEXTURE=TMPGlove
#exec MESHMAP SETTEXTURE MESHMAP=TMPPlayer NUM=4 TEXTURE=TMPSkin
#exec MESHMAP SETTEXTURE MESHMAP=TMPPlayer NUM=5 TEXTURE=TMPMain

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=TMPPick NUM=1 TEXTURE=TMPW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=TMP3rd NUM=1 TEXTURE=TMPW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="TMPFire" FILE=Sounds\TMP\tmp_fire.wav GROUP="TMP"

//=========================================================================================

Var() sound ReloadSounds;
var Texture RandFlash[9];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',0.8,0.0);
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',0.8,0.0);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.0);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 6, 0.04);
	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.7, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds, SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds, SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

/*simulated function PlayAltFiring()
{
	PlayAnim('Still', 10.1, 0.05);
}

function AltFire(float Value)
{
	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;
Begin:
	FinishAnim();
	Finish();
}*/

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	//bAltIronSight=True
	RandFlash(0)=Texture'CS_v16.MP5.SMGMuzz1'
	RandFlash(1)=Texture'CS_v16.MP5.SMGMuzz2'
	RandFlash(2)=Texture'CS_v16.MP5.SMGMuzz3'
	RandFlash(3)=Texture'CS_v16.MP5.SMGMuzz4'
	RandFlash(4)=Texture'CS_v16.MP5.SMGMuzz5'
	RandFlash(5)=Texture'CS_v16.MP5.SMGMuzz6'
	RandFlash(6)=Texture'CS_v16.MP5.SMGMuzz7'
	RandFlash(7)=Texture'CS_v16.MP5.SMGMuzz8'
	RandFlash(8)=Texture'CS_v16.MP5.SMGMuzz9'
    ReloadSounds=Sound'CS_v16.Glock.GlockReload'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.TMP.TMPFire'
    EjectOffset=(X=30.000000,Y=20.000000,Z=-10.000000)
    HitDamage=18
    ClipCount=35
    VRecoil=350.00
    HRecoil=0.90
    RecoilMultiplier=0.01
    PickupAmmoCount=70
    AmmoName=Class'CS_v16.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.600000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.250000
    FlashY=0.110000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CS_v16.MP5.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a TMP."
    ItemName="TMP"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=17.000000
    PlayerViewMesh=LodMesh'CS_v16.TMPPlayer'
    PickupViewMesh=LodMesh'TMPPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'TMP3rd'
    ThirdPersonScale=2.20000
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.SubRMuzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'TMPPick'
    bNoSmooth=False
    Icon=Texture'CS_v16.TMP.TMPIcon'
    StatusIcon=Texture'CS_v16.TMP.TMPIcon'
    DrawScale=3.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}