class P90 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=P90Player ANIVFILE=MODELS\P90\P90Player_a.3d DATAFILE=MODELS\P90\P90Player_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P90Player X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=P90Pick ANIVFILE=MODELS\P90\P90Pick_a.3d DATAFILE=MODELS\P90\P90Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P90Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=P903rd ANIVFILE=MODELS\P90\P903rd_a.3d DATAFILE=MODELS\P90\P903rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P903rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=P90Player MESH=P90Player
#exec MESHMAP SCALE MESHMAP=P90Player X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=P90Pick MESH=P90Pick
#exec MESHMAP SCALE MESHMAP=P90Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=P903rd MESH=P903rd
#exec MESHMAP SCALE MESHMAP=P903rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=P90Player SEQ=All STARTFRAME=0 NUMFRAMES=189
#exec MESH SEQUENCE MESH=P90Player SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec MESH SEQUENCE MESH=P90Player SEQ=Still STARTFRAME=32 NUMFRAMES=8
#exec MESH SEQUENCE MESH=P90Player SEQ=Reload STARTFRAME=41 NUMFRAMES=135
#exec MESH SEQUENCE MESH=P90Player SEQ=Fire STARTFRAME=177 NUMFRAMES=12

//Pickup
#exec MESH SEQUENCE MESH=P90Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P90Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=P903rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=P903rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=P90Sights1 FILE=Textures\P90\sights1.bmp GROUP=P90 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=P90Handles FILE=Textures\P90\handles.bmp GROUP=P90 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=P90Magazine FILE=Textures\P90\magazine.bmp GROUP=P90 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=P90Skin FILE=Textures\P90\view_skin.bmp GROUP=P90 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=P90BF FILE=Textures\P90\p90bf.bmp GROUP=P90 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=P90BG FILE=Textures\P90\p90bg.bmp GROUP=P90 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=P90W FILE=Textures\P90\w_p90.bmp GROUP=P90 FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=P90Icon FILE=Icons\SMG\P90Icon.bmp GROUP=P90 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=P90Player NUM=1 TEXTURE=P90Sights1
#exec MESHMAP SETTEXTURE MESHMAP=P90Player NUM=2 TEXTURE=P90Handles
#exec MESHMAP SETTEXTURE MESHMAP=P90Player NUM=3 TEXTURE=P90Magazine
#exec MESHMAP SETTEXTURE MESHMAP=P90Player NUM=4 TEXTURE=P90Skin
#exec MESHMAP SETTEXTURE MESHMAP=P90Player NUM=5 TEXTURE=P90BF
#exec MESHMAP SETTEXTURE MESHMAP=P90Player NUM=6 TEXTURE=P90BG

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=P90Pick NUM=1 TEXTURE=P90W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=P903rd NUM=1 TEXTURE=P90W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="P90Fire" FILE=Sounds\P90\p90_fire.wav GROUP="P90"
#exec AUDIO IMPORT NAME="P90ClipIn" FILE=Sounds\P90\p90_Clipin.wav GROUP="P90"
#exec AUDIO IMPORT NAME="P90ClipOut" FILE=Sounds\P90\p90_CLipOut.wav GROUP="P90"
#exec AUDIO IMPORT NAME="P90ClipRelease" FILE=Sounds\P90\p90_cliprelease.wav GROUP="P90"
#exec AUDIO IMPORT NAME="P90BoltPull" FILE=Sounds\P90\p90_boltpull.wav GROUP="P90"

//=========================================================================================

Var() sound ReloadSounds[5];
var Texture RandFlash[9];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',0.8,0.0);
	Sleep(0.45);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',0.8,0.0);
		GoToState('Selector');
	}
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[3], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.45);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.0);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 7, 0.04);
	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		MFTexture = RandFlash[Rand(8)];
		bMuzzleFlash++;
	}
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.04);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

/*simulated function PlayAltFiring()
{
	PlayAnim('Still', 10.1, 0.05);
}

function AltFire(float Value)
{
	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;
Begin:
	FinishAnim();
	Finish();
}*/

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16.MP5.SMGMuzz1'
	RandFlash(1)=Texture'CS_v16.MP5.SMGMuzz2'
	RandFlash(2)=Texture'CS_v16.MP5.SMGMuzz3'
	RandFlash(3)=Texture'CS_v16.MP5.SMGMuzz4'
	RandFlash(4)=Texture'CS_v16.MP5.SMGMuzz5'
	RandFlash(5)=Texture'CS_v16.MP5.SMGMuzz6'
	RandFlash(6)=Texture'CS_v16.MP5.SMGMuzz7'
	RandFlash(7)=Texture'CS_v16.MP5.SMGMuzz8'
	RandFlash(8)=Texture'CS_v16.MP5.SMGMuzz9'
    ReloadSounds(0)=Sound'CS_v16.P90.P90ClipRelease'
    ReloadSounds(1)=Sound'CS_v16.P90.P90ClipOut'
    ReloadSounds(2)=Sound'CS_v16.P90.P90ClipIn'
    ReloadSounds(3)=Sound'CS_v16.P90.P90BoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.P90.P90Fire'
    EjectOffset=(X=30.000000,Y=20.000000,Z=-10.000000)
    HitDamage=18
    ClipCount=50
    PickupAmmoCount=100
    AmmoName=Class'CS_v16.AmmoSMG'
    bInstantHit=True
   	FireOffset=(X=0.00,Y=0.000000,Z=0.000000),
   	MuzzleOffset=(X=0.00,Y=-11.600000,Z=-10.000000)
    MyDamageType=shot
    VRecoil=350.00
    HRecoil=0.90
    RecoilMultiplier=0.01
    AltDamageType=Decapitated
    AIRating=0.600000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.120000
    FlashO=0.012000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CS_v16.MP5.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a P90."
    ItemName="P90"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=17.000000
    PlayerViewMesh=LodMesh'CS_v16.P90Player'
    PickupViewMesh=LodMesh'P90Pick'
    PickupViewScale=2.000000
    ThirdPersonMesh=LodMesh'P903rd'
    ThirdPersonScale=1.80
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.SubRMuzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'P90Pick'
    bNoSmooth=False
    Icon=Texture'CS_v16.P90.P90Icon'
    StatusIcon=Texture'CS_v16.P90.P90Icon'
    DrawScale=2.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}