class MP5 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=MP5Player2 ANIVFILE=MODELS\MP5\MP5Player2_a.3d DATAFILE=MODELS\MP5\MP5Player2_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MP5Player2 X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=MP5Pick ANIVFILE=MODELS\MP5\MP5Pick_a.3d DATAFILE=MODELS\MP5\MP5Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MP5Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=MP53rd ANIVFILE=MODELS\MP5\MP53rd_a.3d DATAFILE=MODELS\MP5\MP53rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MP53rd X=0 Y=0 Z=-9 Yaw=64

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=MP5Player2 MESH=MP5Player2
#exec MESHMAP SCALE MESHMAP=MP5Player2 X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=MP5Pick MESH=MP5Pick
#exec MESHMAP SCALE MESHMAP=MP5Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=MP53rd MESH=MP53rd
#exec MESHMAP SCALE MESHMAP=MP53rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=MP5Player2 SEQ=All STARTFRAME=0 NUMFRAMES=162
#exec MESH SEQUENCE MESH=MP5Player2 SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec MESH SEQUENCE MESH=MP5Player2 SEQ=Still STARTFRAME=32 NUMFRAMES=8
#exec MESH SEQUENCE MESH=MP5Player2 SEQ=Reload STARTFRAME=41 NUMFRAMES=100
#exec MESH SEQUENCE MESH=MP5Player2 SEQ=Fire STARTFRAME=142 NUMFRAMES=20

//Pickup
#exec MESH SEQUENCE MESH=MP5Pick SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=MP5Pick SEQ=Still STARTFRAME=0 NUMFRAMES=30

//3rd Person
#exec MESH SEQUENCE MESH=MP53rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MP53rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Textures

#exec TEXTURE IMPORT NAME=MP5Barrel FILE=Textures\MP5\barrel.bmp GROUP=MP5 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=MP5Clip FILE=Textures\MP5\clip.bmp GROUP=MP5 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=MP5ViewSkin FILE=Textures\MP5\view_skin.bmp GROUP=MP5 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=MP5HG FILE=Textures\MP5\MP5HG.bmp GROUP=MP5 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=MP5FLR FILE=Textures\MP5\MP5FLR.bmp GROUP=MP5 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=MP5BF FILE=Textures\MP5\MP5BF.bmp GROUP=MP5 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=WMP5 FILE=Textures\MP5\w_MP5.bmp GROUP=MP5 FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=MP5Icon FILE=Icons\SMG\MP5Icon.bmp GROUP=MP5 MIPS=OFF

#exec TEXTURE IMPORT NAME=SMGMuzz1 FILE=Textures\SMGMuzz1.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz2 FILE=Textures\SMGMuzz2.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz3 FILE=Textures\SMGMuzz3.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz4 FILE=Textures\SMGMuzz4.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz5 FILE=Textures\SMGMuzz5.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz6 FILE=Textures\SMGMuzz6.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz7 FILE=Textures\SMGMuzz7.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz8 FILE=Textures\SMGMuzz8.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz9 FILE=Textures\SMGMuzz9.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=MP5Player2 NUM=1 TEXTURE=MP5Barrel
#exec MESHMAP SETTEXTURE MESHMAP=MP5Player2 NUM=2 TEXTURE=MP5Clip
#exec MESHMAP SETTEXTURE MESHMAP=MP5Player2 NUM=3 TEXTURE=MP5ViewSkin
#exec MESHMAP SETTEXTURE MESHMAP=MP5Player2 NUM=4 TEXTURE=MP5HG
#exec MESHMAP SETTEXTURE MESHMAP=MP5Player2 NUM=5 TEXTURE=MP5FLR
#exec MESHMAP SETTEXTURE MESHMAP=MP5Player2 NUM=6 TEXTURE=MP5BF

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=MP5Pick NUM=1 TEXTURE=WMP5

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=MP53rd NUM=1 TEXTURE=WMP5

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="MP5Fire" FILE=Sounds\MP5\mp5_fire.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5ClipIn" FILE=Sounds\MP5\mp5_clipin.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5ClipOut" FILE=Sounds\MP5\mp5_clipout.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5SlideBack" FILE=Sounds\MP5\mp5_slideback.wav GROUP="MP5"

//=========================================================================================

Var() sound ReloadSounds[4];
Var Texture RandFlash[9];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',0.8,0.0);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',0.8,0.0);
		GoToState('Selector');
	}
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.0);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 10, 0.04);
	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	ignores Fire, AltFire;

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.3, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

/*simulated function PlayAltFiring()
{
	PlayAnim('Still', 10.1, 0.05);
}

function AltFire(float Value)
{
	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;
Begin:
	FinishAnim();
	Finish();
}*/

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16.MP5.SMGMuzz1'
	RandFlash(1)=Texture'CS_v16.MP5.SMGMuzz2'
	RandFlash(2)=Texture'CS_v16.MP5.SMGMuzz3'
	RandFlash(3)=Texture'CS_v16.MP5.SMGMuzz4'
	RandFlash(4)=Texture'CS_v16.MP5.SMGMuzz5'
	RandFlash(5)=Texture'CS_v16.MP5.SMGMuzz6'
	RandFlash(6)=Texture'CS_v16.MP5.SMGMuzz7'
	RandFlash(7)=Texture'CS_v16.MP5.SMGMuzz8'
	RandFlash(8)=Texture'CS_v16.MP5.SMGMuzz9'
    ReloadSounds(0)=Sound'CS_v16.MP5.MP5ClipIn'
    ReloadSounds(1)=Sound'CS_v16.MP5.MP5ClipOut'
    ReloadSounds(2)=Sound'CS_v16.MP5.MP5SlideBack'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.MP5.MP5Fire'
    EjectOffset=(X=30.000000,Y=20.000000,Z=-10.000000)
    HitDamage=18
    ClipCount=30
    PickupAmmoCount=60
    VRecoil=300.00
    HRecoil=0.90
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.600000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CS_v16.MP5.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a MP5."
    ItemName="MP5"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=17.000000
    PlayerViewMesh=LodMesh'CS_v16.MP5Player2'
    PickupViewMesh=LodMesh'MP5Pick'
    PickupViewScale=2.000000
    ThirdPersonMesh=LodMesh'MP53rd'
    ThirdPersonScale=1.800000
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.SubRMuzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'MP5Pick'
    bNoSmooth=False
    Icon=Texture'CS_v16.MP5.MP5Icon'
    StatusIcon=Texture'CS_v16.MP5.MP5Icon'
    DrawScale=2.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}