class M249 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=M249Player ANIVFILE=MODELS\M249\M249Player_a.3d DATAFILE=MODELS\M249\M249Player_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M249Player X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=M249Pick ANIVFILE=MODELS\M249\M249Pick_a.3d DATAFILE=MODELS\M249\M249Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M249Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=M2493rd ANIVFILE=MODELS\M249\M2493rd_a.3d DATAFILE=MODELS\M249\M2493rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M2493rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=M249Player MESH=M249Player
#exec MESHMAP SCALE MESHMAP=M249Player X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=M249Pick MESH=M249Pick
#exec MESHMAP SCALE MESHMAP=M249Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=M2493rd MESH=M2493rd
#exec MESHMAP SCALE MESHMAP=M2493rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=M249Player SEQ=All STARTFRAME=0 NUMFRAMES=199
#exec MESH SEQUENCE MESH=M249Player SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec MESH SEQUENCE MESH=M249Player SEQ=Still STARTFRAME=32 NUMFRAMES=10
#exec MESH SEQUENCE MESH=M249Player SEQ=Reload STARTFRAME=43 NUMFRAMES=140
#exec MESH SEQUENCE MESH=M249Player SEQ=Fire STARTFRAME=184 NUMFRAMES=15

//Pickup
#exec MESH SEQUENCE MESH=M249Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M249Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=M2493rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=M2493rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=M249Sight FILE=Textures\M249\sight.bmp GROUP=M249 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=M249glove FILE=Textures\M249\view_glove.bmp GROUP=M249 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=M249Skin1 FILE=Textures\M249\m249_skin1.bmp GROUP=M249 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=M249Skin2 FILE=Textures\M249\m249_skin2.bmp GROUP=M249 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=M249Skin3 FILE=Textures\M249\m249_skin3.bmp GROUP=M249 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=M249Skin4 FILE=Textures\M249\m249_skin4.bmp GROUP=M249 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=M249W FILE=Textures\M249\w_m249.bmp GROUP=M249 FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=M249Icon FILE=Icons\Heavy\m249Icon.bmp GROUP=M249 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=M249Player NUM=1 TEXTURE=M249Sight
#exec MESHMAP SETTEXTURE MESHMAP=M249Player NUM=2 TEXTURE=M249glove
#exec MESHMAP SETTEXTURE MESHMAP=M249Player NUM=3 TEXTURE=M249Skin1
#exec MESHMAP SETTEXTURE MESHMAP=M249Player NUM=4 TEXTURE=M249Skin2
#exec MESHMAP SETTEXTURE MESHMAP=M249Player NUM=5 TEXTURE=M249Skin3
#exec MESHMAP SETTEXTURE MESHMAP=M249Player NUM=6 TEXTURE=M249Skin4

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=M249Pick NUM=1 TEXTURE=M249W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=M2493rd NUM=1 TEXTURE=M249W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="M249Fire" FILE=Sounds\M249\m249_fire.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249Boxin" FILE=Sounds\M249\m249_boxin.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249BoxOut" FILE=Sounds\M249\m249_boxout.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249Chain" FILE=Sounds\M249\m249_chain.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249CoverDown" FILE=Sounds\M249\m249_coverdown.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249CoverUp" FILE=Sounds\M249\m249_coverup.wav GROUP="M249"

//=========================================================================================

var Sound ReloadSounds[6];
var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.5);
	//PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
	 		bDrawMuzzleFlash = True; 
		}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		//Play1stSelectionSound();
		Sleep(0.4);
		//PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 5, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		MFTexture = RandFlash[Rand(5)];
		bMuzzleFlash++;
	}
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

simulated function PlayReload()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Reload', 0.8, 0.05);
	}
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.8, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 46.00;
		else
			Penetration = 40.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16.M249.M249CoverUp'
    ReloadSounds(1)=Sound'CS_v16.M249.M249CoverDown'
    ReloadSounds(2)=Sound'CS_v16.M249.M249Chain'
    ReloadSounds(3)=Sound'CS_v16.M249.M249Boxin'
    ReloadSounds(4)=Sound'CS_v16.M249.M249BoxOut'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.M249.M249Fire'
    EjectOffset=(X=30.000000,Y=20.000000,Z=-10.000000)
    HitDamage=48
    ClipCount=100
    PickupAmmoCount=200
    VRecoil=850.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16.AmmoMachine'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-10.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.750000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.080000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Skins.Flakmuz'
    AutoSwitchPriority=8
    InventoryGroup=8
    PickupMessage="You got a M249."
    ItemName="M249"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=LodMesh'M249Player'
    PlayerViewScale=5.000000
    PickupViewMesh=LodMesh'M249Pick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'M2493rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.RifleMuzz2'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'M249Pick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16.M249.M249Icon'
    StatusIcon=Texture'CS_v16.M249.M249Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}