class Knife extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=KnifePlayer ANIVFILE=MODELS\Knife\KnifePlayer_a.3d DATAFILE=MODELS\Knife\KnifePlayer_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=KnifePlayer X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=KnifePick ANIVFILE=MODELS\Knife\KnifePick_a.3d DATAFILE=MODELS\Knife\KnifePick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=KnifePick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=Knife3rd ANIVFILE=MODELS\Knife\Knife3rd_a.3d DATAFILE=MODELS\Knife\Knife3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Knife3rd X=0 Y=0 Z=-7 Yaw=64

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=KnifePlayer MESH=KnifePlayer
#exec MESHMAP SCALE MESHMAP=KnifePlayer X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=KnifePick MESH=KnifePick
#exec MESHMAP SCALE MESHMAP=KnifePick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Knife3rd MESH=Knife3rd
#exec MESHMAP SCALE MESHMAP=Knife3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=KnifePlayer SEQ=All STARTFRAME=0 NUMFRAMES=324
#exec MESH SEQUENCE MESH=KnifePlayer SEQ=Select STARTFRAME=0 NUMFRAMES=46
#exec MESH SEQUENCE MESH=KnifePlayer SEQ=Still STARTFRAME=47 NUMFRAMES=150
#exec MESH SEQUENCE MESH=KnifePlayer SEQ=Fire STARTFRAME=198 NUMFRAMES=65
#exec MESH SEQUENCE MESH=KnifePlayer SEQ=AltFire STARTFRAME=264 NUMFRAMES=60

//Pickup
#exec MESH SEQUENCE MESH=KnifePick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=KnifePick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=Knife3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Knife3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=KnifeSkin FILE=Textures\Knife\KnifeSkin.bmp GROUP=Knife FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=KnifeGlove FILE=Textures\Knife\view_glove.bmp GROUP=Knife FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=KnifeFinger FILE=Textures\Knife\view_finger.bmp GROUP=Knife FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=KnifeSkin2 FILE=Textures\Knife\view_skin.bmp GROUP=Knife FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=Knife3 FILE=Textures\Knife\3rdKnifeSkin.bmp GROUP=Knife FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=KnifePickHandle FILE=Textures\Knife\PickHandle.bmp GROUP=Knife FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=KnifePickHandleTop FILE=Textures\Knife\PickHandle_Top.bmp GROUP=Knife FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=KnifeBlade FILE=Textures\Knife\PickBlade.bmp GROUP=Knife FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=KnifeIcon FILE=Icons\Melee\KnifeIcon.bmp GROUP=Knife MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=KnifePlayer NUM=1 TEXTURE=KnifeSkin
#exec MESHMAP SETTEXTURE MESHMAP=KnifePlayer NUM=2 TEXTURE=KnifeGlove
#exec MESHMAP SETTEXTURE MESHMAP=KnifePlayer NUM=3 TEXTURE=KnifeFinger
#exec MESHMAP SETTEXTURE MESHMAP=KnifePlayer NUM=4 TEXTURE=KnifeSkin2

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=KnifePick NUM=1 TEXTURE=KnifePickHandle
#exec MESHMAP SETTEXTURE MESHMAP=KnifePick NUM=2 TEXTURE=KnifePickHandleTop
#exec MESHMAP SETTEXTURE MESHMAP=KnifePick NUM=3 TEXTURE=KnifeBlade

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Knife3rd NUM=1 TEXTURE=Knife3

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="KnifeHitWall" FILE=Sounds\Knife\Knife_hitwall.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnifeHit" FILE=Sounds\Knife\Knife_PriHit.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnifeStab" FILE=Sounds\Knife\Knife_SecStab.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnifeSelect" FILE=Sounds\Knife\Knife_Select.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnifeSlash" FILE=Sounds\Knife\Knife_Slash.wav GROUP="Knife"

//=========================================================================================

var Sound HitWallSound, SlashSound, HitSound, StabSound;
var Playerpawn LastHit;
var int HitAltDamage;
var float Range;

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;
	local bool bRetreating;
	local Pawn P;

	bUseAltMode = 0;
	P = Pawn(Owner);

	if ( (P == None) || (P.Enemy == None) )
		return 0;

	EnemyDist = VSize(P.Enemy.Location - Owner.Location);
	if ( (EnemyDist < 750) && P.IsA('Bot') && Bot(P).bNovice && (P.Skill <= 2) && !P.Enemy.IsA('Bot') && (ImpactHammer(P.Enemy.Weapon) != None) )
		return FClamp(300/(EnemyDist + 1), 0.6, 0.75);

	if ( EnemyDist > 400 )
		return 0.1;
	if ( (P.Weapon != self) && (EnemyDist < 120) )
		return 0.25;

	return ( FMin(0.8, 81/(EnemyDist + 1)) );
}

function float SuggestAttackStyle()
{
	return 10.0;
}

function float SuggestDefenseStyle()
{
	return -2.0;
}

simulated function PlaySelect()
{
	PlayAnim('Select',1.1, 0.0);
	Owner.PlaySound(SelectSound,,255.00);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.1,0.0);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(SelectSound,,255.0);
}

function PlayFire()
{
	JustFire();
	PlayerFire();
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority )) 
		JustFire();
}

simulated function JustFire()
{
	PlayAnim('Fire', 3, 0.04);
	Owner.PlaySound(SlashSound,SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlayFiring()
{
}

function Fire( float Value )
{
	GotoState('NormalFire');
	bPointing=True;
	PlayFire();
	bCanClientFire = true;
	ClientFire(value);
	TraceFire(0.0);
}

state NormalFire
{
	Begin:
		FinishAnim();
		Finish();
}

simulated function PlayAltFiring()
{
}

function PlayAltFire()
{
	JustAltFire();
	PlayerAltFire();
}

simulated function PlayerAltFire()
{
	if ( ( Role < ROLE_Authority )) 
		JustAltFire();
}

simulated function JustAltFire()
{
	PlayAnim('AltFire', 1, 0.04);
	Owner.PlaySound(SlashSound,,255.0);
}

function AltFire( float Value )
{
	GotoState('AltFiring');
	PlayAltFire();
	bCanClientFire = true;
	bPointing=True;
	ClientAltFire(value);
	TraceAltFire(0.0);
}

state AltFiring
{
	Begin:
		FinishAnim();
		Finish();
}

function TraceFire(float accuracy)
{
	local vector HitLocation, HitNormal, EndTrace, X, Y, Z, Start;
	local actor Other;

	LastHit = None;
	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	Start =  Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = pawn(owner).AdjustAim(1000000, Start, 2 * AimError, False, False);	
	EndTrace = Owner.Location + (1 + Range) * vector(AdjustedAim); 
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, Start);

	HitDamage = 30;

	if ( (Other == None) || (Other == Owner) || (Other == self) )
		return;

	if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) && (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
		Other.TakeDamage(40, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
	else
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 66 * X, MyDamageType);
				
	if( Other.bIsPawn || Other.IsA('Carcass'))
	{
		//if (PlayerPawn(Owner) != None) 
			//PlayerPawn(Owner).ClientWeaponEvent('');
		Owner.PlaySound(HitSound,SLOT_Misc, Pawn(Owner).SoundDampening);
	}
		
	if ( !Other.bIsPawn && !Other.IsA('Carcass') )
		Owner.PlaySound(HitWallSound,,255.0);
		
	if ( Other.IsA('PlayerPawn') && (Pawn(Other).Health > 0) )
		LastHit = PlayerPawn(Other);
}

function TraceAltFire(float accuracy)
{
	local vector HitLocation, HitNormal, EndTrace, X, Y, Z, Start;
	local actor Other;

	LastHit = None;
	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	Start =  Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = pawn(owner).AdjustAim(1000000, Start, 2 * AimError, False, False);	
	EndTrace = Owner.Location + (1 + Range) * vector(AdjustedAim); 
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, Start);

	HitAltDamage = 55;

	if ( (Other == None) || (Other == Owner) || (Other == self) )
		return;

	if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) && (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
		Other.TakeDamage(80, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
	else
		Other.TakeDamage(HitAltDamage, Pawn(Owner), HitLocation, 66 * X, MyDamageType);
				
	if( Other.bIsPawn || Other.IsA('Carcass'))
	{
		//if (PlayerPawn(Owner) != None) 
			//PlayerPawn(Owner).ClientWeaponEvent('');
		Owner.PlaySound(StabSound,SLOT_Misc, Pawn(Owner).SoundDampening);
	}
		
	if ( !Other.bIsPawn && !Other.IsA('Carcass') )
		Owner.PlaySound(HitWallSound,,255.0);
		
	if ( Other.IsA('PlayerPawn') && (Pawn(Other).Health > 0) )
		LastHit = PlayerPawn(Other);
}

function Finish()
{
	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if ( PlayerPawn(Owner) == None )
	{
		if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			Global.Fire(0);
		else if ( (Pawn(Owner).bAltFire != 0) && (FRand() < AltRefireRate) )
			Global.AltFire(0);	
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}
	if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}

simulated function PlayIdleAnim()
{
	PlayAnim('Still', 0.5, 0.04);

	if(FRand() < 0.7)
		PlayAnim('Still', 0.5, 0.04);
	else if(VSize(Owner.Velocity) > 10)
		PlayAnim('Still', 0.5, 0.04);
}

defaultproperties
{
	//bAltIronSight=True
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=None
    StabSound=Sound'CS_v16.Knife.KnifeStab'
    HitSound=Sound'CS_v16.Knife.KnifeHit'
    HitWallSound=Sound'CS_v16.Knife.KnifeHitWall'
    SlashSound=Sound'CS_v16.Knife.KnifeSlash'
    SelectSound=Sound'CS_v16.Knife.KnifeSelect'
    Range=50.000000
    HitDamage=30
    HitAltDamage=55
   	bMeleeWeapon=True
    bInstantHit=True
    bAltInstantHit=True
    bWarnTarget=False
    bCanThrow=False
    bRapidFire=True
    FireOffset=(Y=-5.000000,Z=-2.000000)
    MyDamageType=Slashed
    AltDamageType=Decapitated
    AIRating=0.030000
    RefireRate=1.000000
    AltRefireRate=1.000000
    BobDamping=1.11
    AutoSwitchPriority=1
    InventoryGroup=1
    PickupMessage="You got a Knife."
    ItemName="Knife"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=7.00
    PlayerViewMesh=LodMesh'CS_v16.KnifePlayer'
    PickupViewMesh=LodMesh'KnifePick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'Knife3rd'
    ThirdPersonScale=1.80
    Mesh=LodMesh'KnifePick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16.Knife.KnifeIcon'
    StatusIcon=Texture'CS_v16.Knife.KnifeIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}