class GrenadeSmokeGen extends Effects;

var() float SmokeDelay;		// pause between drips
var() float SizeVariance;		// how different each drip is 
var() float BasePuffSize;
var() float RisingVelocity;
var() class<effects> GenerationType;
var() bool bRepeating;

function PostBeginPlay()
{
	SetTimer(SmokeDelay, true);
}

function Timer()
{
	local Effects d;
	
	d = Spawn(GenerationType);
	d.DrawScale = BasePuffSize + FRand() * SizeVariance;
	
	if (UT_SpriteSmokePuff(d)!=None) 
		UT_SpriteSmokePuff(d).RisingRate = RisingVelocity;
}

defaultproperties
{
     SmokeDelay=0.050000
	 LifeSpan=35.000000
     SizeVariance=17.750000
     BasePuffSize=17.750000
     RisingVelocity=75.000000
     GenerationType=Class'Botpack.UT_SpriteSmokePuff'
     bHidden=True
	 bRepeating=True
     bNetTemporary=False
     DrawType=DT_Sprite
     Style=STY_Masked
     Texture=Texture'UnrealShare.Effects.SmokePuff43'
}