class GrenadeSmoke extends GrenadeFrag;

#exec TEXTURE IMPORT NAME=SmokeBody FILE=Textures\SmokeGrenade\smoke_body.bmp GROUP=GrenadeSmoke LODSET=2
#exec TEXTURE IMPORT NAME=SmokeTop FILE=Textures\SmokeGrenade\smoke_top.bmp GROUP=GrenadeSmoke LODSET=2
#exec TEXTURE IMPORT NAME=SmokeSpoon FILE=Textures\SmokeGrenade\smoke_spoon.bmp GROUP=GrenadeSmoke LODSET=2

#exec TEXTURE IMPORT NAME=SmokeBody FILE=Textures\SmokeGrenade\f_body.bmp GROUP=GrenadeSmoke LODSET=2
#exec TEXTURE IMPORT NAME=SmokeTop FILE=Textures\SmokeGrenade\f_top.bmp GROUP=GrenadeSmoke LODSET=2

Simulated Function SpawnGrenade( float grenadeSpeed )
{
	Local GrenadeSmokeProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn( class 'GrenadeSmokeProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
	//NewGrenade();
}

defaultproperties
{
	MultiSkins(1)=Texture'CS_v16.GrenadeSmoke.SmokeBody'
	MultiSkins(2)=Texture'CS_v16.GrenadeSmoke.SmokeTop'
	MultiSkins(3)=Texture'CS_v16.GrenadeSmoke.SmokeSpoon'
	ThrowOffset=(Y=7.000000)
	BaseThrow=300
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CS_v16.FragGrenade.GPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    VRecoil=0.00
    HRecoil=0.00
    RecoilMultiplier=0.00
    PickupAmmoCount=2
    AmmoName=Class'CS_v16.GrenadeSmokeAmmo'
    FireOffset=(X=0.00,Y=-11.600000),
	AIRating=0.200000
    RefireRate=0.700000
    AltRefireRate=0.900000
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a Smoke Grenade."
    ItemName="Smoke Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=4.00
    PlayerViewMesh=LodMesh'CS_v16.FragGrenadePlayer'
    PickupViewMesh=LodMesh'CS_v16.FragPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CS_v16.Frag3rd'
    ThirdPersonScale=1.90
    Mesh=LodMesh'CS_v16.FragPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16.GrenadeFlash.GFlashIcon'
    StatusIcon=Texture'CS_v16.GrenadeFlash.GFlashIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}