class GrenadeFragProj extends Projectile;

#exec AUDIO IMPORT NAME="FragExplode" FILE=Sounds\FragGrenade\frag_explode.wav GROUP="FragGrenade"
#exec AUDIO IMPORT NAME="FragBounce" FILE=Sounds\FragGrenade\he_bounce.wav GROUP="FragGrenade"

var bool bCanHitOwner, bHitWater;
var float Count, SmokeRate;
var ScriptedPawn WarnTarget;	// warn this pawn away
var int NumExtraGrenades;

simulated function PostBeginPlay()
{
	local vector X,Y,Z;
	local rotator RandRot;

	Super.PostBeginPlay();
	
	SetTimer(2.5+FRand()*0.5,false);                  //Grenade begins unarmed

	if ( Role == ROLE_Authority )
	{
		GetAxes(Instigator.ViewRotation,X,Y,Z);	
		Velocity = X * (Instigator.Velocity Dot X)*0.4 + Vector(Rotation) * (Speed +
			FRand() * 100);
		Velocity.z += 210;
		RandRot.Pitch = FRand() * 1400 - 700;
		RandRot.Yaw = FRand() * 1400 - 700;
		RandRot.Roll = FRand() * 1400 - 700;
		MaxSpeed = 1000;
		Velocity = Velocity >> RandRot;
		RandSpin(50000);	
		bCanHitOwner = False;
		if (Instigator.HeadRegion.Zone.bWaterZone)
		{
			bHitWater = True;
			Disable('Tick');
			Velocity=0.6*Velocity;			
		}
	}	
}

function SpawnGrenade()
{
	local vector X,Y,Z;
	local rotator RandRot;

	GetAxes(Rotation,X,Y,Z);	
	Velocity = X * speed + Z*250;
			
	RandRot.Pitch = FRand() * 1400 - 700;
	RandRot.Yaw = FRand() * 1400 - 700;
	RandRot.Roll = FRand() * 1400 - 700;
	MaxSpeed = 1000;
	Velocity = Velocity >> RandRot;
	RandSpin(50000);	
	if (Instigator.HeadRegion.Zone.bWaterZone)
	{
		bHitWater = True;
		Disable('Tick');
		Velocity=0.6*Velocity;			
	}	
}

simulated function Timer()
{
	Explosion(Location+Vect(0,0,1)*16);
}

simulated function Landed( vector HitNormal )
{
	HitWall( HitNormal, None );
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	Velocity = 0.5*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	RandSpin(100000);
	speed = VSize(Velocity);
	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(ImpactSound/*, SLOT_Misc, FMax(0.5, speed/800)*/ );
	if ( Velocity.Z > 400 )
		Velocity.Z = 0.5 * (400 + Velocity.Z);	
	else if ( speed < 30 ) 
	{
		bBounce = False;
		SetPhysics(PHYS_None);
	}
}

Simulated function BlowUp(vector HitLocation)
{
	//PlaySound(MiscSound);
	HurtRadius(Damage, 300, MyDamageType, MomentumTransfer, HitLocation);
	MakeNoise(1.0);
}

simulated function Explosion(vector HitLocation)
{
	local GrenadeFragExpl f;
	//local CSFragSmoke s;

	BlowUp(HitLocation);
	f = spawn(class'GrenadeFragExpl',,,HitLocation);
	f.RemoteRole = ROLE_None;
	Destroy();
}

simulated function Tick(float DeltaTime);

defaultproperties
{
	speed=150.000000
	MaxSpeed=2000.000000
	Damage=350.000000
	MomentumTransfer=100000
	bUnlit=False
	AmbientGlow=0
	Physics=PHYS_Falling
	ImpactSound=Sound'CS_v16.FragGrenade.FragBounce'
	Mesh=LodMesh'CS_v16.FragPick'
	DrawScale=2.000000
	RemoteRole=ROLE_SimulatedProxy
	bBounce=True
    bFixedRotationDir=True
    DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334)
	CollisionRadius=5.000000
	CollisionHeight=5.000000
}