class GrenadeFrag extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=FragGrenadePlayer ANIVFILE=MODELS\FragGrenade\FragPlayer2_a.3d DATAFILE=MODELS\FragGrenade\FragPlayer2_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FragGrenadePlayer X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=FragPick ANIVFILE=MODELS\FragGrenade\FragPick_a.3d DATAFILE=MODELS\FragGrenade\FragPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FragPick X=0 Y=-50 Z=18

//3rd Person
#exec MESH IMPORT MESH=Frag3rd ANIVFILE=MODELS\FragGrenade\Frag3rd_a.3d DATAFILE=MODELS\FragGrenade\Frag3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Frag3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=FragGrenadePlayer MESH=FragGrenadePlayer
#exec MESHMAP SCALE MESHMAP=FragGrenadePlayer X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=FragPick MESH=FragPick
#exec MESHMAP SCALE MESHMAP=FragPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Frag3rd MESH=Frag3rd
#exec MESHMAP SCALE MESHMAP=Frag3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=FragGrenadePlayer SEQ=All STARTFRAME=0 NUMFRAMES=97
#exec MESH SEQUENCE MESH=FragGrenadePlayer SEQ=Select STARTFRAME=0 NUMFRAMES=22
#exec MESH SEQUENCE MESH=FragGrenadePlayer SEQ=Still STARTFRAME=23 NUMFRAMES=10
#exec MESH SEQUENCE MESH=FragGrenadePlayer SEQ=Throw STARTFRAME=33 NUMFRAMES=23
#exec MESH SEQUENCE MESH=FragGrenadePlayer SEQ=Pull STARTFRAME=57 NUMFRAMES=40

//Pickup
#exec MESH SEQUENCE MESH=FragPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FragPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=Frag3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Frag3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=FragBody FILE=Textures\FragGrenade\he_body.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=FragTop FILE=Textures\FragGrenade\he_top.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=FragSpoon FILE=Textures\FragGrenade\he_spoon.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=FragGlove FILE=Textures\FragGrenade\view_glove.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=FragSkin FILE=Textures\FragGrenade\view_skin.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=FragFinger FILE=Textures\FragGrenade\view_finger.bmp GROUP=GrenadeFrag LODSET=2

#exec TEXTURE IMPORT NAME=FragGBody FILE=Textures\FragGrenade\f_body.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=FragGTop FILE=Textures\FragGrenade\f_top.bmp GROUP=GrenadeFrag LODSET=2

#exec TEXTURE IMPORT NAME=GFragIcon FILE=Icons\Grenades\GrenadeFragIcon.bmp GROUP=GrenadeFrag MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=FragGrenadePlayer NUM=1 TEXTURE=FragBody
#exec MESHMAP SETTEXTURE MESHMAP=FragGrenadePlayer NUM=2 TEXTURE=FragTop
#exec MESHMAP SETTEXTURE MESHMAP=FragGrenadePlayer NUM=3 TEXTURE=FragSpoon
#exec MESHMAP SETTEXTURE MESHMAP=FragGrenadePlayer NUM=4 TEXTURE=FragGlove
#exec MESHMAP SETTEXTURE MESHMAP=FragGrenadePlayer NUM=5 TEXTURE=FragSkin
#exec MESHMAP SETTEXTURE MESHMAP=FragGrenadePlayer NUM=6 TEXTURE=FragFinger

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=FragPick NUM=1 TEXTURE=FragGBody
#exec MESHMAP SETTEXTURE MESHMAP=FragPick NUM=2 TEXTURE=FragGTop

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Frag3rd NUM=1 TEXTURE=FragGBody
#exec MESHMAP SETTEXTURE MESHMAP=Frag3rd NUM=2 TEXTURE=FragGTop

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="GPull" FILE=Sounds\FragGrenade\pinpull.wav GROUP="FragGrenade"

//=========================================================================================

Var(CSWeapons) Vector ThrowOffset;
Var Float FuseTime, SecondsHeld, Throw;
Var Bool bPinPulled;
Var() Int BaseThrow;

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'PullMe')
		PlayPullPin();
	else if(EventType == 'ThrowMe')
		PlayThrow();
	else if(EventType == 'SelectMe')
		PlaySelection();
}

simulated function PlayPullPin()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Pull', 1.5, 0.04);
	}
}

simulated function PlayThrow()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Throw', 1.3, 0.04);
	}	
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.35, 0.04);
	}
}

function Fire(float Value)
{
	if(AmmoType.UseAmmo(1))
	{
		bPointing=True;
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);
		bCanClientFire = True;
		ClientFire(Value);
		GoToState('NormalFire');
	}
}

Function AltFire(float Value)
{
	Pawn(Owner).bAltFire = 0;
}

state NormalFire
{
	ignores Fire, AltFire;

Begin:
	PlayAnim('Pull', 1.5, 0.04);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('PullMe');
	Sleep(0.5);
	Owner.PlaySound(Misc1Sound);
	//FinishAnim();\
	PlayAnim('Throw', 1.0, 0.04);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('ThrowMe');
	Sleep(0.3);
	SpawnGrenade(1100);
	//FinishAnim();
	Sleep(0.2);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('SelectMe');
	PlayAnim('Select',1.35, 0.04);
	//FinishAnim();
	//GoTostate('Idle');
}

simulated function SpawnGrenade( float grenadeSpeed )
{
	Local GrenadeFragProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn( class 'GrenadeFragProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
	//NewGrenade();
}

/*function NewGrenade()
{
	bPinPulled = false;
	SecondsHeld = 0.0;
}

state PullingPin
{
	ignores Fire, AltFire;

Begin:
	//FinishAnim();
	PlayAnim('Pull',1.5, 0.04);
	if(Level.NetMode == NM_DedicatedServer)
	{
		if (PlayerPawn(Owner) != None) 
			PlayerPawn(Owner).ClientWeaponEvent('PullMe');
	}
	Sleep(0.5);
	Owner.PlaySound(Misc1Sound);
	FinishAnim();
	bPinPulled = true;
}

function Tick(float DeltaTime)
{
	if (Pawn(Owner) == None)
		return;

	if (bPinPulled)
	{
		if (Pawn(Owner).bFire != 0)
			SecondsHeld += Deltatime;
		else 
		{
			bPinPulled = false;
			GotoState('Throwing');
		}
	}
}*/

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.5);
	//PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

state Idle
{
	
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
}

function Finish()
{
	local Pawn PawnOwner;

	if(bChangeWeapon)
	{
		GotoState('DownWeapon');
		return;
	}
	PawnOwner = Pawn(Owner);
	if(PlayerPawn(Owner)==None)
	{
		if(AmmoType.AmmoAmount<=0)
		{
			PawnOwner.StopFiring();
			PawnOwner.SwitchToBestWeapon();
			if(bChangeWeapon) GotoState('DownWeapon');
		}
		else if((PawnOwner.bFire != 0) && (FRand()<RefireRate))
			Global.Fire(0);
		else if((PawnOwner.bAltFire != 0) && (FRand()<AltRefireRate))
			Global.AltFire(0);
		else
		{ 
			PawnOwner.StopFiring();
			GotoState('Idle');
		}
		return;
	}
	if(AmmoType.AmmoAmount<=0 || PawnOwner.Weapon!=self)
		GotoState('Idle');
	else if(PawnOwner.bFire!=0)
		Global.Fire(0);
	else if(PawnOwner.bAltFire!=0)
		Global.AltFire(0);
	else GotoState('Idle');
}

defaultproperties
{
	ThrowOffset=(Y=7.000000)
	BaseThrow=300
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CS_v16.FragGrenade.GPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    VRecoil=0.00
    HRecoil=0.00
    RecoilMultiplier=0.00
    PickupAmmoCount=2
    AmmoName=Class'CS_v16.GrenadeFragAmmo'
    FireOffset=(X=0.00,Y=-11.600000),
	AIRating=0.270000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bSplashDamage=True
    bRecommendSplashDamage=True
    bWarnTarget=True
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a HE Grenade."
    ItemName="HE Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=4.00
    PlayerViewMesh=LodMesh'CS_v16.FragGrenadePlayer'
    PickupViewMesh=LodMesh'CS_v16.FragPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CS_v16.Frag3rd'
    ThirdPersonScale=1.90
    Mesh=LodMesh'CS_v16.FragPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16.GrenadeFrag.GFragIcon'
    StatusIcon=Texture'CS_v16.GrenadeFrag.GFragIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}