class GrenadeFlashProj extends Projectile;

#exec AUDIO IMPORT NAME="FlashBooom" FILE=Sounds\FlashGrenade\flash_boom.wav GROUP="FlashGrenade"
#exec AUDIO IMPORT NAME="FlashBounce" FILE=Sounds\FlashGrenade\flash_bounce.wav GROUP="FlashGrenade"

var bool bCanHitOwner, bHitWater;
var float Count, SmokeRate;
var ScriptedPawn WarnTarget;	// warn this pawn away
var int NumExtraGrenades;

simulated function PostBeginPlay()
{
	local vector X,Y,Z;
	local rotator RandRot;

	Super.PostBeginPlay();
	
	SetTimer(2.5+FRand()*0.5,false);                  //Grenade begins unarmed

	if ( Role == ROLE_Authority )
	{
		GetAxes(Instigator.ViewRotation,X,Y,Z);	
		Velocity = X * (Instigator.Velocity Dot X)*0.4 + Vector(Rotation) * (Speed +
			FRand() * 100);
		Velocity.z += 210;
		RandRot.Pitch = FRand() * 1400 - 700;
		RandRot.Yaw = FRand() * 1400 - 700;
		RandRot.Roll = FRand() * 1400 - 700;
		MaxSpeed = 1000;
		Velocity = Velocity >> RandRot;
		RandSpin(50000);	
		bCanHitOwner = False;
		if (Instigator.HeadRegion.Zone.bWaterZone)
		{
			bHitWater = True;
			Disable('Tick');
			Velocity=0.6*Velocity;			
		}
	}	
}

function SpawnGrenade()
{
	local vector X,Y,Z;
	local rotator RandRot;

	GetAxes(Rotation,X,Y,Z);	
	Velocity = X * speed + Z*250;
			
	RandRot.Pitch = FRand() * 1400 - 700;
	RandRot.Yaw = FRand() * 1400 - 700;
	RandRot.Roll = FRand() * 1400 - 700;
	MaxSpeed = 1000;
	Velocity = Velocity >> RandRot;
	RandSpin(50000);	
	if (Instigator.HeadRegion.Zone.bWaterZone)
	{
		bHitWater = True;
		Disable('Tick');
		Velocity=0.6*Velocity;			
	}	
}

simulated function Timer()
{
	Explosion(Location+Vect(0,0,1)*16);
}

simulated function Landed( vector HitNormal )
{
	HitWall( HitNormal, None );
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	Velocity = 0.5*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	RandSpin(100000);
	speed = VSize(Velocity);
	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(ImpactSound/*, SLOT_Misc, FMax(0.5, speed/800)*/ );
	if ( Velocity.Z > 400 )
		Velocity.Z = 0.5 * (400 + Velocity.Z);	
	else if ( speed < 30 ) 
	{
		bBounce = False;
		SetPhysics(PHYS_None);
	}
}

Simulated function BlowUp(vector HitLocation)
{
	//PlaySound(MiscSound);
	HurtRadius(Damage, 300, MyDamageType, MomentumTransfer, HitLocation);
	MakeNoise(1.0);
}

//Credits: Wormbo
simulated function Explosion(vector HitLocation)
{
	local Pawn Victims;
	local float Distance, Direction, ScaledRadius;
	local Vector dir;
	local FlashBlindEffect FlashEffect;
	
	if ( bHurtEntry )
		return;
	
	For (Victims = Level.PawnList; Victims != None; Victims = Victims.NextPawn) {
		dir = Victims.Location + vect(0,0,1) * Victims.EyeHeight;
		if ( (Victims.bIsPlayer || !Victims.IsA('StationaryPawn')) && FastTrace(HitLocation, dir) ) {
			dir = HitLocation - dir;
			Distance = VSize(dir);
			Direction = vector(Victims.ViewRotation) dot Normal(dir);
			
			if ( Instigator != None )
				Distance /= Instigator.DamageScaling;
			if ( Instigator.IsA('Bot') && Bot(Instigator).bNovice )
				Distance *= 2;
			
			if ( Victims.bIsPlayer ) {
				if ( Instigator.bIsPlayer
						&& Instigator.PlayerReplicationInfo.Team == Victims.PlayerReplicationInfo.Team )
					Distance *= 2;
				else if ( Instigator.IsA('StationaryPawn')
						&& StationaryPawn(Instigator).SameTeamAs(Victims.PlayerReplicationInfo.Team) )
					Distance *= 2;
			}
			
			FlashEffect = Spawn(class'FlashBlindEffect', Victims);
			if ( FlashEffect != None ) {
				FlashEffect.GiveTo(Victims);
				FlashEffect.SetBlinding(Direction, Distance);
			}
		} 
	}

	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(Sound'FlashBooom'/*, SLOT_Misc, FMax(0.5, speed/800)*/ );

	BlowUp(HitLocation);
	Destroy();
}

simulated function Tick(float DeltaTime);

defaultproperties
{
	speed=150.000000
	MaxSpeed=2000.000000
	Damage=2.000000
	MomentumTransfer=100000
	bUnlit=False
	AmbientGlow=0
	Physics=PHYS_Falling
	ImpactSound=Sound'CS_v16.FlashGrenade.FlashBounce'
	MultiSkins(1)=Texture'CS_v16.GrenadeSmoke.SmokeBody'
	MultiSkins(2)=Texture'CS_v16.GrenadeSmoke.SmokeTop'
	Mesh=LodMesh'CS_v16.FragPick'
	DrawScale=2.000000
	RemoteRole=ROLE_SimulatedProxy
	bBounce=True
    bFixedRotationDir=True
    DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334)
	CollisionRadius=5.000000
	CollisionHeight=5.000000
}