class GrenadeFlash extends GrenadeFrag;

#exec TEXTURE IMPORT NAME=FlashBody FILE=Textures\FlashGrenade\fl_body.bmp GROUP=GrenadeFlash LODSET=2
#exec TEXTURE IMPORT NAME=FlashTop FILE=Textures\FlashGrenade\fl_top.bmp GROUP=GrenadeFlash LODSET=2

#exec TEXTURE IMPORT NAME=GFlashIcon FILE=Icons\Grenades\GrenadeSmokeIcon.bmp GROUP=GrenadeFlash MIPS=OFF

simulated Function SpawnGrenade( float grenadeSpeed )
{
	local GrenadeFlashProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn( class 'GrenadeFlashProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
	//NewGrenade();
}

defaultproperties
{
	MultiSkins(1)=Texture'CS_v16.GrenadeFlash.FlashBody'
	MultiSkins(2)=Texture'CS_v16.GrenadeFlash.FlashTop'
	MultiSkins(3)=Texture'CS_v16.GrenadeFrag.FragSpoon'
	ThrowOffset=(Y=7.000000)
	BaseThrow=300
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CS_v16.FragGrenade.GPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    VRecoil=0.00
    HRecoil=0.00
    RecoilMultiplier=0.00
    PickupAmmoCount=2
    AmmoName=Class'CS_v16.GrenadeFlashAmmo'
    FireOffset=(X=0.00,Y=-11.600000),
	AIRating=0.200000
    RefireRate=0.700000
    AltRefireRate=0.900000
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a Flash Grenade."
    ItemName="Flash Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=4.00
    PlayerViewMesh=LodMesh'CS_v16.FragGrenadePlayer'
    PickupViewMesh=LodMesh'CS_v16.FragPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CS_v16.Frag3rd'
    ThirdPersonScale=1.90
    Mesh=LodMesh'CS_v16.FragPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16.GrenadeFlash.GFlashIcon'
    StatusIcon=Texture'CS_v16.GrenadeFlash.GFlashIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}