class Galil extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=GalilPlayer ANIVFILE=MODELS\Galil\GalilPlayer_a.3d DATAFILE=MODELS\Galil\GalilPlayer_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GalilPlayer X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=GalilPick ANIVFILE=MODELS\Galil\GalilPick_a.3d DATAFILE=MODELS\Galil\GalilPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GalilPick X=0 Y=0 Z=34

//3rd Person
#exec MESH IMPORT MESH=Galil3rd ANIVFILE=MODELS\Galil\Galil3rd_a.3d DATAFILE=MODELS\Galil\Galil3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Galil3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=GalilPlayer MESH=GalilPlayer
#exec MESHMAP SCALE MESHMAP=GalilPlayer X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=GalilPick MESH=GalilPick
#exec MESHMAP SCALE MESHMAP=GalilPick X=0.07 Y=0.07 Z=0.08

//3rd Person
#exec MESHMAP NEW MESHMAP=Galil3rd MESH=Galil3rd
#exec MESHMAP SCALE MESHMAP=Galil3rd X=0.09 Y=0.09 Z=0.16

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=GalilPlayer SEQ=All STARTFRAME=0 NUMFRAMES=160
#exec MESH SEQUENCE MESH=GalilPlayer SEQ=Select STARTFRAME=0 NUMFRAMES=36
#exec MESH SEQUENCE MESH=GalilPlayer SEQ=Still STARTFRAME=37 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GalilPlayer SEQ=Reload STARTFRAME=39 NUMFRAMES=90
#exec MESH SEQUENCE MESH=GalilPlayer SEQ=Fire STARTFRAME=130 NUMFRAMES=30

//Pickup
#exec MESH SEQUENCE MESH=GalilPick SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=GalilPick SEQ=Still STARTFRAME=0 NUMFRAMES=2

//3rd Person
#exec MESH SEQUENCE MESH=Galil3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=Galil3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=GalilMain FILE=Textures\Galil\galil.bmp GROUP=Galil FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=GalilGlove FILE=Textures\Galil\view_glove.bmp GROUP=Galil FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=GalilFinger FILE=Textures\Galil\view_finger.bmp GROUP=Galil FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=GalilSkin FILE=Textures\Galil\view_skin.bmp GROUP=Galil FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=GalilW FILE=Textures\Galil\p_galil.bmp GROUP=Galil FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=GalilIcon FILE=Icons\Rifles\galilIcon.bmp GROUP=Galil MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=GalilPlayer NUM=1 TEXTURE=GalilMain
#exec MESHMAP SETTEXTURE MESHMAP=GalilPlayer NUM=2 TEXTURE=GalilGlove
#exec MESHMAP SETTEXTURE MESHMAP=GalilPlayer NUM=3 TEXTURE=GalilFinger
#exec MESHMAP SETTEXTURE MESHMAP=GalilPlayer NUM=4 TEXTURE=GalilSkin

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=GalilPick NUM=1 TEXTURE=GalilW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Galil3rd NUM=1 TEXTURE=GalilW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="GalilFire" FILE=Sounds\Galil\galil_fire.wav GROUP="Galil"
#exec AUDIO IMPORT NAME="GalilClipIn" FILE=Sounds\Galil\galil_clipin.wav GROUP="Galil"
#exec AUDIO IMPORT NAME="GalilClipOut" FILE=Sounds\Galil\galil_clipout.wav GROUP="Galil"
#exec AUDIO IMPORT NAME="GalilBoltPull" FILE=Sounds\Galil\galil_boltpull.wav GROUP="Galil"

//=========================================================================================

var Sound ReloadSounds[5];
var Texture RandFlash[6];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		//Play1stSelectionSound();
		Sleep(0.4);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[3], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}


function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 11, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

simulated function PlayReload()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Reload', 1.0, 0.05);
	}
}

function Reload()
{
     if ((AmmoType.AmmoAmount > 0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.55); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.55); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16.Galil.GalilClipOut'
    ReloadSounds(1)=Sound'CS_v16.Galil.GalilClipIn'
    ReloadSounds(2)=Sound'CS_v16.Galil.GalilSelect'
    ReloadSounds(3)=Sound'CS_v16.Galil.GalilBoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.Galil.GalilFire'
    EjectOffset=(X=30.000000,Y=20.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=25
    PickupAmmoCount=50
    VRecoil=550.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-7.200000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.730000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=500.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.070000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Skins.Flakmuz'
    AutoSwitchPriority=5
    InventoryGroup=5
    PickupMessage="You got a IDF Defender."
    ItemName="IDF Defender"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=LodMesh'GalilPlayer'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'GalilPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'Galil3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.RifleMuzz2'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'GalilPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16.Galil.GalilIcon'
    StatusIcon=Texture'CS_v16.Galil.GalilIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}