//===============================================================================
//  [DeagleTest] 
//===============================================================================

class DeagleTest extends CSWeapons16;

#exec MESH  MODELIMPORT MESH=DeagleTestMesh MODELFILE=models\Deagle\Deagle.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=DeagleTestMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=DeagleTestAnims ANIMFILE=models\Deagle\DeagleAnim.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=DeagleTestMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=DeagleTestMesh ANIM=DeagleTestAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=DeagleTestAnims SEQ=All STARTFRAME=0 NUMFRAMES=124 RATE=24.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=DeagleTestAnims SEQ=Select STARTFRAME=124 NUMFRAMES=31 RATE=24.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=DeagleTestAnims SEQ=Still STARTFRAME=155 NUMFRAMES=2 RATE=24.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=DeagleTestAnims SEQ=Reload STARTFRAME=157 NUMFRAMES=67 RATE=24.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=DeagleTestAnims SEQ=Fire STARTFRAME=224 NUMFRAMES=23 RATE=24.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=DeagleTestAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=DeagleTestTex0  FILE=TEXTURES\Deagle\DE_handle.bmp  GROUP=Skins
#EXEC TEXTURE IMPORT NAME=DeagleTestTex1  FILE=TEXTURES\Deagle\DE_slide1.bmp  GROUP=Skins
#EXEC TEXTURE IMPORT NAME=DeagleTestTex2  FILE=TEXTURES\Deagle\DE_slide2_eagle.bmp  GROUP=Skins
#EXEC TEXTURE IMPORT NAME=DeagleTestTex3  FILE=TEXTURES\Deagle\view_glove.bmp  GROUP=Skins
#EXEC TEXTURE IMPORT NAME=DeagleTestTex4  FILE=TEXTURES\Deagle\view_Skin.bmp  GROUP=Skins
#EXEC TEXTURE IMPORT NAME=DeagleTestTex5  FILE=TEXTURES\Deagle\view_finger.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=DeagleTestMesh NUM=0 TEXTURE=DeagleTestTex0
#EXEC MESHMAP SETTEXTURE MESHMAP=DeagleTestMesh NUM=1 TEXTURE=DeagleTestTex1

// Original material [0] is [DE_handle.bmp] SkinIndex: 0 Bitmap: DE_handle.bmp  Path:  

var() int Hitdamage;
var() int ClipCount;
var Sound ReloadSounds[3];

Replication
{
	Reliable if(Role==ROLE_Authority)
		Hitdamage,ClipCount;
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist, Rating;
	local bool bRetreating;
	local vector EnemyDir;
	local Pawn P;

	P = Pawn(Owner);

	//No enemy, ready to fire
	if ( P.Enemy == None )
        	return AIRating;

	//Don't recommend self if out of ammo
	if ( AmmoType.AmmoAmount <=0 )
        	return -2;

	EnemyDir = P.Enemy.Location - Owner.Location; 
	EnemyDist = VSize(EnemyDir);

	//Don't recommend second mode if it hasn't ammo for it and other conditions
	if (AmmoType.AmmoAmount < 10 || EnemyDist < 360 || P.Enemy.Region.Zone.bWaterZone || P.Region.Zone.bWaterZone)
		bUseAltMode = 0;
	else
		bUseAltMode = int(FRand() + 0.5);

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.0);
	Sleep(0.5);
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'PrimaryFire')
		PlayPrimaryFire();
	else if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.0,0.0);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	//if (PlayerPawn(Owner) != None) 
		//PlayerPawn(Owner).ClientWeaponEvent('Selecting');
	PlayAnim('Select', 1.0, 0.0);
	GoToState('Selector');
	//Owner.PlaySound(Sound'USPSlideBack', SLOT_None, Pawn(Owner).SoundDampening * 1.0);
	//GoToState('Selected');	
}

simulated function PlayPrimaryFire()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		Owner.PlaySound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
		PlayAnim('Fire', 1.3, 0.04);

		ClipCount--;

		if ( (PlayerPawn(Owner) != None))
			bMuzzleFlash++;
	}
}

//simulated function TweenDown();
simulated function PlayFiring()
{
	Owner.PlaySound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 1.3, 0.04);

	ClipCount--;

	if ( (PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

simulated function PlayReload()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Reload', 1.0, 0.05);
	}
}

state NormalFire
{
	Ignores AltFire;

	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if (Pawn(Owner).bFire!=0)
		GoTo('Begin');
	Else
		Finish();
}

simulated State NewClip
{
	ignores Fire, AltFire;

	Begin:
		//PlayAnim('Reload', 1.0, 0.05);
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		FinishAnim();
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local CSShellCase s;

	s = Spawn(class'CSShellCase',, '', Owner.Location + CalcDrawOffset() + 30 * X + (2.8 * FireOffset.Y+5.0) * Y - Z * 1);
	if ( s != None ) 
	{
		s.DrawScale = 1.0;
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	}
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

defaultproperties
{
    ReloadSounds(0)=Sound'CS_v16.Deagle.DeagleClipOut'
    ReloadSounds(1)=Sound'CS_v16.Deagle.DeagleClipIn'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.Deagle.DeagleFire'
    HitDamage=30
    ClipCount=7
    PickupAmmoCount=24
    AmmoName=Class'Botpack.EClip'
    bInstantHit=True
    FireOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.200000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.014000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.50
    MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Deagle."
    ItemName="Deagle"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'DeagleTestMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'DeaglePick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'Deagle3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'DeaglePick'
    bNoSmooth=False
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}


/*defaultproperties
{
    Mesh=SkeletalMesh'DeagleTestMesh'
    DrawType=DT_Mesh
    bStatic=False
}*/