class Deagle extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=DeaglePlayer ANIVFILE=MODELS\Deagle\DeaglePlayer_a.3d DATAFILE=MODELS\Deagle\DeaglePlayer_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DeaglePlayer X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=DeaglePick ANIVFILE=MODELS\Deagle\DeaglePick_a.3d DATAFILE=MODELS\Deagle\DeaglePick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DeaglePick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=Deagle3rd ANIVFILE=MODELS\Deagle\Deagle3rd_a.3d DATAFILE=MODELS\Deagle\Deagle3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Deagle3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales
//1st Person
#exec MESHMAP NEW MESHMAP=DeaglePlayer MESH=DeaglePlayer
#exec MESHMAP SCALE MESHMAP=DeaglePlayer X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=DeaglePick MESH=DeaglePick
#exec MESHMAP SCALE MESHMAP=DeaglePick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Deagle3rd MESH=Deagle3rd
#exec MESHMAP SCALE MESHMAP=Deagle3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=DeaglePlayer SEQ=All STARTFRAME=0 NUMFRAMES=123
#exec MESH SEQUENCE MESH=DeaglePlayer SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec MESH SEQUENCE MESH=DeaglePlayer SEQ=Still STARTFRAME=32 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DeaglePlayer SEQ=Reload STARTFRAME=33 NUMFRAMES=67
#exec MESH SEQUENCE MESH=DeaglePlayer SEQ=Fire STARTFRAME=100 NUMFRAMES=23

//Pickup
#exec MESH SEQUENCE MESH=DeaglePick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DeaglePick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=Deagle3rd SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=Deagle3rd SEQ=Still STARTFRAME=0 NUMFRAMES=30

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=DEHandle FILE=Textures\Deagle\DE_Handle.BMP GROUP=Deagle FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=DESlide1 FILE=Textures\Deagle\DE_slide1.BMP GROUP=Deagle FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=DESlide2 FILE=Textures\Deagle\DE_slide2_eagle.BMP GROUP=Deagle FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=DEGlove FILE=Textures\Deagle\view_glove.BMP GROUP=Deagle FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=DESkin FILE=Textures\Deagle\view_skin.BMP GROUP=Deagle FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=DEFinger FILE=Textures\Deagle\view_finger.BMP GROUP=Deagle FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=DeagleSkin FILE=Textures\Deagle\deserteagle_skin.BMP GROUP=Deagle FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=DeagleIcon FILE=Icons\Pistols\DeagleIcon.BMP GROUP=Deagle MIPS=OFF

#exec TEXTURE IMPORT NAME=PistolGenericMuzz FILE=Textures\PistolMuzz.BMP GROUP=Deagle LODSET=2 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=DeaglePlayer NUM=1 TEXTURE=DEHandle
#exec MESHMAP SETTEXTURE MESHMAP=DeaglePlayer NUM=2 TEXTURE=DESlide1
#exec MESHMAP SETTEXTURE MESHMAP=DeaglePlayer NUM=3 TEXTURE=DESlide2
#exec MESHMAP SETTEXTURE MESHMAP=DeaglePlayer NUM=4 TEXTURE=DEGlove
#exec MESHMAP SETTEXTURE MESHMAP=DeaglePlayer NUM=5 TEXTURE=DESkin
#exec MESHMAP SETTEXTURE MESHMAP=DeaglePlayer NUM=6 TEXTURE=DEFinger

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=DeaglePick NUM=1 TEXTURE=DeagleSkin

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Deagle3rd NUM=1 TEXTURE=DeagleSkin

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="DeagleFire" FILE=Sounds\Deagle\Deagle_fire.wav GROUP="Deagle"
#exec AUDIO IMPORT NAME="DeagleClipIn" FILE=Sounds\Deagle\de_clipin.wav GROUP="Deagle"
#exec AUDIO IMPORT NAME="DeagleClipOut" FILE=Sounds\Deagle\de_clipout.wav GROUP="Deagle"

//=========================================================================================

#exec MESH IMPORT MESH=PistolMuzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=PistolMuzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=PistolMuzz X=0 Y=600 Z=-205 YAW=64
#exec MESH SEQUENCE MESH=PistolMuzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=PistolMuzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=PistolMuzz MESH=PistolMuzz
#exec MESHMAP SCALE MESHMAP=PistolMuzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var Sound ReloadSounds[3];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.0);
	Sleep(0.5);
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.0,0.0);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.0);
	GoToState('Selector');
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if(!Owner.IsA('Bot'))
		PlayAnim('Fire', 1.3, 0.05);
	else if(Owner.IsA('Bot'))
		PlayAnim('Fire', 4.3, 0.05);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ( (PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}
//simulated function TweenDown();
simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			bMuzzleFlashParticles = False;
			bSteadyFlash3rd = False;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		bMuzzleFlashParticles = True;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if(Pawn(Owner) != None)
	{
		if (Pawn(Owner).bFire != 0)
		{
			bSteadyFlash3rd = False;
			bMuzzleFlashParticles = False;
			GoTo('Begin');
		}
		else
			Finish();
	}
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	ReloadSounds(0)=Sound'CS_v16.Deagle.DeagleClipOut'
    ReloadSounds(1)=Sound'CS_v16.Deagle.DeagleClipIn'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.Deagle.DeagleFire'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=30
    ClipCount=7
    VRecoil=850.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    PickupAmmoCount=28
    AmmoName=Class'CS_v16.AmmoPistols'
    bInstantHit=True
    bRapidFire=False
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.250000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.013000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16.Deagle.PistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Deagle."
    ItemName="Deagle"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=LodMesh'DeaglePlayer'
    //PlayerViewScale=0.600000
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'DeaglePick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'Deagle3rd'
    ThirdPersonScale=2.200000
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.PistolMuzz'
    MuzzleFlashScale=0.080000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'DeaglePick'
    DrawScale=3.000000
    bNoSmooth=False
    Icon=Texture'CS_v16.Deagle.DeagleIcon'
    StatusIcon=Texture'CS_v16.Deagle.DeagleIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.000000
    Mass=10.000000
}