//=============================================================================
// CS Weapons v1.6 Mutator, SpEcTra_7
//=============================================================================
class CSMut16 extends Mutator
	config(CS_v16);

var config string DefaultCSWeapon;
var config string DefaultShotgunWeapon;
var config string DefaultSMGWeapon;
var config string DefaultRifleWeapon;
var config string DefaultSniperWeapon;
var config bool bEnableRecoil;
var config bool bAllAmbientGlow;
var config bool bEnableCrosshair;
var config bool bRespawnWithRandomPistols;
var config bool bRandomPistolReplacement;
var config bool bRandomShotgunReplacement;
var config bool bRandomSMGReplacement;
var config bool bRandomRiflesReplacement;
var config bool bRandomSniperReplacement;
var config bool bBulletPenetration;
var config byte GunPickupSoundType;
var config byte AmmoPickupSoundType;

var bool bFixedSkaarj;
var Class<CSWeapons16> SkaarjWeapons[8];

function PostBeginPlay()
{
	local Actor Other;
	
	Log("===========================================================================");
	Log("|| Counter Strike Weapons v1.6 - Mutator is active! -By SpEcTra_7 ||");
	Log("===========================================================================");

	if(bEnableRecoil)
		Log("Weapons Recoil is enabled!!");
	else
		Log("Weapons Recoil is disabled!!");

	if(bAllAmbientGlow)
		Log("Weapons, Ammo, Pickups ambient glow is enabled!!");
	else
		Log("Weapons, Ammo, Pickups ambient glow is disabled!!");

	if(bEnableCrosshair)
		Log("Crosshair is enabled!!");
	else
		Log("Crosshair is disabled!!");

	if(bRespawnWithRandomPistols)
		Log("Respawn with Random Pistols enabled!!");
	else
	{
		if(DefaultCSWeapon != "")
			Log("Respawn with Random Pistols is disabled!! Setting weapon by 'DefaultCSWeapon'");
		else
			Log("'DefaultCSWeapon' is not set!! Setting USP as default pistol!!");
	}

	if(bRandomPistolReplacement)
		Log("Random Pistols replacement enabled!!");
	else
		Log("Random Pistols replacement disabled!!");

	if(bRandomShotgunReplacement)
		Log("Random Shotguns replacement enabled!!");
	else
	{
		if(DefaultShotgunWeapon != "")
			Log("Random Shotguns replacement disabled!! Setting Shotgun by 'DefaultShotgunWeapon'");
		else
			Log("'DefaultShotgunWeapon' is not set!! Setting M3 as default Shotgun!");
	}

	if(bRandomSMGReplacement)
		Log("Random SMG replacement enabled!!");
	else
	{
		if(DefaultSMGWeapon != "")
			Log("Random SMG replacement disabled!! Setting SMG by 'DefaultSMGWeapon'");
		else
			Log("'DefaultSMGWeapon' is not set!! Setting MP5 as default SMG!!");
	}

	if(bRandomRiflesReplacement)
		Log("Random Rifles replacement enabled!!");
	else
	{
		if(DefaultRifleWeapon != "")
			Log("Random Rifles replacement disabled!! Setting Rifles by 'DefaultRifleWeapon'");
		else
			Log("'DefaultRifleWeapon' is not set!! Setting M4A1 as default Rifle!!");
	}

	if(bRandomSniperReplacement)
		Log("Random Sniper Rifles replacement enabled!!");
	else
	{
		if(DefaultSniperWeapon != "")
			Log("Random Sniper Rifles replacement disabled!! Setting Sniper by 'DefaultSniperWeapon'");
		else
			Log("'DefaultSniperWeapon' is not set!! Setting AWP as default Sniper!!");
	}

	if(bBulletPenetration)
		Log("Bodies and wall penetration enabled!!");
	else
		Log("Bodies and wall penetration disabled!!");

	Log("===========================================================================");

	foreach AllActors(Class'Actor', Other)
	{
		ActorTweaking(Other);
	}

	SaveConfig();
}

simulated function ActorTweaking(Actor Other)
{
		if(SkaarjTrooper(Other) != None)
		{
			Switch(SkaarjTrooper(Other).DropWhenKilled)
			{
				case class'ImpactHammer':
					SkaarjTrooper(Other).WeaponType = Class'CS_v16.Knife';
					break;
				case class'EClip':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoPistols';
					break;
				case class'BioAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoShotgun';
					break;
				case class'ShockCore':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoSMG';
					break;
				case class'PAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoRifles';
					break;
				case class'BladeHopper':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoRifles';
					break;
				case class'MiniAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoRifles';
					break;
				case class'FlakAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoMachine';
					break;
				case class'RocketPack':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoRifles';
					break;
				case class'BulletBox':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16.AmmoSniper';
					break;
			}
		}
		else if(ScriptedPawn(Other) != None)
		{
			Switch(ScriptedPawn(Other).DropWhenKilled)
			{
				case class'EClip':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoPistols';
					break;
				case class'BioAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoShotgun';
					break;
				case class'ShockCore':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoSMG';
					break;
				case class'PAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoRifles';
					break;
				case class'BladeHopper':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoRifles';
					break;
				case class'MiniAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoRifles';
					break;
				case class'FlakAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoMachine';
					break;
				case class'RocketPack':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoRifles';
					break;
				case class'BulletBox':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.AmmoSniper';
					break;
				case class'Armor2':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.KevlarArmor';
					break;
				case class'ThighPads':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16.KevlarArmor';
					break;
			}
		}
		else if(Decoration(Other) != None)
		{
			Switch(Decoration(Other).Contents)
			{
				case class'EClip':
					Decoration(Other).Contents = Class'CS_v16.AmmoPistols';
					break;
				case class'BioAmmo':
					Decoration(Other).Contents = Class'CS_v16.AmmoShotgun';
					break;
				case class'ShockCore':
					Decoration(Other).Contents = Class'CS_v16.AmmoSMG';
					break;
				case class'PAmmo':
					Decoration(Other).Contents = Class'CS_v16.AmmoRifles';
					break;
				case class'BladeHopper':
					Decoration(Other).Contents = Class'CS_v16.AmmoRifles';
					break;
				case class'MiniAmmo':
					Decoration(Other).Contents = Class'CS_v16.AmmoRifles';
					break;
				case class'FlakAmmo':
					Decoration(Other).Contents = Class'CS_v16.AmmoMachine';
					break;
				case class'RocketPack':
					Decoration(Other).Contents = Class'CS_v16.AmmoRifles';
					break;
				case class'BulletBox':
					Decoration(Other).Contents = Class'CS_v16.AmmoSniper';
					break;
				case class'Armor2':
					Decoration(Other).Contents = Class'CS_v16.KevlarArmor';
					break;
				case class'ThighPads':
					Decoration(Other).Contents = Class'CS_v16.KevlarArmor';
					break;
				case class'Enforcer':
					Decoration(Other).Contents = Class'CS_v16.Deagle';
					break;
				case class'UT_BioRifle':
					Decoration(Other).Contents = Class'CS_v16.M3';
					break;
				case class'ShockRifle':
					Decoration(Other).Contents = Class'CS_v16.MP5';
					break;
				case class'Pulsegun':
					Decoration(Other).Contents = Class'CS_v16.AK47';
					break;
				case class'Ripper':
					Decoration(Other).Contents = Class'CS_v16.Aug';
					break;
				case class'minigun2':
					Decoration(Other).Contents = Class'CS_v16.SG550';
					break;
				case class'UT_FlakCannon':
					Decoration(Other).Contents = Class'CS_v16.M249';
					break;
				case class'UT_Eightball':
					Decoration(Other).Contents = Class'CS_v16.M4A1';
					break;
				case class'SniperRifle':
					Decoration(Other).Contents = Class'CS_v16.AWP';
					break;
				case class'SuperShockRifle':
					Decoration(Other).Contents = Class'CS_v16.AWP';
					break;
			}
		}
}

function ModifyPlayer(Pawn Other)
{
	local inventory i;
	local weapon w;
	local class<Weapon> WClass;
	local byte MyPistolIndex;
	local byte j;

	if(Other != None)
	{
		if(Other.FindInventoryType(Class'Enforcer') != None && (Other.IsA('PlayerPawn') || Other.IsA('Bot')) && !Other.IsA('Spectator'))
		{
			if(bRespawnWithRandomPistols)
			{	
				MyPistolIndex = Rand(5);

				Switch(MyPistolIndex)
				{
					case 0:
						W = Weapon(Other.FindInventoryType(Class'Enforcer'));
						W.Destroy();
						W = None;
						W = Spawn(Class'USP');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 1:
						W = Weapon(Other.FindInventoryType(Class'Enforcer'));
						W.Destroy();
						W = None;
						W = Spawn(Class'FiveSeven');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 2:
						W = Weapon(Other.FindInventoryType(Class'Enforcer'));
						W.Destroy();
						W = None;
						W = Spawn(Class'P228');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 3:
						W = Weapon(Other.FindInventoryType(Class'Enforcer'));
						W.Destroy();
						W = None;
						W = Spawn(Class'Deagle');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 4:
						W = Weapon(Other.FindInventoryType(Class'Enforcer'));
						W.Destroy();
						W = None;
						W = Spawn(Class'Glock');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;
				}
			}
			else if(!bRespawnWithRandomPistols)
			{
				if(DefaultCSWeapon != "")
				{
					W = Weapon(Other.FindInventoryType(Class'Enforcer'));
					W.Destroy();
					W = None;
					WClass = class<Weapon>(DynamicLoadObject( DefaultCSWeapon, class'Class' ));
					W = Spawn(WClass);

					if(W != None)
					{
						W.bTossedOut = false;
						W.Instigator = Other;
						W.RespawnTime = 0.0;
						W.bHeldItem = true;
						W.BecomeItem();
						Other.AddInventory(W);
						W.GiveAmmo(Other);
						W.SetSwitchPriority(Other);
						W.WeaponSet(Other);
					}
				}
				else
				{
					W = Weapon(Other.FindInventoryType(Class'Enforcer'));
					W.Destroy();
					W = None;
					W = Spawn(Class'USP');

					if(W != None)
					{
						W.bTossedOut = false;
						W.Instigator = Other;
						W.RespawnTime = 0.0;
						W.bHeldItem = true;
						W.BecomeItem();
						Other.AddInventory(W);
						W.GiveAmmo(Other);
						W.SetSwitchPriority(Other);
						W.WeaponSet(Other);
					}	
				}
			}
		}

		if(DeathMatchPlus(Level.Game) != None)
		{
			if(DeathMatchPlus(Level.Game).bStartMatch)
			{
				if(!bFixedSkaarj)
				{
					GiveSkaarjGuns();
					bFixedSkaarj = True;
				}
			}
		}
	}

	if(NextMutator != None)
		NextMutator.ModifyPlayer(Other);
}

simulated function GiveSkaarjGuns()
{
	local ScriptedPawn S;
	local Weapon W1, W2;

	foreach AllActors(class 'ScriptedPawn', S)
	{
		if ( S != None && S.IsA('SkaarjTrooper') && S.Weapon != None )
		{
			W1 = S.Weapon;
			if(W1.Class == Class'Enforcer')
				W2 = Spawn(Class'Deagle',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'UT_BioRifle')
				W2 = Spawn(Class'M3',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'ShockRifle')
				W2 = Spawn(Class'P90',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'Pulsegun')
				W2 = Spawn(Class'M4A1',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'Ripper')
				W2 = Spawn(Class'Aug',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'minigun2')
				W2 = Spawn(Class'SG550',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'UT_FlakCannon')
				W2 = Spawn(Class'M249',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'UT_Eightball')
				W2 = Spawn(Class'AK47',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'SniperRifle')
				W2 = Spawn(Class'AWP',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'SuperShockRifle')
				W2 = Spawn(Class'AWP',S,,S.Location,S.Rotation);
			if ( W2 != None )
			{
				S.Weapon = None;
				W1.Instigator=None;
				W1.Destroy();
				W2.ReSpawnTime = 0.0;
				W2.bHeldItem=True;
				W2.Instigator=S;
				W2.BecomeItem(); //Do not mess anims
				S.AddInventory(W2);
				W2.GiveAmmo(S);
				W2.WeaponSet(S);
			}
		}
	}
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	//Weapons
	if(Weapon(Other) != None)
	{
		if(Other.Class == Class'Botpack.ImpactHammer')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.Knife");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.Enforcer')
		{
			if(Inventory(Other).MyMarker != None)
			{
				if(bRandomPistolReplacement)
				{
					ReplaceWith(Other, "CS_v16.RandPistolReplacer");
					return false;
				}
				else
				{
					ReplaceWith(Other, "CS_v16.USP");
					return false;	
				}
			}
		}
		else if(Other.Class == Class'Botpack.UT_BioRifle')
		{
			if(Inventory(Other).MyMarker != None)
			{
				if(bRandomShotgunReplacement)
				{
					ReplaceWith(Other, "CS_v16.RandShotgunReplacer");
					return false;
				}
				else
				{
					if(DefaultShotgunWeapon != "")
					{
						ReplaceWith(Other, DefaultShotgunWeapon);
						return false;
					}
					else
					{
						ReplaceWith(Other, "CS_v16.M3");
						return false;	
					}
				}
			}
		}
		else if(Other.Class == Class'Botpack.ShockRifle')
		{
			if(Inventory(Other).MyMarker != None)
			{
				if(bRandomSMGReplacement)
				{
					ReplaceWith(Other, "CS_v16.RandSMGReplacer");
					return false;
				}
				else
				{
					if(DefaultSMGWeapon != "")
					{
						ReplaceWith(Other, DefaultSMGWeapon);
						return false;
					}
					else
					{
						ReplaceWith(Other, "CS_v16.MP5");
					}
				}
			}
		}
		else if(Other.Class == Class'Botpack.Pulsegun')
		{
			if(Inventory(Other).MyMarker != None)
			{
				if(bRandomRiflesReplacement)
				{
					ReplaceWith(Other, "CS_v16.RandRiflesReplacer");
					return false;
				}
				else
				{
					if(DefaultRifleWeapon != "")
					{
						ReplaceWith(Other, DefaultRifleWeapon);
						return false;
					}
					else
					{
						ReplaceWith(Other, "CS_v16.M4A1");
						return false;
					}
				}
			}
		}
		else if(Other.Class == Class'Botpack.Ripper')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.RandGrenadesReplacer");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.minigun2')
		{
			if(Inventory(Other).MyMarker != None)
			{
				if(bRandomRiflesReplacement)
				{
					ReplaceWith(Other, "CS_v16.RandRifles2Replacer");
					return false;
				}
				else
				{
					if(DefaultRifleWeapon != "")
					{
						ReplaceWith(Other, DefaultRifleWeapon);
						return false;
					}
					else
					{
						ReplaceWith(Other, "CS_v16.M4A1");
						return false;
					}
				}
			}
		}
		else if(Other.Class == Class'Botpack.UT_FlakCannon')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.M249");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.UT_Eightball')
		{
			if(Inventory(Other).MyMarker != None)
			{
				if(bRandomRiflesReplacement)
				{
					ReplaceWith(Other, "CS_v16.RandRifles2Replacer");
					return false;
				}
				else
				{
					if(DefaultRifleWeapon != "")
					{
						ReplaceWith(Other, DefaultRifleWeapon);
						return false;
					}
					else
					{
						ReplaceWith(Other, "CS_v16.M4A1");
						return false;
					}
				}
			}
		}
		else if(Other.Class == Class'Botpack.SniperRifle')
		{
			if(Inventory(Other).MyMarker != None)
			{
				if(bRandomSniperReplacement)
				{
					ReplaceWith(Other, "CS_v16.RandSniperReplacer");
					return false;
				}
				else
				{
					if(DefaultSniperWeapon != "")
					{
						ReplaceWith(Other, DefaultSniperWeapon);
						return false;
					}
					else
					{
						ReplaceWith(Other, "CS_v16.AWP");
						return false;
					}
				}
			}
		}
		else if(Other.Class == Class'Botpack.WarHeadLauncher')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.M249");
				return false;
			}
		}
	}
	else if(Ammo(Other) != None)
	{
		if(Other.Class == Class'Botpack.EClip')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.AmmoPistols");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.BioAmmo')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.AmmoShotgun");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.ShockCore')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.AmmoSMG");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.PAmmo')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.AmmoRifles");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.BladeHopper')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.RandGrenadesReplacer");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.MiniAmmo')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.AmmoRifles");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.FlakAmmo')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.AmmoMachine");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.RocketPack')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.AmmoRifles");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.BulletBox')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.AmmoSniper");
				return false;
			}
		}
	}
	else if(Pickup(Other) != None)
	{
		if(Other.Class == Class'Botpack.Armor2')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.KevlarArmor");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.ThighPads')
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16.KevlarArmor");
				return false;
			}
		}
	}

	return true;
}

simulated function Tick(float DeltaTime)
{
	local ScriptedPawn S;
	local Weapon W;

	foreach AllActors(Class'ScriptedPawn', S)
	{
		if(S != None && S.IsA('SkaarjTrooper') && S.Weapon == None)
		{
			W = Spawn(SkaarjWeapons[Rand(7)],S,,S.Location,S.Rotation);
			if ( W != None )
			{
				W.ReSpawnTime = 0.0;
				W.bHeldItem=True;
				W.Instigator=S;
				W.BecomeItem(); //Do not mess anims
				S.AddInventory(W);
				W.GiveAmmo(S);
				W.GiveAmmo(S);
				W.WeaponSet(S);
			}
		}
	}
}

function Mutate (string MutateString, PlayerPawn Sender)
{
	if ( Left(Caps(MutateString),8) == "CSRELOAD" )
	{
			if(Sender != None)
			{
				if(Sender.Weapon != None && !Sender.Weapon.bMeleeWeapon)
				{
					if(Sender.Weapon.IsA('CSWeapons16'))
					{
						if( (CSWeapons16(Sender.Weapon).ClipCount < CSWeapons16(Sender.Weapon).default.ClipCount) && (CSWeapons16(Sender.Weapon).AmmoType.AmmoAmount > 0))
						{
							if(!CSWeapons16(Sender.Weapon).IsInState('NewClip'))
							{
								//CSWeapons16(Sender.Weapon).GotoState('NewClip');
								CSWeapons16(Sender.Weapon).Reload();
							}
						}
					}
				}
			}
	}

	Super.Mutate(MutateString,Sender);

	if(NextMutator != None)
		NextMutator.Mutate(MutateString,Sender);
}

defaultproperties
{
	DefaultWeapon=Class'CS_v16.Knife'
	DefaultCSWeapon="CS_v16.USP"
	DefaultShotgunWeapon="CS_v16.M3"
	DefaultSMGWeapon="CS_v16.MP5"
	DefaultRifleWeapon="CS_v16.M4A1"
	DefaultSniperWeapon="CS_v16.AWP"
	bEnableRecoil=True
	bAllAmbientGlow=True
	bEnableCrosshair=True
	bRespawnWithRandomPistols=True
	bRandomPistolReplacement=True
	bRandomShotgunReplacement=True
	bRandomSMGReplacement=True
	bRandomRiflesReplacement=True
	bRandomSniperReplacement=True
	bBulletPenetration=True
	GunPickupSoundType=0
	AmmoPickupSoundType=0

	SkaarjWeapons(0)=Class'M4A1'
	SkaarjWeapons(1)=Class'AK47'
	SkaarjWeapons(2)=Class'M3'
	SkaarjWeapons(3)=Class'XM1014'
	SkaarjWeapons(4)=Class'ScoutSniper'
	SkaarjWeapons(5)=Class'AWP'
	SkaarjWeapons(6)=Class'Famas'
	SkaarjWeapons(7)=Class'M249'
}