class AWP extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=AWPPlayer ANIVFILE=MODELS\AWP\AWPPlayer_a.3d DATAFILE=MODELS\AWP\AWPPlayer_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AWPPlayer X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=AWPPick ANIVFILE=MODELS\AWP\AWPPick_a.3d DATAFILE=MODELS\AWP\AWPPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AWPPick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=AWP3rd ANIVFILE=MODELS\AWP\AWP3rd_a.3d DATAFILE=MODELS\AWP\AWP3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AWP3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=AWPPlayer MESH=AWPPlayer
#exec MESHMAP SCALE MESHMAP=AWPPlayer X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=AWPPick MESH=AWPPick
#exec MESHMAP SCALE MESHMAP=AWPPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=AWP3rd MESH=AWP3rd
#exec MESHMAP SCALE MESHMAP=AWP3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=AWPPlayer SEQ=All STARTFRAME=0 NUMFRAMES=212
#exec MESH SEQUENCE MESH=AWPPlayer SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec MESH SEQUENCE MESH=AWPPlayer SEQ=Still STARTFRAME=32 NUMFRAMES=8
#exec MESH SEQUENCE MESH=AWPPlayer SEQ=Reload STARTFRAME=41 NUMFRAMES=87
#exec MESH SEQUENCE MESH=AWPPlayer SEQ=Fire1 STARTFRAME=129 NUMFRAMES=41
#exec MESH SEQUENCE MESH=AWPPlayer SEQ=Fire2 STARTFRAME=171 NUMFRAMES=41

//Pickup
#exec MESH SEQUENCE MESH=AWPPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AWPPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=AWP3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=AWP3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=newp12_finger FILE=Textures\AWP\awp_newp12_finger.bmp GROUP=AWP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=Butt_Glove FILE=Textures\AWP\awp_butt_glove.bmp GROUP=AWP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=Scope_Base FILE=Textures\AWP\awp_scope_base.bmp GROUP=AWP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=Eject_Mag FILE=Textures\AWP\awp_eject_mag.bmp GROUP=AWP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=SC_Skin FILE=Textures\AWP\awp_sc_Skin.bmp GROUP=AWP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=Barrel_Bolt FILE=Textures\AWP\awp_barrel_bolt.bmp GROUP=AWP FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AWPW FILE=Textures\AWP\w_awp.bmp GROUP=AWP FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=AWPIcon FILE=Icons\Sniper\awpIcon.bmp GROUP=AWP MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=AWPPlayer NUM=1 TEXTURE=newp12_finger
#exec MESHMAP SETTEXTURE MESHMAP=AWPPlayer NUM=2 TEXTURE=Butt_Glove
#exec MESHMAP SETTEXTURE MESHMAP=AWPPlayer NUM=3 TEXTURE=Scope_Base
#exec MESHMAP SETTEXTURE MESHMAP=AWPPlayer NUM=4 TEXTURE=Eject_Mag
#exec MESHMAP SETTEXTURE MESHMAP=AWPPlayer NUM=5 TEXTURE=SC_Skin
#exec MESHMAP SETTEXTURE MESHMAP=AWPPlayer NUM=6 TEXTURE=Barrel_Bolt

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=AWPPick NUM=1 TEXTURE=AWPW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=AWP3rd NUM=1 TEXTURE=AWPW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="AWPFire" FILE=Sounds\AWP\awp_fire.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="AWPClipIn" FILE=Sounds\AWP\awp_clipin.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="AWPClipOut" FILE=Sounds\AWP\awp_clipout.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="AWPBoltUp" FILE=Sounds\AWP\awp_boltup.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="AWPBoltDown" FILE=Sounds\AWP\awp_boltdown.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="ZoomScope1" FILE=Sounds\AWP\GunZoom.wav GROUP="AWP"

//=========================================================================================

var Sound ReloadSounds[4];
var float StillTime, StillStart;
var vector OwnerLocation;
var int ZoomLevel, WasZoomLevel;
var name FireAnims[2];

replication
{
	reliable if(bNetOwner && Role == ROLE_Authority)
		ZoomLevel, WasZoomLevel;
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	ZoomLevel = 0;
	SetTimer(1.0, true);
	//log("Scout Sniper Select Zoom = "$ZoomLevel);
}

simulated function Timer()
{
	if(Level.NetMode != NM_DedicatedServer)
	{
		if(PlayerPawn(Owner) != None)
		{
			if(PlayerPawn(Owner).DesiredFOV == 45.0)
				ZoomLevel = 1;
			else if(PlayerPawn(Owner).DesiredFOV == 15.0)
				ZoomLevel = 2;
			else if(PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
				ZoomLevel = 0;
		}
	}
}


function DropFrom(vector StartLocation)
{
	Super.DropFrom(StartLocation);
	ZoomLevel = 0;
}

simulated function TweenDown()
{
	ZoomLevel = 0;
}

simulated function PostRender( canvas Canvas )
{
    local PlayerPawn P;
    local float Scale;

    Super.PostRender(Canvas);
    P = PlayerPawn(Owner);
    if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
    {
    	bOwnsCrossHair = true;
    	Scale = Canvas.ClipX/256;
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.Style = ERenderStyle.STY_Modulated;
        Canvas.DrawIcon(Texture'SG5SniperBack', Scale);
        Scale = Canvas.ClipX/640;
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.DrawIcon(Texture'SG5SniperScope', Scale);
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.Style = ERenderStyle.STY_Translucent;
        Canvas.DrawIcon(Texture'SG5Snipe', Scale);
        Scale = P.DefaultFOV/P.DesiredFOV;
    }
    else if(Class'CSMut16'.default.bEnableCrosshair)
        bOwnsCrossHair = false;
    else
    	bOwnsCrossHair = true;
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.5);
	//PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		ZoomLevel = 0;
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
 			bDrawMuzzleFlash = True; 
		}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		//Play1stSelectionSound();
		Sleep(0.4);
		//PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = 45.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					Owner.PlaySound(Sound'ZoomScope1');
				}
				else if (PlayerPawn(Owner).DesiredFOV == 45.0)
				{
					PlayerPawn(Owner).DesiredFOV = 15.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					Owner.PlaySound(Sound'ZoomScope1');
				}
				else
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					Owner.PlaySound(Sound'ZoomScope1');
				}
			}
		}
	}
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim(FireAnims[Rand(2)], 1, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None) && PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
		bMuzzleFlash++;
	else if ((PlayerPawn(Owner) != None) && PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
		bMuzzleFlash = 0;
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		if(!Owner.IsA('Bot'))
		{
			if(ZoomLevel == 0)
			{
				TraceFire(17.0);
				bDrawMuzzleFlash = True;
				bMuzzleFlash++;
			}
			else if(ZoomLevel == 1)
			{
				TraceFire(0.0);
				bDrawMuzzleFlash = False;
				bMuzzleFlash = 0;
			}
			else if(ZoomLevel == 2)
			{
				TraceFire(0.0);
				bDrawMuzzleFlash = False;
				bMuzzleFlash = 0;
			}
		}
		else if(Owner.IsA('Bot'))
			if(Bot(Owner) != None)
				TraceFire(0.0);
		else if((Owner.IsA('SkaarjTrooper')))
			if(SkaarjTrooper(Owner) != None)
				TraceFire(3.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
		ZoomLevel = 0;
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		SpawnShellCase(vect(10,-500,1));
		Sleep(0.4);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		FinishAnim();
		Finish();
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function AltFire( float Value )
{
	if(ZoomLevel == 0)				//Was Default FOV
		ZoomLevel = 1;
	else if(ZoomLevel == 1)			//New FOV : 45
		ZoomLevel = 2;
	else if(ZoomLevel == 2)			//New FOV : 15
		ZoomLevel = 0;				//Back to Default FOV

	ClientAltFire(Value);
}

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
    	ZoomLevel = 0;
        GotoState('NewClip');
        PlayReloading();
        ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					bDrawMuzzleFlash = True;
					bMuzzleFlash++;
				}
			}
		}
    }
}

simulated function ClientReload()
{
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
    	ZoomLevel = 0;
    	GoToState('ClientReloading');
        PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.8, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.35);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	Sleep(1.0);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.35);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3!=0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	
	if(ZoomLevel == 0)
		StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	else if(ZoomLevel == 1)
		StartTrace = Owner.Location + Pawn(Owner).Eyeheight * Z;
	else if(ZoomLevel == 2)
		StartTrace = Owner.Location + Pawn(Owner).Eyeheight * Z;
		
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 66.00;
		else
			Penetration = 40.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 4.0, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	FireAnims(0)=Fire1
	FireAnims(1)=Fire2
    ReloadSounds(0)=Sound'CS_v16.AWP.AWPBoltUp'
    ReloadSounds(1)=Sound'CS_v16.AWP.AWPBoltDown'
	ReloadSounds(2)=Sound'CS_v16.AWP.AWPClipOut'
    ReloadSounds(3)=Sound'CS_v16.AWP.AWPClipIn'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.AWP.AWPFire'
    EjectOffset=(X=30.000000,Y=20.000000,Z=-10.000000)
    HitDamage=108
    ClipCount=10
    PickupAmmoCount=20
    VRecoil=550.00
    HRecoil=0.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16.AmmoSniper'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000,Z=0.00)
    MuzzleOffset=(X=0.00,Y=-8.000000,Z=0.00)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.950000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.080000
    FlashO=0.013000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16.Deagle.PistolGenericMuzz'
    AutoSwitchPriority=9
    InventoryGroup=9
    PickupMessage="You got a AWP."
    ItemName="AWP"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=LodMesh'AWPPlayer'
    PlayerViewScale=7.000000
    PickupViewMesh=LodMesh'AWPPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'AWP3rd'
    ThirdPersonScale=2.200000
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.RifleMuzz2'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'AWPPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16.AWP.AWPIcon'
    StatusIcon=Texture'CS_v16.AWP.AWPIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}