class AK47 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH IMPORT MESH=AK47Player ANIVFILE=MODELS\AK47\AK47Player_a.3d DATAFILE=MODELS\AK47\AK47Player_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK47Player X=0 Y=0 Z=0 Yaw=64

//Pickup
#exec MESH IMPORT MESH=AK47Pick ANIVFILE=MODELS\AK47\AK47Pick_a.3d DATAFILE=MODELS\AK47\AK47Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK47Pick X=0 Y=0 Z=34

//3rd Person
#exec MESH IMPORT MESH=AK473rd ANIVFILE=MODELS\AK47\AK473rd_a.3d DATAFILE=MODELS\AK47\AK473rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK473rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP NEW MESHMAP=AK47Player MESH=AK47Player
#exec MESHMAP SCALE MESHMAP=AK47Player X=0.1 Y=0.1 Z=0.2

//Pickup
#exec MESHMAP NEW MESHMAP=AK47Pick MESH=AK47Pick
#exec MESHMAP SCALE MESHMAP=AK47Pick X=0.09 Y=0.09 Z=0.1

//3rd Person
#exec MESHMAP NEW MESHMAP=AK473rd MESH=AK473rd
#exec MESHMAP SCALE MESHMAP=AK473rd X=0.09 Y=0.09 Z=0.13

//=========================================================================================

//Animations

//1st Person
#exec MESH SEQUENCE MESH=AK47Player SEQ=All STARTFRAME=0 NUMFRAMES=156
#exec MESH SEQUENCE MESH=AK47Player SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec MESH SEQUENCE MESH=AK47Player SEQ=Still STARTFRAME=32 NUMFRAMES=16
#exec MESH SEQUENCE MESH=AK47Player SEQ=Reload STARTFRAME=49 NUMFRAMES=90
#exec MESH SEQUENCE MESH=AK47Player SEQ=Fire STARTFRAME=140 NUMFRAMES=16

//Pickup
#exec MESH SEQUENCE MESH=AK47Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK47Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=AK473rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=AK473rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=AKMagazine FILE=Textures\AK47\magazine.bmp GROUP=AK47 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AKForeWood FILE=Textures\AK47\AK_Forewood.bmp GROUP=AK47 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AKBarrelGlove FILE=Textures\AK47\AK_BarrelGlove.bmp GROUP=AK47 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AKHandleReticle FILE=Textures\AK47\Ak_HandleReticle.bmp GROUP=AK47 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AKLowerUpper FILE=Textures\AK47\Ak_LowerUpper.bmp GROUP=AK47 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AKFingerSkin FILE=Textures\AK47\Ak_FingerSkin.bmp GROUP=AK47 FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AKSkin FILE=Textures\AK47\Ak47_skin.bmp GROUP=AK47 FLAGS=2 LODSET=2

#exec TEXTURE IMPORT NAME=AKIcon FILE=Icons\Rifles\Ak47Icon.bmp GROUP=AK47 LODSET=2 MIPS=OFF

#exec TEXTURE IMPORT NAME=CSRifleMuzz1 FILE=Textures\RifleMuzz1.bmp GROUP=AK47 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=CSRifleMuzz2 FILE=Textures\RifleMuzz2.bmp GROUP=AK47 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=CSRifleMuzz3 FILE=Textures\RifleMuzz3.bmp GROUP=AK47 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=CSRifleMuzz4 FILE=Textures\RifleMuzz4.bmp GROUP=AK47 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=CSRifleMuzz5 FILE=Textures\RifleMuzz5.bmp GROUP=AK47 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=CSRifleMuzz6 FILE=Textures\RifleMuzz6.bmp GROUP=AK47 LODSET=2 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=AK47Player NUM=1 TEXTURE=AKMagazine
#exec MESHMAP SETTEXTURE MESHMAP=AK47Player NUM=2 TEXTURE=AKForeWood
#exec MESHMAP SETTEXTURE MESHMAP=AK47Player NUM=3 TEXTURE=AKBarrelGlove
#exec MESHMAP SETTEXTURE MESHMAP=AK47Player NUM=4 TEXTURE=AKHandleReticle
#exec MESHMAP SETTEXTURE MESHMAP=AK47Player NUM=5 TEXTURE=AKLowerUpper
#exec MESHMAP SETTEXTURE MESHMAP=AK47Player NUM=6 TEXTURE=AKFingerSkin

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=AK47Pick NUM=1 TEXTURE=AKSkin

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=AK473rd NUM=1 TEXTURE=AKSkin

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="AK47Fire" FILE=Sounds\AK47\ak47_fire.wav GROUP="AK47"
#exec AUDIO IMPORT NAME="AK47BoltPull" FILE=Sounds\AK47\ak47_boltpull.wav GROUP="AK47"
#exec AUDIO IMPORT NAME="AK47ClipIn" FILE=Sounds\AK47\ak47_clipin.wav GROUP="AK47"
#exec AUDIO IMPORT NAME="AK47ClipOut" FILE=Sounds\AK47\ak47_clipout.wav GROUP="AK47"

//=========================================================================================

var Sound ReloadSounds[5];
var Texture RandFlash[6];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		//Play1stSelectionSound();
		Sleep(0.4);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 6, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		MFTexture = RandFlash[Rand(5)];
		bMuzzleFlash++;
	}
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);
		bPointing = True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
		
		//GoToState('NewClip');

	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	TweenAnim('Still',1.0);
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(Pawn(Owner).bExtra3 != 0 && AmmoType.AmmoAmount>0 && ClipCount < Default.ClipCount)
		Reload();
	else if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16.AK47.AK47ClipOut'
    ReloadSounds(1)=Sound'CS_v16.AK47.AK47ClipIn'
    ReloadSounds(2)=Sound'CS_v16.AK47.AK47BoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16.AK47.AK47Fire'
    EjectOffset=(X=30.000000,Y=20.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=30
    PickupAmmoCount=60
    VRecoil=850.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16.AmmoRifles'
    bInstantHit=True
    bRapidFire=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-10.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.730000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=500.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.100000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16.AK47.CSRifleMuzz1'
    AutoSwitchPriority=5
    InventoryGroup=5
    PickupMessage="You got a AK-47."
    ItemName="AK-47"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=LodMesh'AK47Player'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'AK47Pick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'AK473rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16.RifleMuzz2'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'AK47Pick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16.AK47.AKIcon'
    StatusIcon=Texture'CS_v16.AK47.AKIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}