class Sniper_Scout extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=ScoutMesh MODELFILE=ModelsSkeletal\Sniper\Scout\ScoutMesh.psk
#exec MESH ORIGIN MESH=ScoutMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=ScoutFirstPick ANIVFILE=MODELS\Sniper\Scout\ScoutFirstPick_a.3d DATAFILE=MODELS\Sniper\Scout\ScoutFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ScoutFirstPick X=0 Y=0 Z=16

//3rd Person
#exec MESH IMPORT MESH=ScoutFirst3rd ANIVFILE=MODELS\Sniper\Scout\ScoutFirst3rd_a.3d DATAFILE=MODELS\Sniper\Scout\ScoutFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ScoutFirst3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=ScoutMeshAnims ANIMFILE=ModelsSkeletal\Sniper\Scout\ScoutMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=178
#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=88
#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=Fire STARTFRAME=132 NUMFRAMES=46

#exec ANIM DIGEST ANIM=ScoutMeshAnims
#exec MESH DEFAULTANIM MESH=ScoutMesh ANIM=ScoutMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=ScoutFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ScoutFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=ScoutFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ScoutFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=ScoutMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=ScoutFirstPick MESH=ScoutFirstPick
#exec MESHMAP SCALE MESHMAP=ScoutFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=ScoutFirst3rd MESH=ScoutFirst3rd
#exec MESHMAP SCALE MESHMAP=ScoutFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=ScoutMeshSkin00 FILE=Textures\Sniper\Scout\ScoutScope.bmp GROUP=Scout LODSET=2
#exec TEXTURE IMPORT NAME=ScoutMeshSkin01 FILE=Textures\Sniper\Scout\ScoutBody.bmp GROUP=Scout LODSET=2
#exec TEXTURE IMPORT NAME=ScoutMeshSkin02 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=ScoutMeshSkin03 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=ScoutMeshSkin04 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=ScoutBodyPick FILE=Textures\Sniper\Scout\ScoutBodyPick.bmp GROUP=Scout LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=0 TEXTURE=ScoutMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=1 TEXTURE=ScoutMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=2 TEXTURE=ScoutMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=3 TEXTURE=ScoutMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=4 TEXTURE=ScoutMeshSkin04

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=ScoutFirstPick NUM=1 TEXTURE=ScoutBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=ScoutFirst3rd NUM=1 TEXTURE=ScoutBodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="ScoutFire" FILE=Sounds\Sniper\Scout\Scout_fire.wav GROUP="Scout"
#exec AUDIO IMPORT NAME="ScoutClipOut" FILE=Sounds\Sniper\Scout\Scout_clipout.wav GROUP="Scout"
#exec AUDIO IMPORT NAME="ScoutClipIn" FILE=Sounds\Sniper\Scout\Scout_clipin.wav GROUP="Scout"
#exec AUDIO IMPORT NAME="ScoutBolt" FILE=Sounds\Sniper\Scout\Scout_bolt.wav GROUP="Scout"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=ScoutMuzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=ScoutMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=ScoutMuzzle X=-630 Y=0 Z=-25

#exec MESH SEQUENCE MESH=ScoutMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ScoutMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=ScoutMuzzle MESH=ScoutMuzzle
#exec MESHMAP SCALE MESHMAP=ScoutMuzzle X=0.115 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMuzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle04.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMuzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=ScoutIcon FILE=Textures\Icons\ScoutIcon.bmp GROUP=Scout MIPS=OFF

//=========================================================================================

var byte PZoomLevel;

replication
{
	reliable if(bNetOwner && Role == ROLE_Authority)
		PZoomLevel;
	reliable if(Role == ROLE_Authority)
		PlayerZoomCheck;
}

function DropFrom(vector StartLocation)
{
	Super.DropFrom(StartLocation);
	PZoomLevel = 0;
}

simulated function TweenDown()
{
	PZoomLevel = 0;
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		PZoomLevel = 0;
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
 			bDrawMuzzleFlash = True; 
		}
}

simulated function PostRender( canvas Canvas )
{
    local PlayerPawn P;
    local float Scale;
    local float ScopeScale, StartScopeX, StartScopeY, EndScopeX, EndScopeY;
    local float CntX, CntY;

    Super.PostRender(Canvas);
    P = PlayerPawn(Owner);
    if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
    {
    	bOwnsCrossHair = true;

    	Scale = Canvas.ClipY / 512;
    	CntX = Canvas.ClipX / 2;
		CntY = Canvas.ClipY / 2;
    	StartScopeX = (Canvas.ClipX - 512 * Scale)/2;
		StartScopeY = 0;
		EndScopeX = (Canvas.ClipX + 512 * Scale)/2;
		EndScopeY = Canvas.ClipY;

		Canvas.bNoSmooth = True;
    	Canvas.Style = ERenderStyle.STY_Modulated;

		Canvas.SetPos(StartScopeX, StartScopeY);
		Canvas.DrawIcon(Texture'ScopeN01', Scale);
		Canvas.SetPos(CntX, StartScopeY);
		Canvas.DrawIcon(Texture'ScopeN02', Scale);
		Canvas.SetPos(StartScopeX, CntY);
		Canvas.DrawIcon(Texture'ScopeN03', Scale);
		Canvas.SetPos(CntX, CntY);
		Canvas.DrawIcon(Texture'ScopeN04', Scale);

		Canvas.bNoSmooth = True;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 255;
		
		Canvas.SetPos(0, 0);
		Canvas.DrawRect(Texture'ScopeBack', StartScopeX, EndScopeY);
		Canvas.SetPos( EndScopeX, 0);
		Canvas.DrawRect(Texture'ScopeBack', StartScopeX, EndScopeY);

        Scale = P.DefaultFOV/P.DesiredFOV;
    }
    else if(Class'CSSMutator'.default.bEnableCrosshair)
    	bOwnsCrossHair = false;
	else
		bOwnsCrossHair = true;
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	GoToState('Selector');
	PZoomLevel = 0;
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				Owner.PlaySound(Sound'ZoomScope1');
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
					PlayerPawn(Owner).DesiredFOV = 55.0;
				else if (PlayerPawn(Owner).DesiredFOV == 55.0)
					PlayerPawn(Owner).DesiredFOV = 25.0;
				else
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
			}
		}
	}
}

simulated function JustFire()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 1.0, 0.04);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if(Owner.IsA('PlayerPawn'))
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
	        	PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;

	if ((PlayerPawn(Owner) != None) && PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
		bMuzzleFlash++;
	else if ((PlayerPawn(Owner) != None) && PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
		bMuzzleFlash = 0;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		if(!Owner.IsA('Bot'))
		{
			if(PZoomLevel == 0)
				TraceFire(17.0);
			else if(PZoomLevel == 1)
				TraceFire(0.0);
			else if(PZoomLevel == 2)
				TraceFire(0.0);
		}
		else if(Owner.IsA('Bot'))
			if(Bot(Owner) != None)
				TraceFire(0.0);
		else if((Owner.IsA('SkaarjTrooper')))
			if(SkaarjTrooper(Owner) != None)
				TraceFire(3.0);

		bPointing=True;
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
		PZoomLevel = 0;
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		Sleep(0.5);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.21);
		SpawnShellCase(vect(10,-500,1));
		Sleep(1.2);
		FinishAnim();
		Finish();
}

state ClientFiring
{
	Begin:
		FlashCount++;
		Sleep(0.5);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.21);
		SpawnShellCase(vect(10,-500,1));
		Sleep(1.2);
		FinishAnim();
		Finish();
}

function AltFire( float Value )
{
	if(PZoomLevel == 0)				//Was Default FOV
		PZoomLevel = 1;				//New FOV : 45
	else if(PZoomLevel == 1)		
		PZoomLevel = 2;				//New FOV : 15
	else if(PZoomLevel == 2)		
		PZoomLevel = 0;				//Back to Default FOV

	ClientAltFire(Value);
}

simulated function PlayAltFiring()
{
	PlayAnim('Still', 10.0, 0.04);
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
    	PZoomLevel = 0;
        GotoState('NewClip');
        PlayReloading();
        ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function ClientReload()
{
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
    	PZoomLevel = 0;
    	GoToState('ClientReloading');
        PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.8, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated function ZoomCheck()
{
	JustZoomCheck();
	PlayerZoomCheck();
}

simulated function JustZoomCheck()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				if (PZoomLevel == 0)
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
				else if (PZoomLevel == 1)
					PlayerPawn(Owner).DesiredFOV = 55.0;
				else if(PZoomLevel == 2)
					PlayerPawn(Owner).DesiredFOV = 25.0;
			}
		}
	}
}

simulated function PlayerZoomCheck()
{
	if( Role < ROLE_Authority )
		JustZoomCheck();
}

function Finish()
{
  	ZoomCheck();
  	Super.Finish();
}

defaultproperties
{
	HeadShotMultiplier=2.50
	PawnPenetrationValue=466.00
	WallPenetrationValue=440.00
	ShellCaseType=Class'CSSWeapons.CSSShellCaseSniper'
	ShellCaseScale=0.300000
    ReloadSounds(0)=Sound'CSSWeapons.Scout.ScoutBolt'
    ReloadSounds(1)=Sound'CSSWeapons.Scout.ScoutClipOut'
	ReloadSounds(2)=Sound'CSSWeapons.Scout.ScoutClipIn'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.Scout.ScoutFire'
    EjectOffset=(X=30.000000,Y=10.000000,Z=-10.000000)
    HitDamage=65
    ClipCount=10
    PickupAmmoCount=20
    Recoil=(Vertical=0.400000,Horizontal=1.220000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoSniper'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000,Z=0.00)
    MuzzleOffset=(X=0.00,Y=-8.000000,Z=0.00)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.940000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.080000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=9
    InventoryGroup=9
    PickupMessage="You got a Scout."
    ItemName="Scout"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.ScoutMesh'
    PlayerViewScale=7.000000
    PickupViewMesh=LodMesh'CSSWeapons.ScoutFirstPick'
    PickupViewScale=2.500000
    ThirdPersonMesh=LodMesh'CSSWeapons.ScoutFirst3rd'
    ThirdPersonScale=2.200000
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.ScoutMuzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.ScoutFirstPick'
    bNoSmooth=False
    DrawScale=2.500000
    Icon=Texture'CSSWeapons.Scout.ScoutIcon'
    StatusIcon=Texture'CSSWeapons.Scout.ScoutIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}