class Sniper_AWP extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=AWPMesh MODELFILE=ModelsSkeletal\Sniper\AWP\AWMMesh.psk
#exec MESH ORIGIN MESH=AWPMesh X=-0.8 Y=-1 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=AWPFirstPick ANIVFILE=MODELS\Sniper\AWP\AWPFirstPick_a.3d DATAFILE=MODELS\Sniper\AWP\AWPFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AWPFirstPick X=0 Y=0 Z=15.3

//3rd Person
#exec MESH IMPORT MESH=AWPFirst3rd ANIVFILE=MODELS\Sniper\AWP\AWPFirst3rd_a.3d DATAFILE=MODELS\Sniper\AWP\AWPFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AWPFirst3rd X=60 Y=0 Z=-14 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=AWPMeshAnims ANIMFILE=ModelsSkeletal\Sniper\AWP\AWMMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=AWPMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=199
#exec ANIM SEQUENCE ANIM=AWPMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=AWPMeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=11
#exec ANIM SEQUENCE ANIM=AWPMeshAnims SEQ=Reload STARTFRAME=45 NUMFRAMES=111
#exec ANIM SEQUENCE ANIM=AWPMeshAnims SEQ=Fire STARTFRAME=157 NUMFRAMES=42

#exec ANIM DIGEST ANIM=AWPMeshAnims
#exec MESH DEFAULTANIM MESH=AWPMesh ANIM=AWPMeshAnims
//#exec MESH SEQUENCE MESH=AWPFirst SEQ=??? STARTFRAME=0 NUMFRAMES=199

//Pickup
#exec MESH SEQUENCE MESH=AWPFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AWPFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=AWPFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=AWPFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=AWPMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=AWPFirstPick MESH=AWPFirstPick
#exec MESHMAP SCALE MESHMAP=AWPFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=AWPFirst3rd MESH=AWPFirst3rd
#exec MESHMAP SCALE MESHMAP=AWPFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=AWPMeshSkin00 FILE=Textures\Sniper\AWP\AWPBody.bmp GROUP=AWP LODSET=2
#exec TEXTURE IMPORT NAME=AWPMeshSkin01 FILE=Textures\Sniper\AWP\AWPScope.bmp GROUP=AWP LODSET=2
#exec TEXTURE IMPORT NAME=AWPMeshSkin02 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=AWPMeshSkin03 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=AWPMeshSkin04 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=AWPPick FILE=Textures\Sniper\AWP\AWPBodyPick.bmp GROUP=AWP LODSET=2

#exec TEXTURE IMPORT NAME=ScopeBack FILE=Textures\Sniper\AWP\ScopeBack.bmp GROUP=AWP MIPS=OFF LODSET=0
#exec TEXTURE IMPORT NAME=ScopeN01 FILE=Textures\Sniper\AWP\ScopeN01.bmp GROUP=AWP MIPS=OFF LODSET=0
#exec TEXTURE IMPORT NAME=ScopeN02 FILE=Textures\Sniper\AWP\ScopeN02.bmp GROUP=AWP MIPS=OFF LODSET=0
#exec TEXTURE IMPORT NAME=ScopeN03 FILE=Textures\Sniper\AWP\ScopeN03.bmp GROUP=AWP MIPS=OFF LODSET=0
#exec TEXTURE IMPORT NAME=ScopeN04 FILE=Textures\Sniper\AWP\ScopeN04.bmp GROUP=AWP MIPS=OFF LODSET=0

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=AWPMesh NUM=0 TEXTURE=AWPMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=AWPMesh NUM=1 TEXTURE=AWPMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=AWPMesh NUM=2 TEXTURE=AWPMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=AWPMesh NUM=3 TEXTURE=AWPMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=AWPMesh NUM=4 TEXTURE=AWPMeshSkin04

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=AWPFirstPick NUM=1 TEXTURE=AWPPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=AWPFirst3rd NUM=1 TEXTURE=AWPPick

//=========================================================================================
//Sounds
#exec AUDIO IMPORT NAME="MagFire" FILE=Sounds\Sniper\AWP\AWP_fire.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="MagBolt" FILE=Sounds\Sniper\AWP\AWP_bolt.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="MagClipIn" FILE=Sounds\Sniper\AWP\AWP_clipin.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="MagClipOut" FILE=Sounds\Sniper\AWP\AWP_clipout.wav GROUP="AWP"
#exec AUDIO IMPORT NAME="ZoomScope1" FILE=Sounds\Sniper\AWP\AWP_Zoom.wav GROUP="AWP"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=AWPMuzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=AWPMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=AWPMuzzle X=-710 Y=0 Z=-15

#exec MESH SEQUENCE MESH=AWPMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AWPMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=AWPMuzzle MESH=AWPMuzzle
#exec MESHMAP SCALE MESHMAP=AWPMuzzle X=0.115 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=AWPMuzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle04.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=AWPMuzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=AWPIcon FILE=Textures\Icons\AWPIcon.bmp GROUP=AWP MIPS=OFF

//=========================================================================================

var byte PZoomLevel;

replication
{
	reliable if(bNetOwner && Role == ROLE_Authority)
		PZoomLevel;
	reliable if(Role == ROLE_Authority)
		PlayerZoomCheck;
}

function DropFrom(vector StartLocation)
{
	Super.DropFrom(StartLocation);
	PZoomLevel = 0;
	bDrawMuzzleFlash = True;
}

simulated function TweenDown()
{
	PZoomLevel = 0;
	bDrawMuzzleFlash = True;
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		PZoomLevel = 0;
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
 			bDrawMuzzleFlash = True; 
		}
}

simulated function PostRender( canvas Canvas )
{
    local PlayerPawn P;
    local float Scale;
    local float ScopeScale, StartScopeX, StartScopeY, EndScopeX, EndScopeY;
    local float CntX, CntY;

    Super.PostRender(Canvas);
    P = PlayerPawn(Owner);
    if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
    {
    	bOwnsCrossHair = true;

    	Scale = Canvas.ClipY / 512;
    	CntX = Canvas.ClipX / 2;
		CntY = Canvas.ClipY / 2;
    	StartScopeX = (Canvas.ClipX - 512 * Scale)/2;
		StartScopeY = 0;
		EndScopeX = (Canvas.ClipX + 512 * Scale)/2;
		EndScopeY = Canvas.ClipY;

		Canvas.bNoSmooth = True;
    	Canvas.Style = ERenderStyle.STY_Modulated;

		Canvas.SetPos(StartScopeX, StartScopeY);
		Canvas.DrawIcon(Texture'ScopeN01', Scale);
		Canvas.SetPos(CntX, StartScopeY);
		Canvas.DrawIcon(Texture'ScopeN02', Scale);
		Canvas.SetPos(StartScopeX, CntY);
		Canvas.DrawIcon(Texture'ScopeN03', Scale);
		Canvas.SetPos(CntX, CntY);
		Canvas.DrawIcon(Texture'ScopeN04', Scale);

		Canvas.bNoSmooth = True;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 255;
		
		Canvas.SetPos(0, 0);
		Canvas.DrawRect(Texture'ScopeBack', StartScopeX, EndScopeY);
		Canvas.SetPos( EndScopeX, 0);
		Canvas.DrawRect(Texture'ScopeBack', StartScopeX, EndScopeY);

        Scale = P.DefaultFOV/P.DesiredFOV;
    }
    else if(Class'CSSMutator'.default.bEnableCrosshair)
    	bOwnsCrossHair = false;
	else
		bOwnsCrossHair = true;
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	PZoomLevel = 0;
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				Owner.PlaySound(Sound'ZoomScope1');
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
					PlayerPawn(Owner).DesiredFOV = 45.0;
				else if (PlayerPawn(Owner).DesiredFOV == 45.0)
					PlayerPawn(Owner).DesiredFOV = 15.0;
				else
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
			}
		}
	}
}

simulated function JustFire()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 1.0, 0.04);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if(Owner.IsA('PlayerPawn'))
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
	        	PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;

	if(PlayerPawn(Owner) != None && PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		if(!Owner.IsA('Bot'))
		{
			if(PZoomLevel == 0)
				TraceFire(17.0);
			else if(PZoomLevel == 1)
				TraceFire(0.0);
			else if(PZoomLevel == 2)
				TraceFire(0.0);
		}
		else if(Owner.IsA('Bot'))
			if(Bot(Owner) != None)
				TraceFire(0.0);
		else if((Owner.IsA('SkaarjTrooper')))
			if(SkaarjTrooper(Owner) != None)
				TraceFire(3.0);

		bPointing=True;
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
		PZoomLevel = 0;
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		SpawnShellCase(vect(10,-500,1));
		Sleep(0.4);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		FinishAnim();
		Finish();
}

state ClientFiring
{
	Begin:
		FlashCount++;
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		SpawnShellCase(vect(10,-500,1));
		Sleep(0.4);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		FinishAnim();
		Finish();
}

function AltFire( float Value )
{
	if(PZoomLevel == 0)				//Was Default FOV
		PZoomLevel = 1;				//New FOV : 45
	else if(PZoomLevel == 1)		
		PZoomLevel = 2;				//New FOV : 15
	else if(PZoomLevel == 2)		
		PZoomLevel = 0;				//Back to Default FOV

	ClientAltFire(Value);
}

simulated function PlayAltFiring()
{
	PlayAnim('Still', 10.0, 0.04);
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
    	PZoomLevel = 0;
        GotoState('NewClip');
        PlayReloading();
        ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function ClientReload()
{
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
    	PZoomLevel = 0;
    	GoToState('ClientReloading');
        PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.8, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.15);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	Sleep(0.8);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.15);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated function ZoomCheck()
{
	JustZoomCheck();
	PlayerZoomCheck();
}

simulated function JustZoomCheck()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				if (PZoomLevel == 0)
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
				else if (PZoomLevel == 1)
					PlayerPawn(Owner).DesiredFOV = 45.0;
				else if(PZoomLevel == 2)
					PlayerPawn(Owner).DesiredFOV = 15.0;
			}
		}
	}
}

simulated function PlayerZoomCheck()
{
	if( Role < ROLE_Authority )
		JustZoomCheck();
}

function Finish()
{
  	ZoomCheck();
  	Super.Finish();
}

defaultproperties
{
	HeadShotMultiplier=4.50
	PawnPenetrationValue=466.00
	WallPenetrationValue=440.00
	ShellCaseType=Class'CSSWeapons.CSSShellCaseSniper'
	ShellCaseScale=0.500000
    ReloadSounds(0)=Sound'CSSWeapons.AWP.MagBolt'
    ReloadSounds(1)=Sound'CSSWeapons.AWP.MagBolt'
	ReloadSounds(2)=Sound'CSSWeapons.AWP.MagClipOut'
    ReloadSounds(3)=Sound'CSSWeapons.AWP.MagClipIn'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.AWP.MagFire'
    EjectOffset=(X=30.000000,Y=10.000000,Z=-10.000000)
    HitDamage=108
    ClipCount=10
    PickupAmmoCount=20
    Recoil=(Vertical=0.400000,Horizontal=1.220000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoSniper'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000,Z=0.00)
    MuzzleOffset=(X=0.00,Y=-8.000000,Z=0.00)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.950000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.080000
    FlashO=0.008500
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=9
    InventoryGroup=9
    PickupMessage="You got a AWP."
    ItemName="AWP"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.AWPMesh'
    PlayerViewScale=7.000000
    PickupViewMesh=LodMesh'CSSWeapons.AWPFirstPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'CSSWeapons.AWPFirst3rd'
    ThirdPersonScale=2.200000
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.AWPMuzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.AWPFirstPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CSSWeapons.AWP.AWPIcon'
    StatusIcon=Texture'CSSWeapons.AWP.AWPIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}