class Shotgun_XM1014 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=XM1014Mesh MODELFILE=ModelsSkeletal\Shotguns\XM1014\XM1014Mesh.psk
#exec MESH ORIGIN MESH=XM1014Mesh X=-0.8 Y=-1 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=XM1014FirstPick ANIVFILE=MODELS\Shotguns\XM1014\XM1014FirstPick_a.3d DATAFILE=MODELS\Shotguns\XM1014\XM1014FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=XM1014FirstPick X=0 Y=0 Z=21.5

//3rd Person
#exec MESH IMPORT MESH=XM1014First3rd ANIVFILE=MODELS\Shotguns\XM1014\XM1014First3rd_a.3d DATAFILE=MODELS\Shotguns\XM1014\XM1014First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=XM1014First3rd X=0 Y=0 Z=-9 Yaw=64

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=XM1014MeshAnims ANIMFILE=ModelsSkeletal\Shotguns\XM1014\XM1014MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=XM1014MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=159
#exec ANIM SEQUENCE ANIM=XM1014MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=XM1014MeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=XM1014MeshAnims SEQ=StartShells STARTFRAME=43 NUMFRAMES=21
#exec ANIM SEQUENCE ANIM=XM1014MeshAnims SEQ=InsertShells STARTFRAME=65 NUMFRAMES=36
#exec ANIM SEQUENCE ANIM=XM1014MeshAnims SEQ=EndShells STARTFRAME=102 NUMFRAMES=13
#exec ANIM SEQUENCE ANIM=XM1014MeshAnims SEQ=Fire1 STARTFRAME=116 NUMFRAMES=21
#exec ANIM SEQUENCE ANIM=XM1014MeshAnims SEQ=Fire2 STARTFRAME=138 NUMFRAMES=21

#exec ANIM DIGEST ANIM=XM1014MeshAnims
#exec MESH DEFAULTANIM MESH=XM1014Mesh ANIM=XM1014MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=XM1014FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=XM1014FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=XM1014First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=XM1014First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=XM1014Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=XM1014FirstPick MESH=XM1014FirstPick
#exec MESHMAP SCALE MESHMAP=XM1014FirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=XM1014First3rd MESH=XM1014First3rd
#exec MESHMAP SCALE MESHMAP=XM1014First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=XM1014MeshSkin00 FILE=Textures\Shotguns\XM1014\XM1014Body.bmp GROUP=XM1014 LODSET=2
#exec TEXTURE IMPORT NAME=XM1014BodyPick FILE=Textures\Shotguns\XM1014\XM1014BodyPick.bmp GROUP=XM1014 LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Mesh NUM=0 TEXTURE=XM1014MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Mesh NUM=1 TEXTURE=M3MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Mesh NUM=2 TEXTURE=M3MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=XM1014Mesh NUM=3 TEXTURE=M3MeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=XM1014FirstPick NUM=1 TEXTURE=XM1014BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=XM1014First3rd NUM=1 TEXTURE=XM1014BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="XM1014Fire" FILE=Sounds\Shotguns\XM1014\XM1014_fire.wav GROUP="XM1014"
#exec AUDIO IMPORT NAME="XM1014Insert" FILE=Sounds\Shotguns\XM1014\XM1014_insertshell.wav GROUP="XM1014"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=M3Muzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=M3Muzzle STRENGTH=0
#exec MESH ORIGIN MESH=M3Muzzle X=-510 Y=0 Z=-15

#exec MESH SEQUENCE MESH=M3Muzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M3Muzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=M3Muzzle MESH=M3Muzzle
#exec MESHMAP SCALE MESHMAP=M3Muzzle X=0.115 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=M3Muzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle04.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=M3Muzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=XM1014Icon FILE=Textures\Icons\XM1014Icon.bmp GROUP=XM1014 MIPS=OFF

//=========================================================================================

var name FireAnims[2];

replication
{
	reliable if(Role == ROLE_Authority)
		ClientReloadStart, ClientReloadInsert, ClientReloadEnd;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayAnim(FireAnims[Rand(2)], 2.0, 0.04);
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
		
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	local int shots;

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		for (shots = 0; shots < 4; shots++)
			TraceFire(12.0);

		bPointing=True;
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount<=0 && AmmoType.AmmoAmount>0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

//---------------------------------------------------------------------------------------------------------------

function ReloadStart()
{
	PlayReloadStart();
	ClientReloadStart();
}

simulated function PlayReloadStart()
{
	PlayAnim('StartShells', 1.2, 0.04);
}

simulated function ClientReloadStart()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadStart();
		GoToState('ClientReloading');
	}
}

//---------------------------------------------------------------------------------------------------------------

function ReloadInsert()
{
	PlayReloadInsert();
	ClientReloadInsert();
}

simulated function PlayReloadInsert()
{
	PlayAnim('InsertShells', 2.1, 0.04);
}

simulated function ClientReloadInsert()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadInsert();
		GoToState('ClientReloading');
	}
}

//---------------------------------------------------------------------------------------------------------------

function ReloadEnd()
{
	PlayReloadEnd();
	ClientReloadEnd();
}

simulated function PlayReloadEnd()
{
	PlayAnim('EndShells', 1.2, 0.04);
}

simulated function ClientReloadEnd()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadEnd();
		GoToState('ClientReloading');
	}
}

//---------------------------------------------------------------------------------------------------------------

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
    	GoToState('NewClip');
    	ClientReload();
    }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
     }
}

simulated State NewClip
{
	ignores AltFire, Reload;

Begin:
	ReloadStart();
	FinishAnim();
Shell:
	do
	{
		ReloadInsert();
		Owner.PlaySound(ReloadSounds[0], SLOT_Misc, Pawn(Owner).SoundDampening);
		FinishAnim();
		ClipCount++;
	} until (ClipCount >= Default.Clipcount)
	ReloadEnd();
	FinishAnim();
	Sleep (0.1);
	Finish();
	PlayAnim('Still', 1.5, 0.04);
	FinishAnim();
	GotoState('Idle');
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }
}

defaultproperties
{
	FireAnims(0)=Fire1
	FireAnims(1)=Fire2
	HeadShotMultiplier=1.50
	PawnPenetrationValue=136.00
	WallPenetrationValue=120.00
	ShellCaseType=Class'CSSWeapons.CSSShellsShotgun'
	ShellCaseScale=2.000000
    ReloadSounds(0)=Sound'CSSWeapons.XM1014.XM1014Insert'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    EjectOffset=(X=25.000000,Y=10.000000,Z=-10.000000)
    FireSound=Sound'CSSWeapons.XM1014.XM1014Fire'
    HitDamage=25
    Recoil=(Vertical=0.520000,Horizontal=0.220000,duration=0.100000)
    ClipCount=7
    PickupAmmoCount=28
    AmmoName=Class'CSSWeapons.AmmoShotgun'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-10.000000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.550000
    RefireRate=0.800000
    AltRefireRate=0.900000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.100000
    FlashO=0.009000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=4
    InventoryGroup=3
    PickupMessage="You got a XM1014 Shotgun."
    ItemName="XM1014 Shotgun"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.XM1014Mesh'
    PlayerViewScale=10.000000
    PickupViewMesh=LodMesh'CSSWeapons.XM1014FirstPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CSSWeapons.XM1014First3rd'
    ThirdPersonScale=2.20
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.M3Muzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.XM1014FirstPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CSSWeapons.XM1014.XM1014Icon'
    StatusIcon=Texture'CSSWeapons.XM1014.XM1014Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}