class Shotgun_M3 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=M3Mesh MODELFILE=ModelsSkeletal\Shotguns\M3\M3Mesh.psk
#exec MESH ORIGIN MESH=M3Mesh X=-0.8 Y=-1 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=M3FirstPick ANIVFILE=MODELS\Shotguns\M3\M3FirstPick_a.3d DATAFILE=MODELS\Shotguns\M3\M3FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M3FirstPick X=0 Y=0 Z=27.2

//3rd Person
#exec MESH IMPORT MESH=M3First3rd ANIVFILE=MODELS\Shotguns\M3\M3First3rd_a.3d DATAFILE=MODELS\Shotguns\M3\M3First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M3First3rd X=20 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=M3MeshAnims ANIMFILE=ModelsSkeletal\Shotguns\M3\M3MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=201
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=StartShells STARTFRAME=43 NUMFRAMES=16
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=InsertShells STARTFRAME=60 NUMFRAMES=28
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=EndShells STARTFRAME=89 NUMFRAMES=36
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=Fire1 STARTFRAME=126 NUMFRAMES=37
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=Fire2 STARTFRAME=164 NUMFRAMES=37

#exec ANIM DIGEST ANIM=M3MeshAnims
#exec MESH DEFAULTANIM MESH=M3Mesh ANIM=M3MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=M3FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M3FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=M3First3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=M3First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=M3Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=M3FirstPick MESH=M3FirstPick
#exec MESHMAP SCALE MESHMAP=M3FirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=M3First3rd MESH=M3First3rd
#exec MESHMAP SCALE MESHMAP=M3First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=M3MeshSkin00 FILE=Textures\Shotguns\M3\M3Body2.bmp GROUP=M3 LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M3BodyPick FILE=Textures\Shotguns\M3\M3BodyPick.bmp GROUP=M3 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=0 TEXTURE=M3MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=1 TEXTURE=M3MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=2 TEXTURE=M3MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=3 TEXTURE=M3MeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=M3FirstPick NUM=1 TEXTURE=M3BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=M3First3rd NUM=1 TEXTURE=M3BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="M3Fire" FILE=Sounds\Shotguns\M3\m3_fire.wav GROUP="M3"
#exec AUDIO IMPORT NAME="M3Pump" FILE=Sounds\Shotguns\M3\m3_pump.wav GROUP="M3"
#exec AUDIO IMPORT NAME="M3Insert" FILE=Sounds\Shotguns\M3\m3_insertshell.wav GROUP="M3"

//=========================================================================================

#exec TEXTURE IMPORT NAME=M3Icon FILE=Textures\Icons\M3Icon.bmp GROUP=M3 MIPS=OFF

//=========================================================================================

var name FireAnims[2];

replication
{
	reliable if(Role == ROLE_Authority)
		ClientReloadStart, ClientReloadInsert, ClientReloadEnd;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0, 0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[0], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	GoToState('Selector');	
}

simulated function JustFire()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim(FireAnims[Rand(2)], 0.9, 0.04);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	local int shots;

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		for (shots = 0; shots < 5; shots++)
			TraceFire(12.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount<=0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		Sleep(0.97);
		SpawnShellCase(vect(10,-500,1));
		FinishAnim();
		Finish();
}

//---------------------------------------------------------------------------------------------------------------

function ReloadStart()
{
	PlayReloadStart();
	ClientReloadStart();
}

simulated function PlayReloadStart()
{
	PlayAnim('StartShells', 1.1, 0.04);
}

simulated function ClientReloadStart()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadStart();
		GoToState('ClientReloading');
	}
}

//---------------------------------------------------------------------------------------------------------------

function ReloadInsert()
{
	PlayReloadInsert();
	ClientReloadInsert();
}

simulated function PlayReloadInsert()
{
	PlayAnim('InsertShells', 1.7, 0.04);
}

simulated function ClientReloadInsert()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadInsert();
		GoToState('ClientReloading');
	}
}

//---------------------------------------------------------------------------------------------------------------

function ReloadEnd()
{
	PlayReloadEnd();
	ClientReloadEnd();
}

simulated function PlayReloadEnd()
{
	PlayAnim('EndShells', 1.3, 0.04);
}

simulated function ClientReloadEnd()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadEnd();
		GoToState('ClientReloading');
	}
}

//---------------------------------------------------------------------------------------------------------------

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
    	GoToState('NewClip');
    	ClientReload();
    }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
     }
}

simulated state NewClip
{
	ignores AltFire, Reload;

Begin:
	ReloadStart();
	FinishAnim();
Shell:
	do
	{
		ReloadInsert();
		Owner.PlaySound(ReloadSounds[1], SLOT_Misc, Pawn(Owner).SoundDampening);
		FinishAnim();
		ClipCount++;
	} until (ClipCount >= Default.Clipcount)
	ReloadEnd();
	Sleep (0.25);
	Owner.PlaySound(ReloadSounds[0], SLOT_Misc, Pawn(Owner).SoundDampening);
	FinishAnim();
	Sleep (0.1);
	Finish();
	PlayAnim('Still', 1.5, 0.04);
	FinishAnim();
	GotoState('Idle');
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }
}

defaultproperties
{
	FireAnims(0)=Fire1
	FireAnims(1)=Fire2
	HeadShotMultiplier=1.50
	PawnPenetrationValue=136.00
	WallPenetrationValue=120.00
	ShellCaseType=Class'CSSWeapons.CSSShellsShotgun'
	ShellCaseScale=2.000000
    ReloadSounds(0)=Sound'CSSWeapons.M3.M3Pump'
    ReloadSounds(1)=Sound'CSSWeapons.M3.M3Insert'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    EjectOffset=(X=25.000000,Y=10.000000,Z=-10.000000)
    FireSound=Sound'CSSWeapons.M3.M3Fire'
    HitDamage=25
    Recoil=(Vertical=1.220000,Horizontal=0.220000,duration=0.100000)
    ClipCount=8
    PickupAmmoCount=24
    AmmoName=Class'CSSWeapons.AmmoShotgun'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-10.000000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.500000
    RefireRate=0.800000
    AltRefireRate=0.900000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.100000
    FlashO=0.007900
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=4
    InventoryGroup=3
    PickupMessage="You got a M3 Shotgun."
    ItemName="M3 Shotgun"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.M3Mesh'
    PlayerViewScale=10.000000
    PickupViewMesh=LodMesh'CSSWeapons.M3FirstPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CSSWeapons.M3First3rd'
    ThirdPersonScale=2.20
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.M3Muzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.M3FirstPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CSSWeapons.M3.M3Icon'
    StatusIcon=Texture'CSSWeapons.M3.M3Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}