class SMG_UMP45 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=UMP45Mesh MODELFILE=ModelsSkeletal\SMG\UMP45\UMP45Mesh.psk
#exec MESH ORIGIN MESH=UMP45Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=UMP45FirstPick ANIVFILE=MODELS\SMG\UMP45\UMP45FirstPick_a.3d DATAFILE=MODELS\SMG\UMP45\UMP45FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=UMP45FirstPick X=0 Y=0 Z=8

//3rd Person
#exec MESH IMPORT MESH=UMP45First3rd ANIVFILE=MODELS\SMG\UMP45\UMP45First3rd_a.3d DATAFILE=MODELS\SMG\UMP45\UMP45First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=UMP45First3rd X=10 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=UMP45MeshAnims ANIMFILE=ModelsSkeletal\SMG\UMP45\UMP45MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=UMP45MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=169
#exec ANIM SEQUENCE ANIM=UMP45MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=27
#exec ANIM SEQUENCE ANIM=UMP45MeshAnims SEQ=Still STARTFRAME=28 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=UMP45MeshAnims SEQ=Reload STARTFRAME=38 NUMFRAMES=115
#exec ANIM SEQUENCE ANIM=UMP45MeshAnims SEQ=Fire STARTFRAME=154 NUMFRAMES=15
#exec ANIM SEQUENCE ANIM=UMP45MeshAnims SEQ=AfterFire STARTFRAME=160 NUMFRAMES=9

#exec ANIM DIGEST ANIM=UMP45MeshAnims
#exec MESH DEFAULTANIM MESH=UMP45Mesh ANIM=UMP45MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=UMP45FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UMP45FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=UMP45First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UMP45First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=UMP45Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=UMP45FirstPick MESH=UMP45FirstPick
#exec MESHMAP SCALE MESHMAP=UMP45FirstPick X=0.1 Y=0.1 Z=0.25

//3rd Person
#exec MESHMAP NEW MESHMAP=UMP45First3rd MESH=UMP45First3rd
#exec MESHMAP SCALE MESHMAP=UMP45First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=UMP45MeshSkin00 FILE=Textures\SMG\UMP45\UMP45Body.bmp GROUP=UMP45 LODSET=2
#exec TEXTURE IMPORT NAME=UMP45MeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=UMP45MeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=UMP45MeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=UMP45BodyPick FILE=Textures\SMG\UMP45\UMP45BodyPick.bmp GROUP=UMP45 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=UMP45Mesh NUM=0 TEXTURE=UMP45MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=UMP45Mesh NUM=1 TEXTURE=UMP45MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=UMP45Mesh NUM=2 TEXTURE=UMP45MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=UMP45Mesh NUM=3 TEXTURE=UMP45MeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=UMP45FirstPick NUM=1 TEXTURE=UMP45BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=UMP45First3rd NUM=1 TEXTURE=UMP45BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="UMP45Fire" FILE=Sounds\SMG\UMP45\UMP45_fire.wav GROUP="UMP45"
#exec AUDIO IMPORT NAME="UMP45ClipOut" FILE=Sounds\SMG\UMP45\UMP45_clipout.wav GROUP="UMP45"
#exec AUDIO IMPORT NAME="UMP45ClipIn" FILE=Sounds\SMG\UMP45\UMP45_clipin.wav GROUP="UMP45"
#exec AUDIO IMPORT NAME="UMP45BoltSlap" FILE=Sounds\SMG\UMP45\UMP45_boltslap.wav GROUP="UMP45"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=P90Muzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=P90Muzzle STRENGTH=0
#exec MESH ORIGIN MESH=P90Muzzle X=-250 Y=0 Z=-25

#exec MESH SEQUENCE MESH=P90Muzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P90Muzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=P90Muzzle MESH=P90Muzzle
#exec MESHMAP SCALE MESHMAP=P90Muzzle X=0.105 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle03 FILE=Textures\SMGMuzzle03.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=P90Muzzle NUM=0 TEXTURE=SMGMuzzle03

#exec TEXTURE IMPORT NAME=SMGMuzzle04 FILE=Textures\SMGMuzzle04.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=P90Muzzle NUM=1 TEXTURE=SMGMuzzle04

//=========================================================================================

#exec TEXTURE IMPORT NAME=UMP45Icon FILE=Textures\Icons\UMP45Icon.bmp GROUP=UMP45 MIPS=OFF

//=========================================================================================

var Texture RandFlash[9];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.6, 0.04);
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 5.0, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.9, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.25);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.10);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.25);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.10);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz6'
	RandFlash(6)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz7'
	RandFlash(7)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz8'
	RandFlash(8)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz9'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=136.00
	WallPenetrationValue=120.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.850000
    ReloadSounds(0)=Sound'CSSWeapons.UMP45.UMP45ClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.UMP45.UMP45ClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.UMP45.UMP45BoltSlap'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.UMP45.UMP45Fire'
    EjectOffset=(X=20.000000,Y=15.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=25
    Recoil=(Vertical=0.220000,Horizontal=1.020000,duration=0.100000)
    PickupAmmoCount=125
    AmmoName=Class'CSSWeapons.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.630000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a UMP-45."
    ItemName="UMP-45"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.UMP45Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.UMP45FirstPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'CSSWeapons.UMP45First3rd'
    ThirdPersonScale=2.20000
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.P90Muzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.UMP45FirstPick'
    bNoSmooth=False
    Icon=Texture'CSSWeapons.UMP45.UMP45Icon'
    StatusIcon=Texture'CSSWeapons.UMP45.UMP45Icon'
    DrawScale=3.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}