class SMG_TMP extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=TMPMesh MODELFILE=ModelsSkeletal\SMG\TMP\TMPMesh.psk
#exec MESH ORIGIN MESH=TMPMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=TMPFirstPick ANIVFILE=MODELS\SMG\TMP\TMPFirstPick_a.3d DATAFILE=MODELS\SMG\TMP\TMPFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TMPFirstPick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=TMPFirst3rd ANIVFILE=MODELS\SMG\TMP\TMPFirst3rd_a.3d DATAFILE=MODELS\SMG\TMP\TMPFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TMPFirst3rd X=20 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=TMPMeshAnims ANIMFILE=ModelsSkeletal\SMG\TMP\TMPMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=TMPMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=148
#exec ANIM SEQUENCE ANIM=TMPMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=17 Rate=16.2
#exec ANIM SEQUENCE ANIM=TMPMeshAnims SEQ=Still STARTFRAME=18 NUMFRAMES=61
#exec ANIM SEQUENCE ANIM=TMPMeshAnims SEQ=Reload STARTFRAME=80 NUMFRAMES=54
#exec ANIM SEQUENCE ANIM=TMPMeshAnims SEQ=Fire STARTFRAME=135 NUMFRAMES=13
#exec ANIM SEQUENCE ANIM=TMPMeshAnims SEQ=AfterFire STARTFRAME=138 NUMFRAMES=10

#exec ANIM DIGEST ANIM=TMPMeshAnims
#exec MESH DEFAULTANIM MESH=TMPMesh ANIM=TMPMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=TMPFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TMPFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=TMPFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=TMPFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=TMPMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=TMPFirstPick MESH=TMPFirstPick
#exec MESHMAP SCALE MESHMAP=TMPFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=TMPFirst3rd MESH=TMPFirst3rd
#exec MESHMAP SCALE MESHMAP=TMPFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=TMPMeshSkin00  FILE=Textures\SMG\TMP\TMPBody.bmp  GROUP=TMP LODSET=2
#exec TEXTURE IMPORT NAME=TMPBodyPick  FILE=Textures\SMG\TMP\TMPBodyPick.bmp  GROUP=TMP LODSET=2
#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=TMPMesh NUM=0 TEXTURE=TMPMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=TMPMesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=TMPFirstPick NUM=1 TEXTURE=TMPBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=TMPFirst3rd NUM=1 TEXTURE=TMPBodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="TMPFire" FILE=Sounds\SMG\TMP\tmp_fire.wav GROUP="TMP"
#exec AUDIO IMPORT NAME="TMPClipOut" FILE=Sounds\SMG\TMP\tmp_clipout.wav GROUP="TMP"
#exec AUDIO IMPORT NAME="TMPClipIn" FILE=Sounds\SMG\TMP\tmp_clipin.wav GROUP="TMP"

//=========================================================================================

#exec TEXTURE IMPORT NAME=TMPIcon FILE=Textures\Icons\TMPIcon.bmp GROUP=TMP MIPS=OFF

//=========================================================================================

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 10, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.7, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.38);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	Sleep(0.38);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
   	//ignores AltFire;

    Begin:
        if(isAnimating())
        	FinishAnim();
        PlayIdleAnim();
     	if(AmmoType.AmmoAmount<=0 && Pawn(Owner) != None)
        	Pawn(Owner).SwitchToBestWeapon();

	Checks:
		if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
			Reload();

		Sleep(0.0);
		GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	LoopAnim('Still', 0.2);
	GoToState('Idle','Checks');
}

defaultproperties
{
	HeadShotMultiplier=1.50
	PawnPenetrationValue=136.00
	WallPenetrationValue=120.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.800000
    ReloadSounds(0)=Sound'CSSWeapons.TMP.TMPClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.TMP.TMPClipIn'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.TMP.TMPFire'
    EjectOffset=(X=20.000000,Y=15.000000,Z=-10.000000)
    HitDamage=18
    ClipCount=30
    Recoil=(Vertical=0.220000,Horizontal=1.220000,duration=0.100000)
    PickupAmmoCount=120
    AmmoName=Class'CSSWeapons.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=0.000000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.600000
    RefireRate=0.900000
    AltRefireRate=0.900000
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a TMP."
    ItemName="TMP"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.TMPMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.TMPFirstPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'CSSWeapons.TMPFirst3rd'
    ThirdPersonScale=2.20000
    Mesh=LodMesh'CSSWeapons.TMPFirstPick'
    bNoSmooth=False
    Icon=Texture'CSSWeapons.TMP.TMPIcon'
    StatusIcon=Texture'CSSWeapons.TMP.TMPIcon'
    DrawScale=3.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}