class SMG_P90 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=P90Mesh MODELFILE=ModelsSkeletal\SMG\P90\P90Mesh.psk
#exec MESH ORIGIN MESH=P90Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=P90FirstPick ANIVFILE=MODELS\SMG\P90\P90FirstPick_a.3d DATAFILE=MODELS\SMG\P90\P90FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P90FirstPick X=0 Y=0 Z=19

//3rd Person
#exec MESH IMPORT MESH=P90First3rd ANIVFILE=MODELS\SMG\P90\P90First3rd_a.3d DATAFILE=MODELS\SMG\P90\P90First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P90First3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=P90MeshAnims ANIMFILE=ModelsSkeletal\SMG\P90\P90MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=P90MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=193
#exec ANIM SEQUENCE ANIM=P90MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=P90MeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=P90MeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=136
#exec ANIM SEQUENCE ANIM=P90MeshAnims SEQ=Fire STARTFRAME=180 NUMFRAMES=13
#exec ANIM SEQUENCE ANIM=P90MeshAnims SEQ=AfterFire STARTFRAME=187 NUMFRAMES=6

#exec ANIM DIGEST ANIM=P90MeshAnims
#exec MESH DEFAULTANIM MESH=P90Mesh ANIM=P90MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=P90FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P90FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=P90First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P90First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=P90Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=P90FirstPick MESH=P90FirstPick
#exec MESHMAP SCALE MESHMAP=P90FirstPick X=0.08 Y=0.08 Z=0.18

//3rd Person
#exec MESHMAP NEW MESHMAP=P90First3rd MESH=P90First3rd
#exec MESHMAP SCALE MESHMAP=P90First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=P90MeshSkin00 FILE=Textures\SMG\P90\P90Body.bmp GROUP=P90 LODSET=2
#exec TEXTURE IMPORT NAME=P90MeshSkin01 FILE=Textures\SMG\P90\P90Sight.bmp GROUP=P90 LODSET=2
#exec TEXTURE IMPORT NAME=P90MeshSkin02 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=P90MeshSkin03 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=P90MeshSkin04 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=P90BodyPick FILE=Textures\SMG\P90\P90BodyPick.bmp GROUP=P90 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=P90Mesh NUM=0 TEXTURE=P90MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=P90Mesh NUM=1 TEXTURE=P90MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=P90Mesh NUM=2 TEXTURE=P90MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=P90Mesh NUM=3 TEXTURE=P90MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=P90Mesh NUM=4 TEXTURE=P90MeshSkin04

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=P90FirstPick NUM=1 TEXTURE=P90BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=P90First3rd NUM=1 TEXTURE=P90BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="P90Fire" FILE=Sounds\SMG\P90\P90_fire.wav GROUP="P90"
#exec AUDIO IMPORT NAME="P90ClipOut" FILE=Sounds\SMG\P90\P90_clipout.wav GROUP="P90"
#exec AUDIO IMPORT NAME="P90ClipIn" FILE=Sounds\SMG\P90\P90_clipin.wav GROUP="P90"
#exec AUDIO IMPORT NAME="P90ClipRelease" FILE=Sounds\SMG\P90\P90_cliprelease.wav GROUP="P90"
#exec AUDIO IMPORT NAME="P90BoltPull" FILE=Sounds\SMG\P90\P90_boltpull.wav GROUP="P90"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=P90Muzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=P90Muzzle STRENGTH=0
#exec MESH ORIGIN MESH=P90Muzzle X=-250 Y=0 Z=-25

#exec MESH SEQUENCE MESH=P90Muzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P90Muzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=P90Muzzle MESH=P90Muzzle
#exec MESHMAP SCALE MESHMAP=P90Muzzle X=0.105 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle03 FILE=Textures\SMGMuzzle03.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=P90Muzzle NUM=0 TEXTURE=SMGMuzzle03

#exec TEXTURE IMPORT NAME=SMGMuzzle04 FILE=Textures\SMGMuzzle04.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=P90Muzzle NUM=1 TEXTURE=SMGMuzzle04

//=========================================================================================

#exec TEXTURE IMPORT NAME=P90Icon FILE=Textures\Icons\P90Icon.bmp GROUP=P90 MIPS=OFF

//=========================================================================================

var Texture RandFlash[9];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',0.8,0.0);
	Sleep(0.45);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[3], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.45);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.04);
	GoToState('Selector');
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 10.0, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.1, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz6'
	RandFlash(6)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz7'
	RandFlash(7)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz8'
	RandFlash(8)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz9'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=136.00
	WallPenetrationValue=120.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.850000
	ReloadSounds(0)=Sound'CSSWeapons.P90.P90ClipRelease'
    ReloadSounds(1)=Sound'CSSWeapons.P90.P90ClipOut'
    ReloadSounds(2)=Sound'CSSWeapons.P90.P90ClipIn'
    ReloadSounds(3)=Sound'CSSWeapons.P90.P90BoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.P90.P90Fire'
    EjectOffset=(X=20.000000,Y=15.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=50
    Recoil=(Vertical=0.220000,Horizontal=1.020000,duration=0.100000)
    PickupAmmoCount=150
    AmmoName=Class'CSSWeapons.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.640000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.150000
    FlashO=0.010000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a P90."
    ItemName="P90"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.P90Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.P90FirstPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'CSSWeapons.P90First3rd'
    ThirdPersonScale=2.20000
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.P90Muzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.P90FirstPick'
    bNoSmooth=False
    Icon=Texture'CSSWeapons.P90.P90Icon'
    StatusIcon=Texture'CSSWeapons.P90.P90Icon'
    DrawScale=3.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}