class SMG_Mac10 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=Mac10Mesh MODELFILE=ModelsSkeletal\SMG\Mac10\Mac10Mesh.psk
#exec MESH ORIGIN MESH=Mac10Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=Mac10FirstPick ANIVFILE=MODELS\SMG\Mac10\Mac10FirstPick_a.3d DATAFILE=MODELS\SMG\Mac10\Mac10FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Mac10FirstPick X=0 Y=0 Z=19.5

//3rd Person
#exec MESH IMPORT MESH=Mac10First3rd ANIVFILE=MODELS\SMG\Mac10\Mac10First3rd_a.3d DATAFILE=MODELS\SMG\Mac10\Mac10First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Mac10First3rd X=0 Y=0 Z=-9 Yaw=64

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=Mac10MeshAnims ANIMFILE=ModelsSkeletal\SMG\Mac10\Mac10MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=180
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=111
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=Fire STARTFRAME=155 NUMFRAMES=25
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=AfterFire STARTFRAME=168 NUMFRAMES=12

#exec ANIM DIGEST ANIM=Mac10MeshAnims
#exec MESH DEFAULTANIM MESH=Mac10Mesh ANIM=Mac10MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=Mac10FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Mac10FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=Mac10First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Mac10First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=Mac10Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=Mac10FirstPick MESH=Mac10FirstPick
#exec MESHMAP SCALE MESHMAP=Mac10FirstPick X=0.06 Y=0.06 Z=0.16

//3rd Person
#exec MESHMAP NEW MESHMAP=Mac10First3rd MESH=Mac10First3rd
#exec MESHMAP SCALE MESHMAP=Mac10First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=Mac10MeshSkin00 FILE=Textures\SMG\Mac10\Mac10Body.bmp GROUP=Mac10 LODSET=2
#exec TEXTURE IMPORT NAME=Mac10MeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=Mac10MeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=Mac10MeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=Mac10BodyPick FILE=Textures\SMG\Mac10\Mac10BodyPick.bmp GROUP=Mac10 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=0 TEXTURE=Mac10MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=1 TEXTURE=Mac10MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=2 TEXTURE=Mac10MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=3 TEXTURE=Mac10MeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=Mac10FirstPick NUM=1 TEXTURE=Mac10BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Mac10First3rd NUM=1 TEXTURE=Mac10BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="Mac10Fire" FILE=Sounds\SMG\Mac10\mac10_fire.wav GROUP="Mac10"
#exec AUDIO IMPORT NAME="Mac10ClipOut" FILE=Sounds\SMG\Mac10\mac10_clipout.wav GROUP="Mac10"
#exec AUDIO IMPORT NAME="Mac10ClipIn" FILE=Sounds\SMG\Mac10\mac10_clipin.wav GROUP="Mac10"
#exec AUDIO IMPORT NAME="Mac10BoltPull" FILE=Sounds\SMG\Mac10\mac10_boltpull.wav GROUP="Mac10"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=Mac10Muzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=Mac10Muzzle STRENGTH=0
#exec MESH ORIGIN MESH=Mac10Muzzle X=-110 Y=0 Z=-25

#exec MESH SEQUENCE MESH=Mac10Muzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Mac10Muzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=Mac10Muzzle MESH=Mac10Muzzle
#exec MESHMAP SCALE MESHMAP=Mac10Muzzle X=0.105 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle03 FILE=Textures\SMGMuzzle03.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Muzzle NUM=0 TEXTURE=SMGMuzzle03

#exec TEXTURE IMPORT NAME=SMGMuzzle04 FILE=Textures\SMGMuzzle04.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Muzzle NUM=1 TEXTURE=SMGMuzzle04

//=========================================================================================

#exec TEXTURE IMPORT NAME=Mac10Icon FILE=Textures\Icons\Mac10Icon.bmp GROUP=Mac10 MIPS=OFF

//=========================================================================================

var Texture RandFlash[9];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 10.0, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.1, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.65);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.95);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.65);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.95);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz6'
	RandFlash(6)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz7'
	RandFlash(7)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz8'
	RandFlash(8)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz9'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=136.00
	WallPenetrationValue=120.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.850000
    ReloadSounds(0)=Sound'CSSWeapons.Mac10.Mac10ClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.Mac10.Mac10ClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.Mac10.Mac10BoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.Mac10.Mac10Fire'
    EjectOffset=(X=20.000000,Y=15.000000,Z=-10.000000)
    HitDamage=18
    ClipCount=30
    Recoil=(Vertical=0.220000,Horizontal=1.020000,duration=0.100000)
    PickupAmmoCount=120
    AmmoName=Class'CSSWeapons.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.610000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.120000
    FlashO=0.012000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a Mac-10."
    ItemName="Mac-10"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.Mac10Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.Mac10FirstPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'CSSWeapons.Mac10First3rd'
    ThirdPersonScale=2.20000
    bMuzzleFlashParticles=False
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.Mac10Muzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.Mac10FirstPick'
    bNoSmooth=False
    Icon=Texture'CSSWeapons.Mac10.Mac10Icon'
    StatusIcon=Texture'CSSWeapons.Mac10.Mac10Icon'
    DrawScale=3.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}