class SMG_MP5 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=MP5Mesh MODELFILE=ModelsSkeletal\SMG\MP5\MP5Mesh.psk
#exec MESH ORIGIN MESH=MP5Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=MP5FirstPick ANIVFILE=MODELS\SMG\MP5\MP5FirstPick_a.3d DATAFILE=MODELS\SMG\MP5\MP5FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MP5FirstPick X=0 Y=0 Z=19

//3rd Person
#exec MESH IMPORT MESH=MP5First3rd ANIVFILE=MODELS\SMG\MP5\MP5First3rd_a.3d DATAFILE=MODELS\SMG\MP5\MP5First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MP5First3rd X=0 Y=0 Z=-9 Yaw=64

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=MP5MeshAnims ANIMFILE=ModelsSkeletal\SMG\MP5\MP5MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=182
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=117
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=Fire STARTFRAME=161 NUMFRAMES=21
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=AfterFire STARTFRAME=170 NUMFRAMES=12

#exec ANIM DIGEST ANIM=MP5MeshAnims
#exec MESH DEFAULTANIM MESH=MP5Mesh ANIM=MP5MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=MP5FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MP5FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=MP5First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MP5First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=MP5Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=MP5FirstPick MESH=MP5FirstPick
#exec MESHMAP SCALE MESHMAP=MP5FirstPick X=0.06 Y=0.06 Z=0.16

//3rd Person
#exec MESHMAP NEW MESHMAP=MP5First3rd MESH=MP5First3rd
#exec MESHMAP SCALE MESHMAP=MP5First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=MP5MeshSkin00 FILE=Textures\SMG\MP5\MP5Body.bmp GROUP=MP5 LODSET=2
#exec TEXTURE IMPORT NAME=MP5MeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=MP5MeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=MP5MeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=MP5BodyPick FILE=Textures\SMG\MP5\MP5BodyPick.bmp GROUP=MP5 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=0 TEXTURE=MP5MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=1 TEXTURE=MP5MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=2 TEXTURE=MP5MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=3 TEXTURE=MP5MeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=MP5FirstPick NUM=1 TEXTURE=MP5BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=MP5First3rd NUM=1 TEXTURE=MP5BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="MP5Fire" FILE=Sounds\SMG\MP5\MP5_fire.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5ClipOut" FILE=Sounds\SMG\MP5\MP5_clipout.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5ClipIn" FILE=Sounds\SMG\MP5\MP5_clipin.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5SlideBack" FILE=Sounds\SMG\MP5\MP5_slideback.wav GROUP="MP5"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=MP5Muzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=MP5Muzzle STRENGTH=0
#exec MESH ORIGIN MESH=MP5Muzzle X=-350 Y=0 Z=-25

#exec MESH SEQUENCE MESH=MP5Muzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MP5Muzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=MP5Muzzle MESH=MP5Muzzle
#exec MESHMAP SCALE MESHMAP=MP5Muzzle X=0.105 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle03 FILE=Textures\SMGMuzzle03.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=MP5Muzzle NUM=0 TEXTURE=SMGMuzzle03

#exec TEXTURE IMPORT NAME=SMGMuzzle04 FILE=Textures\SMGMuzzle04.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=MP5Muzzle NUM=1 TEXTURE=SMGMuzzle04

//=========================================================================================

#exec TEXTURE IMPORT NAME=MP5Icon FILE=Textures\Icons\MP5Icon.bmp GROUP=MP5 MIPS=OFF

//=========================================================================================

var Texture RandFlash[9];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',0.8,0.0);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.04);
	GoToState('Selector');
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound);
	PlayAnim('Fire', 11.0, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.1, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.97);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.97);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz6'
	RandFlash(6)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz7'
	RandFlash(7)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz8'
	RandFlash(8)=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz9'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=136.00
	WallPenetrationValue=120.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.850000
    ReloadSounds(0)=Sound'CSSWeapons.MP5.MP5ClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.MP5.MP5ClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.MP5.MP5SlideBack'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.MP5.MP5Fire'
    EjectOffset=(X=20.000000,Y=15.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=30
    Recoil=(Vertical=0.220000,Horizontal=1.020000,duration=0.100000)
    PickupAmmoCount=120
    AmmoName=Class'CSSWeapons.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.620000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CSSWeapons.MuzzleFlashes.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a MP5."
    ItemName="MP5"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.MP5Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.MP5FirstPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'CSSWeapons.MP5First3rd'
    ThirdPersonScale=2.20000
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.MP5Muzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.MP5FirstPick'
    bNoSmooth=False
    Icon=Texture'CSSWeapons.MP5.MP5Icon'
    StatusIcon=Texture'CSSWeapons.MP5.MP5Icon'
    DrawScale=3.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}