class Rifle_SG550 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=SG550Mesh MODELFILE=ModelsSkeletal\Rifles\SG550\SG550Mesh.psk
#exec MESH ORIGIN MESH=SG550Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=SG550FirstPick ANIVFILE=MODELS\Rifles\SG550\SG550FirstPick_a.3d DATAFILE=MODELS\Rifles\SG550\SG550FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SG550FirstPick X=0 Y=0 Z=19

//3rd Person
#exec MESH IMPORT MESH=SG550First3rd ANIVFILE=MODELS\Rifles\SG550\SG550First3rd_a.3d DATAFILE=MODELS\Rifles\SG550\SG550First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SG550First3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=SG550MeshAnims ANIMFILE=ModelsSkeletal\Rifles\SG550\SG550MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=196
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=106
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=Fire STARTFRAME=150 NUMFRAMES=46
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=AfterFire STARTFRAME=190 NUMFRAMES=6

#exec ANIM DIGEST ANIM=SG550MeshAnims
#exec MESH DEFAULTANIM MESH=SG550Mesh ANIM=SG550MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=SG550FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SG550FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=SG550First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SG550First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=SG550Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=SG550FirstPick MESH=SG550FirstPick
#exec MESHMAP SCALE MESHMAP=SG550FirstPick X=0.07 Y=0.07 Z=0.17

//3rd Person
#exec MESHMAP NEW MESHMAP=SG550First3rd MESH=SG550First3rd
#exec MESHMAP SCALE MESHMAP=SG550First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=SG550MeshSkin00 FILE=Textures\Rifles\SG550\SG550Scope.bmp GROUP=SG550 LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin01 FILE=Textures\Rifles\SG550\SG550Body.bmp GROUP=SG550 LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin02 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin03 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin04 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=SG550BodyPick FILE=Textures\Rifles\SG550\SG550BodyPick.bmp GROUP=SG550 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=0 TEXTURE=SG550MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=1 TEXTURE=SG550MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=2 TEXTURE=SG550MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=3 TEXTURE=SG550MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=4 TEXTURE=SG550MeshSkin04

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=SG550FirstPick NUM=1 TEXTURE=SG550BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=SG550First3rd NUM=1 TEXTURE=SG550BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="SG550Fire" FILE=Sounds\Rifles\SG550\SG550_fire.wav GROUP="SG550"
#exec AUDIO IMPORT NAME="SG550ClipOut" FILE=Sounds\Rifles\SG550\SG550_clipout.wav GROUP="SG550"
#exec AUDIO IMPORT NAME="SG550ClipIn" FILE=Sounds\Rifles\SG550\SG550_clipin.wav GROUP="SG550"
#exec AUDIO IMPORT NAME="SG550BoltPull" FILE=Sounds\Rifles\SG550\SG550_boltpull.wav GROUP="SG550"

//=========================================================================================

//Taken from Nali Weapons 3 - WRE weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=SG550RifleMuzzle ANIVFILE=MODELS\MuzzleFMesh\RifleMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\RifleMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=SG550RifleMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=SG550RifleMuzzle X=82 Y=0 Z=-9 Yaw=128

#exec MESH SEQUENCE MESH=SG550RifleMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SG550RifleMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=SG550RifleMuzzle MESH=SG550RifleMuzzle
#exec MESHMAP SCALE MESHMAP=SG550RifleMuzzle X=0.375 Y=0.375 Z=0.750

#exec TEXTURE IMPORT NAME=RifleMuzzle01 FILE=Textures\RifleMuzzle01.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=SG550RifleMuzzle NUM=1 TEXTURE=RifleMuzzle01

#exec TEXTURE IMPORT NAME=RifleMuzzle02 FILE=Textures\RifleMuzzle02.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=SG550RifleMuzzle NUM=2 TEXTURE=RifleMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=SG550Icon FILE=Textures\Icons\SG550Icon.bmp GROUP=SG550 MIPS=OFF

//=========================================================================================

var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

function DropFrom(vector StartLocation)
{
	Super.DropFrom(StartLocation);
	bDrawMuzzleFlash = True;
}

simulated function PostRender( canvas Canvas )
{
    local PlayerPawn P;
    local float Scale;
    local float ScopeScale, StartScopeX, StartScopeY, EndScopeX, EndScopeY;
    local float CntX, CntY;

    Super.PostRender(Canvas);
    P = PlayerPawn(Owner);
    if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
    {
    	bOwnsCrossHair = true;

    	Scale = Canvas.ClipY / 512;
    	CntX = Canvas.ClipX / 2;
		CntY = Canvas.ClipY / 2;
    	StartScopeX = (Canvas.ClipX - 512 * Scale)/2;
		StartScopeY = 0;
		EndScopeX = (Canvas.ClipX + 512 * Scale)/2;
		EndScopeY = Canvas.ClipY;

		Canvas.bNoSmooth = True;
    	Canvas.Style = ERenderStyle.STY_Modulated;

		Canvas.SetPos(StartScopeX, StartScopeY);
		Canvas.DrawIcon(Texture'ScopeN01', Scale);
		Canvas.SetPos(CntX, StartScopeY);
		Canvas.DrawIcon(Texture'ScopeN02', Scale);
		Canvas.SetPos(StartScopeX, CntY);
		Canvas.DrawIcon(Texture'ScopeN03', Scale);
		Canvas.SetPos(CntX, CntY);
		Canvas.DrawIcon(Texture'ScopeN04', Scale);

		Canvas.bNoSmooth = True;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 255;
		
		Canvas.SetPos(0, 0);
		Canvas.DrawRect(Texture'ScopeBack', StartScopeX, EndScopeY);
		Canvas.SetPos( EndScopeX, 0);
		Canvas.DrawRect(Texture'ScopeBack', StartScopeX, EndScopeY);

        Scale = P.DefaultFOV/P.DesiredFOV;
    }
    else if(Class'CSSMutator'.default.bEnableCrosshair)
    	bOwnsCrossHair = false;
	else
		bOwnsCrossHair = true;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				Owner.PlaySound(Sound'ZoomScope1');
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
					PlayerPawn(Owner).DesiredFOV = 45.0;
				else if (PlayerPawn(Owner).DesiredFOV == 45.0)
					PlayerPawn(Owner).DesiredFOV = 15.0;
				else
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
			}
		}
	}
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 5.0, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if (PlayerPawn(Owner) != None)
	{
		if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
			bDrawMuzzleFlash = True;
		else if (PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
			bDrawMuzzleFlash = False;

		bMuzzleFlash++;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(1.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function AltFire(float Value)
{
	ClientAltFire(Value);
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function Reload()
{
    if ((AmmoType.AmmoAmount > 0) && (ClipCount < Default.ClipCount)) 
    {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function ClientReload()
{
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
          GoToState('ClientReloading');
          PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.85, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.3);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.3);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz6'
	HeadShotMultiplier=2.00
	PawnPenetrationValue=346.00
	WallPenetrationValue=340.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=1.500000
	ReloadSounds(0)=Sound'CSSWeapons.SG550.SG550ClipOut'
	ReloadSounds(1)=Sound'CSSWeapons.SG550.SG550ClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.SG550.SG550BoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.SG550.SG550Fire'
    EjectOffset=(X=25.000000,Y=17.000000,Z=-10.000000)
    HitDamage=42
    ClipCount=30
    PickupAmmoCount=120
    Recoil=(Vertical=0.520000,Horizontal=1.020000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoRifles'
    bInstantHit=True
    FireOffset=(X=0.000000,Y=0.000000,Z=0.000000)
    MuzzleOffset=(Y=-7.200000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.850000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.700000
    FlashY=0.070000
    FlashO=0.009000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
    AutoSwitchPriority=7
    InventoryGroup=7
    PickupMessage="You got a SG550."
    ItemName="SG550"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'SG550Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'SG550FirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'SG550First3rd'
    ThirdPersonScale=1.85
    bMuzzleFlashParticles=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.SG550RifleMuzzle'
    MuzzleFlashScale=0.750000
    Mesh=LodMesh'CSSWeapons.SG550FirstPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CSSWeapons.SG550.SG550Icon'
    StatusIcon=Texture'CSSWeapons.SG550.SG550Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}