class Rifle_M4A1 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=M4A1Mesh MODELFILE=ModelsSkeletal\Rifles\M4A1\M4A1Mesh.psk
#exec MESH ORIGIN MESH=M4A1Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=M4A1FirstPickSilenced ANIVFILE=MODELS\Rifles\M4A1\M4A1FirstPickSilenced_a.3d DATAFILE=MODELS\Rifles\M4A1\M4A1FirstPickSilenced_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M4A1FirstPickSilenced X=0 Y=0 Z=18

#exec MESH IMPORT MESH=M4A1FirstPickUnSilenced ANIVFILE=MODELS\Rifles\M4A1\M4A1FirstPickUnSilenced_a.3d DATAFILE=MODELS\Rifles\M4A1\M4A1FirstPickUnSilenced_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M4A1FirstPickUnSilenced X=0 Y=0 Z=18

//3rd Person
#exec MESH IMPORT MESH=M4A1First3rd ANIVFILE=MODELS\Rifles\M4A1\M4A1First3rd_a.3d DATAFILE=MODELS\Rifles\M4A1\M4A1First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M4A1First3rd X=20 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=M4A1MeshAnims ANIMFILE=ModelsSkeletal\Rifles\M4A1\M4A1MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=498
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=SelectUnSilenced STARTFRAME=0 NUMFRAMES=41
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=SelectSilenced STARTFRAME=42 NUMFRAMES=40
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=StillUnSilenced STARTFRAME=83 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=StillSilenced STARTFRAME=93 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=AddSilencer STARTFRAME=103 NUMFRAMES=61
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=RemoveSilencer STARTFRAME=165 NUMFRAMES=61
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=ReloadUnSilenced STARTFRAME=227 NUMFRAMES=114
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=ReloadSilenced STARTFRAME=342 NUMFRAMES=114
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=FireUnSilenced STARTFRAME=457 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=AfterFireUnSilenced STARTFRAME=470 NUMFRAMES=18
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=FireSilenced STARTFRAME=489 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=AfterFireSilenced STARTFRAME=494 NUMFRAMES=4

#exec ANIM DIGEST ANIM=M4A1MeshAnims
#exec MESH DEFAULTANIM MESH=M4A1Mesh ANIM=M4A1MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=M4A1FirstPickUnSilenced SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M4A1FirstPickUnSilenced SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESH SEQUENCE MESH=M4A1FirstPickSilenced SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M4A1FirstPickSilenced SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=M4A1First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M4A1First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=M4A1Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=M4A1FirstPickUnSilenced MESH=M4A1FirstPickUnSilenced
#exec MESHMAP SCALE MESHMAP=M4A1FirstPickUnSilenced X=0.1 Y=0.1 Z=0.2

#exec MESHMAP NEW MESHMAP=M4A1FirstPickSilenced MESH=M4A1FirstPickSilenced
#exec MESHMAP SCALE MESHMAP=M4A1FirstPickSilenced X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=M4A1First3rd MESH=M4A1First3rd
#exec MESHMAP SCALE MESHMAP=M4A1First3rd X=0.12 Y=0.12 Z=0.22

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=M4A1MeshSkin00 FILE=Textures\Rifles\M4A1\M4A1Body.bmp GROUP=M4A1 LODSET=2
#exec TEXTURE IMPORT NAME=M4A1MeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M4A1MeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M4A1MeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=M4A1BodyPick FILE=Textures\Rifles\M4A1\M4A1BodyPick.bmp GROUP=M4A1 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=0 TEXTURE=M4A1MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=1 TEXTURE=M4A1MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=2 TEXTURE=M4A1MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=3 TEXTURE=M4A1MeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=M4A1FirstPickUnSilenced NUM=1 TEXTURE=M4A1BodyPick
#exec MESHMAP SETTEXTURE MESHMAP=M4A1FirstPickSilenced NUM=1 TEXTURE=M4A1BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=M4A1First3rd NUM=1 TEXTURE=M4A1BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="M4A1FireSilenced" FILE=Sounds\Rifles\M4A1\M4A1_fire_sil.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1FireUnSilenced" FILE=Sounds\Rifles\M4A1\M4A1_fire_unsil.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1ClipOut" FILE=Sounds\Rifles\M4A1\M4A1_clipout.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1ClipIn" FILE=Sounds\Rifles\M4A1\M4A1_clipin.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1Deploy" FILE=Sounds\Rifles\M4A1\M4A1_deploy.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1BoltPull" FILE=Sounds\Rifles\M4A1\M4A1_boltpull.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1SilencerOn" FILE=Sounds\Rifles\M4A1\M4A1_silencer_on.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1SilencerOff" FILE=Sounds\Rifles\M4A1\M4A1_silencer_off.wav GROUP="M4A1"

//=========================================================================================

//Taken from Nali Weapons 3 - WRE weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=M4A1RifleMuzzle ANIVFILE=MODELS\MuzzleFMesh\RifleMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\RifleMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=M4A1RifleMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=M4A1RifleMuzzle X=62 Y=0 Z=-9 Yaw=128

#exec MESH SEQUENCE MESH=M4A1RifleMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M4A1RifleMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=M4A1RifleMuzzle MESH=M4A1RifleMuzzle
#exec MESHMAP SCALE MESHMAP=M4A1RifleMuzzle X=0.375 Y=0.375 Z=0.750

#exec TEXTURE IMPORT NAME=RifleMuzzle01 FILE=Textures\RifleMuzzle01.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=M4A1RifleMuzzle NUM=1 TEXTURE=RifleMuzzle01

#exec TEXTURE IMPORT NAME=RifleMuzzle02 FILE=Textures\RifleMuzzle02.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=M4A1RifleMuzzle NUM=2 TEXTURE=RifleMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=M4A1Icon FILE=Textures\Icons\M4A1Icon.bmp GROUP=M4A1 MIPS=OFF

//=========================================================================================

var Sound AddSilencerSound;
var Sound RemoveSilencerSound;
var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	if(FireMode == 0)
	{
		bDrawMuzzleFlash = True;
		MFTexture = RandFlash[Rand(6)];
	}
	else if(FireMode == 1)
		bDrawMuzzleFlash = False;
	Super.RenderOverlays(Canvas);
}

function DropFrom(vector StartLocation)
{
	if(FireMode == 0)
		PickupViewMesh = LODMesh'M4A1FirstPickUnSilenced';
	else if(FireMode == 1)
		PickupViewMesh = LODMesh'M4A1FirstPickSilenced';
	Super.DropFrom(StartLocation);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	if(FireMode == 0)
		PlayAnim('SelectUnSilenced', 1.1, 0.04);
	else if(FireMode == 1)
		PlayAnim('SelectSilenced', 1.1, 0.04);
	Play1stSelectionSound();
	Sleep(0.4);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'DoSilencer')
		PlaySilencer();
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Play1stSelectionSound();
		Sleep(0.3);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function Play1stSelectionSound()
{
	if(Owner != None)
		Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelectionSound()
{
	if(Owner != None)
		Owner.PlaySound(ReloadSounds[3], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	if(FireMode == 0)
		PlayAnim('SelectUnSilenced', 1.1, 0.04);
	else if(FireMode == 1)
		PlayAnim('SelectSilenced', 1.1, 0.04);
	GoToState('Selector');	
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	if(FireMode == 0)
		PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	else if(FireMode == 1)
		PlayOwnedSound(AltFireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	if(FireMode == 0)
		PlayAnim('FireUnSilenced', 12.0, 0.04);
	else if(FireMode == 1)
		PlayAnim('FireSilenced', 3.5, 0.04);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if (PlayerPawn(Owner) != None)
	{
		if(FireMode == 0)
			bMuzzleFlash++;
		else if(FireMode == 1)
			bMuzzleFlash = 0;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	ignores AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

Begin:
	FlashCount++;
	FinishAnim();
	Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

simulated function PlayAfterFire()
{
	if(FireMode == 0)
		PlayAnim('AfterFireUnSilenced', 0.5, 0.04);
	else if(FireMode == 1)
		PlayAnim('AfterFireSilenced', 0.5, 0.04);
}

simulated function PlayAltFiring()
{
	if(FireMode == 0)
		PlayAnim('RemoveSilencer', 0.9, 0.04);
	else if(FireMode == 1)
		PlayAnim('AddSilencer', 0.9, 0.04);
}

simulated function PlaySilencer()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		if(FireMode == 0)
		{
			PlayAnim('AddSilencer', 0.9, 0.04);
		}
		else if(FireMode == 1)
		{
			PlayAnim('RemoveSilencer', 0.9, 0.04);
		}
	}
}

function AltFire(float Value)
{
	if(!Owner.IsA('Bot'))
	{
		if(FireMode == 0)
			FireMode = 1;
		else if(FireMode == 1)
			FireMode = 0;

		if(Level.NetMode == NM_DedicatedServer)
		{
			if (PlayerPawn(Owner) != None) 
				PlayerPawn(Owner).ClientWeaponEvent('DoSilencer');
		}
	}

	GotoState('AltFiring');

	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;

Begin:
	if(FireMode == 0)
	{
		Sleep(0.5);
		Owner.PlaySound(AddSilencerSound,SLOT_None,Pawn(Owner).SoundDampening);
	}
	else if(FireMode == 1)
	{
		Sleep(1.05);
		Owner.PlaySound(RemoveSilencerSound,SLOT_None,Pawn(Owner).SoundDampening);
	}
	FinishAnim();
	Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
    if ( (Owner == None) )
        return;

    if(FireMode == 0)
		PlayAnim('ReloadUnSilenced', 1.0, 0.05);
	else if(FireMode == 1)
		PlayAnim('ReloadSilenced', 1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
	Begin:
		if(isAnimating())
			FinishAnim();
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
	Checks:
		if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
			Reload();
		Sleep(0.0);
		GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	if(FireMode == 0)
		TweenAnim('StillUnSilenced',1.0);
	else if(FireMode == 1)
		TweenAnim('StillSilenced',1.0);

	GoToState('Idle','Checks');
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz6'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=236.00
	WallPenetrationValue=220.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=1.300000
	AddSilencerSound=Sound'CSSWeapons.M4A1.M4A1SilencerOff'
    RemoveSilencerSound=Sound'CSSWeapons.M4A1.M4A1SilencerOn'
	ReloadSounds(0)=Sound'CSSWeapons.M4A1.M4A1ClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.M4A1.M4A1ClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.M4A1.M4A1Deploy'
    ReloadSounds(3)=Sound'CSSWeapons.M4A1.M4A1BoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.M4A1.M4A1FireUnSilenced'
    AltFireSound=Sound'CSSWeapons.M4A1.M4A1FireSilenced'
    EjectOffset=(X=25.000000,Y=17.000000,Z=-10.000000)
    HitDamage=38
    ClipCount=30
    PickupAmmoCount=120
    Recoil=(Vertical=0.220000,Horizontal=1.020000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-7.200000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.780000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.700000
    FlashY=0.100000
    FlashO=0.012500
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
    AutoSwitchPriority=5
    InventoryGroup=5
    PickupMessage="You got a M4A1."
    ItemName="M4A1"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.M4A1Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.M4A1FirstPickUnSilenced'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'CSSWeapons.M4A1First3rd'
    ThirdPersonScale=1.85
    bMuzzleFlashParticles=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.M4A1RifleMuzzle'
    MuzzleFlashScale=0.750000
    Mesh=LodMesh'CSSWeapons.M4A1FirstPickUnSilenced'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CSSWeapons.M4A1.M4A1Icon'
    StatusIcon=Texture'CSSWeapons.M4A1.M4A1Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}