class Rifle_Galil extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=GalilMesh MODELFILE=ModelsSkeletal\Rifles\Galil\GalilMesh.psk
#exec MESH ORIGIN MESH=GalilMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=GalilFirstPick ANIVFILE=Models\Rifles\Galil\GalilFirstPick_a.3d DATAFILE=Models\Rifles\Galil\GalilFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GalilFirstPick X=0 Y=0 Z=21.3

//3rd Person
#exec MESH IMPORT MESH=GalilFirst3rd ANIVFILE=Models\Rifles\Galil\GalilFirst3rd_a.3d DATAFILE=Models\Rifles\Galil\GalilFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GalilFirst3rd X=23 Y=0 Z=-12 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=GalilMeshAnims ANIMFILE=ModelsSkeletal\Rifles\Galil\GalilMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GalilMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=188
#exec ANIM SEQUENCE ANIM=GalilMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=27
#exec ANIM SEQUENCE ANIM=GalilMeshAnims SEQ=Still STARTFRAME=28 NUMFRAMES=3
#exec ANIM SEQUENCE ANIM=GalilMeshAnims SEQ=Reload STARTFRAME=31 NUMFRAMES=125
#exec ANIM SEQUENCE ANIM=GalilMeshAnims SEQ=Fire STARTFRAME=157 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=GalilMeshAnims SEQ=AfterFire STARTFRAME=165 NUMFRAMES=23

#exec ANIM DIGEST ANIM=GalilMeshAnims
#exec MESH DEFAULTANIM MESH=GalilMesh ANIM=GalilMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=GalilFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=GalilFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=2

//3rd Person
#exec MESH SEQUENCE MESH=GalilFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=GalilFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=GalilMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=GalilFirstPick MESH=GalilFirstPick
#exec MESHMAP SCALE MESHMAP=GalilFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=GalilFirst3rd MESH=GalilFirst3rd
#exec MESHMAP SCALE MESHMAP=GalilFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=GalilMeshSkin00  FILE=Textures\Rifles\Galil\GalilBody2.bmp  GROUP=Galil LODSET=2
#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=GalPick  FILE=Textures\Rifles\Galil\GalilPick.bmp  GROUP=Galil LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=GalilMesh NUM=0 TEXTURE=GalilMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=GalilMesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=GalilFirstPick NUM=1 TEXTURE=GalPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=GalilFirst3rd NUM=1 TEXTURE=GalPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="IDFFire" FILE=Sounds\Rifles\Galil\galil_fire.wav GROUP="Galil"
#exec AUDIO IMPORT NAME="IDFBolt" FILE=Sounds\Rifles\Galil\galil_boltpull.wav GROUP="Galil"
#exec AUDIO IMPORT NAME="IDFClipIn" FILE=Sounds\Rifles\Galil\galil_clipin.wav GROUP="Galil"
#exec AUDIO IMPORT NAME="IDFClipOut" FILE=Sounds\Rifles\Galil\galil_clipout.wav GROUP="Galil"

//=========================================================================================

//Taken from Nali Weapons 3 - WRE weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=GalilRifleMuzzle ANIVFILE=MODELS\MuzzleFMesh\RifleMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\RifleMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GalilRifleMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=GalilRifleMuzzle X=72 Y=0 Z=-9 Yaw=128

#exec MESH SEQUENCE MESH=GalilRifleMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GalilRifleMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=GalilRifleMuzzle MESH=GalilRifleMuzzle
#exec MESHMAP SCALE MESHMAP=GalilRifleMuzzle X=0.375 Y=0.375 Z=0.750

#exec TEXTURE IMPORT NAME=RifleMuzzle01 FILE=Textures\RifleMuzzle01.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=GalilRifleMuzzle NUM=1 TEXTURE=RifleMuzzle01

#exec TEXTURE IMPORT NAME=RifleMuzzle02 FILE=Textures\RifleMuzzle02.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=GalilRifleMuzzle NUM=2 TEXTURE=RifleMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=GalilIcon FILE=Textures\Icons\GalilIcon.bmp GROUP=Galil MIPS=OFF

//=========================================================================================

var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 13, 0.04);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	ignores AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

Begin:
	FlashCount++;
	FinishAnim();
	Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 1.5, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount > 0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.14); 								
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.14); 								
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz6'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=236.00
	WallPenetrationValue=220.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=1.300000
	ReloadSounds(0)=Sound'CSSWeapons.Galil.IDFClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.Galil.IDFClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.Galil.IDFBolt'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.Galil.IDFFire'
    EjectOffset=(X=25.000000,Y=17.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=35
    PickupAmmoCount=175
    Recoil=(Vertical=0.220000,Horizontal=1.220000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-7.200000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.760000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=500.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.700000
    FlashY=0.090000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
    AutoSwitchPriority=5
    InventoryGroup=5
    PickupMessage="You got a IDF Defender."
    ItemName="IDF Defender"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'GalilMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'GalilFirstPick'
    PickupViewScale=2.20
    ThirdPersonMesh=LodMesh'GalilFirst3rd'
    ThirdPersonScale=1.85
    bMuzzleFlashParticles=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.GalilRifleMuzzle'
    MuzzleFlashScale=0.750000
    Mesh=LodMesh'CSSWeapons.GalilFirstPick'
    bNoSmooth=False
    DrawScale=2.200000
    Icon=Texture'CSSWeapons.Galil.GalilIcon'
    StatusIcon=Texture'CSSWeapons.Galil.GalilIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}