class Rifle_Famas extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=FamasMesh MODELFILE=ModelsSkeletal\Rifles\Famas\FamasMesh.psk
#exec MESH ORIGIN MESH=FamasMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=FamasFirstPick ANIVFILE=MODELS\Rifles\Famas\FamasFirstPick_a.3d DATAFILE=MODELS\Rifles\Famas\FamasFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FamasFirstPick X=0 Y=0 Z=21.5

//3rd Person
#exec MESH IMPORT MESH=FamasFirst3rd ANIVFILE=MODELS\Rifles\Famas\FamasFirst3rd_a.3d DATAFILE=MODELS\Rifles\Famas\FamasFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FamasFirst3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=FamasMeshAnims ANIMFILE=ModelsSkeletal\Rifles\Famas\FamasMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=239
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=2
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=Reload STARTFRAME=36 NUMFRAMES=91
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=Fire STARTFRAME=128 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=AfterFire STARTFRAME=136 NUMFRAMES=23

#exec ANIM DIGEST ANIM=FamasMeshAnims
#exec MESH DEFAULTANIM MESH=FamasMesh ANIM=FamasMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=FamasFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FamasFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=FamasFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FamasFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=FamasMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=FamasFirstPick MESH=FamasFirstPick
#exec MESHMAP SCALE MESHMAP=FamasFirstPick X=0.06 Y=0.06 Z=0.16

//3rd Person
#exec MESHMAP NEW MESHMAP=FamasFirst3rd MESH=FamasFirst3rd
#exec MESHMAP SCALE MESHMAP=FamasFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=FamasMeshSkin00 FILE=Textures\Rifles\Famas\FamasBody.bmp GROUP=Famas LODSET=2
#exec TEXTURE IMPORT NAME=FamasMeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=FamasMeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=FamasMeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=FamasBodyPick FILE=Textures\Rifles\Famas\FamasBodyPick.bmp GROUP=Famas LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=FamasMesh NUM=0 TEXTURE=FamasMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=FamasMesh NUM=1 TEXTURE=FamasMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=FamasMesh NUM=2 TEXTURE=FamasMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=FamasMesh NUM=3 TEXTURE=FamasMeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=FamasFirstPick NUM=1 TEXTURE=FamasBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=FamasFirst3rd NUM=1 TEXTURE=FamasBodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="FamasFire" FILE=Sounds\Rifles\Famas\Famas_fire.wav GROUP="Famas"
#exec AUDIO IMPORT NAME="FamasClipOut" FILE=Sounds\Rifles\Famas\Famas_clipout.wav GROUP="Famas"
#exec AUDIO IMPORT NAME="FamasClipIn" FILE=Sounds\Rifles\Famas\Famas_clipin.wav GROUP="Famas"
#exec AUDIO IMPORT NAME="FamasForeArm" FILE=Sounds\Rifles\Famas\Famas_forearm.wav GROUP="Famas"

//=========================================================================================

//Taken from Nali Weapons 3 - WRE weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=FamasRifleMuzzle ANIVFILE=MODELS\MuzzleFMesh\RifleMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\RifleMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=FamasRifleMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=FamasRifleMuzzle X=9 Y=0 Z=-9 Yaw=128

#exec MESH SEQUENCE MESH=FamasRifleMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FamasRifleMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=FamasRifleMuzzle MESH=FamasRifleMuzzle
#exec MESHMAP SCALE MESHMAP=FamasRifleMuzzle X=0.375 Y=0.375 Z=0.750

#exec TEXTURE IMPORT NAME=RifleMuzzle01 FILE=Textures\RifleMuzzle01.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=FamasRifleMuzzle NUM=1 TEXTURE=RifleMuzzle01

#exec TEXTURE IMPORT NAME=RifleMuzzle02 FILE=Textures\RifleMuzzle02.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=FamasRifleMuzzle NUM=2 TEXTURE=RifleMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=FamasIcon FILE=Textures\Icons\FamasIcon.bmp GROUP=Famas MIPS=OFF

//=========================================================================================

var Texture RandFlash[6];
var int BurstShots, NumFire;

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(6)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.7, 0.04);
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 11.0, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if (PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(FireMode == 0)
			GotoState('NormalFire');
		else if(FireMode == 1)
			GoToState('BurstFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

simulated function PlayAltFiring()
{
	PlayAnim('Still', 0.01);
}

function AltFire(float Value)
{
	if(FireMode == 0 && ClipCount >= 3)
	{
		FireMode = 1;
		if((Pawn(Owner) != None) && (Pawn(Owner).PlayerReplicationInfo != None))
			Pawn(Owner).ReceiveLocalizedMessage(Class'Pistol_GlockModeMessage',1,Pawn(Owner).PlayerReplicationInfo);
	}
	else if(FireMode == 1 && ClipCount >= 1)
	{
		FireMode = 0;
		if((Pawn(Owner) != None) && (Pawn(Owner).PlayerReplicationInfo != None))
			Pawn(Owner).ReceiveLocalizedMessage(Class'Pistol_GlockModeMessage',0,Pawn(Owner).PlayerReplicationInfo);
	}

	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;

	function AnimEnd()
	{
		if ( (Pawn(Owner) != None) && Pawn(Owner).bAltFire != 0)
	      	TweenToStill();
	}

Begin:
	Sleep(0.16);
	if (Pawn(Owner).bAltFire != 0)
		GoTo('Begin');
	Else
		Finish();
}

state BurstFire
{
	ignores Fire, AltFire;

	function AnimEnd()
   	{
   		NumFire--;
	    if (NumFire > 0)
	    {
	       	AmmoType.UseAmmo(1);
	       	TraceFire(0.1);
	       	PlayFire();
	    }
	    else if ( (Pawn(Owner) != None) && (Pawn(Owner).bFire != 0) )
	    {
	    	PlayAfterFire();
	       	TweenToStill();
	    }
	}

	function BeginState()
   	{
   		NumFire = Min(AmmoType.AmmoAmount, burstShots);
      	Super.BeginState();
   	}

   	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		Sleep(0.1);
		FlashCount++;
		Sleep(0.1);
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientBurstFiring
{
	ignores Fire, AltFire;

	simulated function AnimEnd()
   	{
   		NumFire--;
	    if (NumFire > 0)
	    {
	       	AmmoType.UseAmmo(1);
	       	TraceFire(0.1);
	       	PlayFire();
	    }
	    else if ( (Pawn(Owner) != None) && (Pawn(Owner).bFire != 0) )
	    {
	    	PlayAfterFire();
	       	TweenToStill();
	    }
	}

	simulated function BeginState()
   	{
   		NumFire = Min(AmmoType.AmmoAmount, burstShots);
      	Super.BeginState();
   	}

   	simulated function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		Sleep(0.1);
		FlashCount++;
		Sleep(0.1);
		FlashCount++;
		FinishAnim();
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.75, 0.05);
}

simulated state NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	BurstShots=3
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz6'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=236.00
	WallPenetrationValue=220.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=1.300000
	ReloadSounds(0)=Sound'CSSWeapons.Famas.FamasClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.Famas.FamasClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.Famas.FamasForeArm'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.Famas.FamasFire'
    EjectOffset=(X=25.000000,Y=17.000000,Z=-10.000000)
    HitDamage=38
    ClipCount=25
    PickupAmmoCount=125
    Recoil=(Vertical=0.120000,Horizontal=0.220000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-7.200000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.750000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=1.000000
    FlashY=0.115000
    FlashO=0.015000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
    AutoSwitchPriority=5
    InventoryGroup=5
    PickupMessage="You got a Famas."
    ItemName="Famas"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'FamasMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'FamasFirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'FamasFirst3rd'
    ThirdPersonScale=1.85
    bMuzzleFlashParticles=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.FamasRifleMuzzle'
    MuzzleFlashScale=0.850000
    Mesh=LodMesh'CSSWeapons.FamasFirstPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CSSWeapons.Famas.FamasIcon'
    StatusIcon=Texture'CSSWeapons.Famas.FamasIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}