class Rifle_Aug extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=AugMesh MODELFILE=ModelsSkeletal\Rifles\Aug\AugMesh.psk
#exec MESH ORIGIN MESH=AugMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=AugFirstPick ANIVFILE=MODELS\Rifles\Aug\AugFirstPick_a.3d DATAFILE=MODELS\Rifles\Aug\AugFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AugFirstPick X=0 Y=0 Z=19

//3rd Person
#exec MESH IMPORT MESH=AugFirst3rd ANIVFILE=MODELS\Rifles\Aug\AugFirst3rd_a.3d DATAFILE=MODELS\Rifles\Aug\AugFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AugFirst3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=AugMeshAnims ANIMFILE=ModelsSkeletal\Rifles\Aug\AugMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=208
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=133
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=Fire STARTFRAME=177 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=AfterFire STARTFRAME=188 NUMFRAMES=20

#exec ANIM DIGEST ANIM=AugMeshAnims
#exec MESH DEFAULTANIM MESH=AugMesh ANIM=AugMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=AugFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AugFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=AugFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AugFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=AugMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=AugFirstPick MESH=AugFirstPick
#exec MESHMAP SCALE MESHMAP=AugFirstPick X=0.07 Y=0.07 Z=0.17

//3rd Person
#exec MESHMAP NEW MESHMAP=AugFirst3rd MESH=AugFirst3rd
#exec MESHMAP SCALE MESHMAP=AugFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=AugMeshSkin00 FILE=Textures\Rifles\Aug\AugScope.bmp GROUP=Aug LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin01 FILE=Textures\Rifles\Aug\AugBody.bmp GROUP=Aug LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin02 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin03 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin04 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=AugBodyPick FILE=Textures\Rifles\Aug\AugBodyPick.bmp GROUP=Aug LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=0 TEXTURE=AugMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=1 TEXTURE=AugMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=2 TEXTURE=AugMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=3 TEXTURE=AugMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=4 TEXTURE=AugMeshSkin04

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=AugFirstPick NUM=1 TEXTURE=AugBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=AugFirst3rd NUM=1 TEXTURE=AugBodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="AugFire" FILE=Sounds\Rifles\Aug\Aug_fire.wav GROUP="Aug"
#exec AUDIO IMPORT NAME="AugClipOut" FILE=Sounds\Rifles\Aug\Aug_clipout.wav GROUP="Aug"
#exec AUDIO IMPORT NAME="AugClipIn" FILE=Sounds\Rifles\Aug\Aug_clipin.wav GROUP="Aug"
#exec AUDIO IMPORT NAME="AugForeArm" FILE=Sounds\Rifles\Aug\Aug_forearm.wav GROUP="Aug"
#exec AUDIO IMPORT NAME="AugBoltSlap" FILE=Sounds\Rifles\Aug\Aug_boltslap.wav GROUP="Aug"
#exec AUDIO IMPORT NAME="AugBoltPull" FILE=Sounds\Rifles\Aug\Aug_boltpull.wav GROUP="Aug"

//=========================================================================================

//Taken from Nali Weapons 3 - WRE weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=AugRifleMuzzle ANIVFILE=MODELS\MuzzleFMesh\RifleMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\RifleMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=AugRifleMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=AugRifleMuzzle X=37 Y=0 Z=-9 Yaw=128

#exec MESH SEQUENCE MESH=AugRifleMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AugRifleMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=AugRifleMuzzle MESH=AugRifleMuzzle
#exec MESHMAP SCALE MESHMAP=AugRifleMuzzle X=0.375 Y=0.375 Z=0.750

#exec TEXTURE IMPORT NAME=RifleMuzzle01 FILE=Textures\RifleMuzzle01.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=AugRifleMuzzle NUM=1 TEXTURE=RifleMuzzle01

#exec TEXTURE IMPORT NAME=RifleMuzzle02 FILE=Textures\RifleMuzzle02.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=AugRifleMuzzle NUM=2 TEXTURE=RifleMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=AugIcon FILE=Textures\Icons\AugIcon.bmp GROUP=Aug MIPS=OFF

//=========================================================================================

var Texture RandFlash[6];
var float NFlashO, NFlashY;
var float FireRate;
var byte PZoomLevel;

replication
{
	Reliable if(bNetOwner && Role==ROLE_Authority)
		FireRate, PZoomLevel;
}

function DropFrom(vector StartLocation)
{
	Super.DropFrom(StartLocation);
	FlashO = default.FlashO;
	FlashY = default.FlashY;
	PZoomLevel = 0;
	FireRate = Default.FireRate;
}

simulated function TweenDown()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		PZoomLevel = 0;
		FireRate = Default.FireRate;
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
 			bDrawMuzzleFlash = True; 
		}
}

simulated event RenderOverlays(canvas Canvas)
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	MFTexture = RandFlash[Rand(5)];

	if (Owner.IsA('PlayerPawn'))
	{
		if(bHideWeapon || (Owner==None))
			return;
		PlayerOwner = PlayerPawn(Owner);
		if(PlayerOwner!=None)
		{
			bPlayerOwner = true;
			Hand = PlayerOwner.Handedness;
		}

		if((Level.NetMode == NM_Client) && (Hand == 2))
		{
			bHideWeapon = true;
			return;
		}
	
		if(!bPlayerOwner || (PlayerOwner.Player == None))
			Pawn(Owner).WalkBob = vect(0,0,0);
	
		if(bMuzzleFlash>0 && bDrawMuzzleFlash /*&& Level.bHighDetailMode*/ && (MFTexture != None))
		{
			MuzzleScale = Default.MuzzleScale*(Canvas.ClipX/640.0);
			if(!bSetFlashTime)
			{
				bSetFlashTime = true;
				FlashTime = Level.TimeSeconds+FlashLength;
			}
			else if(FlashTime<Level.TimeSeconds)
				bMuzzleFlash = 0;
		
			if(bMuzzleFlash > 0)
			{
				MFTexture = RandFlash[Rand(6)];
				if ( Hand == 0 )
                	Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
          	  	else
                	Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);
				Canvas.Style = 3;
				Canvas.DrawIcon(MFTexture, MuzzleScale);
				Canvas.Style = 1;
			}
		}
	else
		bSetFlashTime = false;

	SetLocation(Owner.Location + CSSCalcDrawOffset());
	NewRot = Pawn(Owner).ViewRotation;
	if(Hand==0)
		newRot.Roll = -2*Default.Rotation.Roll;
	else
		newRot.Roll = Default.Rotation.Roll*Hand;
	setRotation(newRot);
	Canvas.DrawActor(self, false);
	}
	//else
	//Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 0.95, 0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		//Play1stSelectionSound();
		Sleep(0.4);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[4], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.95, 0.04);
	GoToState('Selector');
	FlashO = default.FlashO;
	FlashY = default.FlashY;
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = 50.0;
					FlashO = default.NFlashO;
					FlashY = default.NFlashY;
				}
				else
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
				}
			}
		}
	}
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', FireRate, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if (PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(4.0);
		bPointing=True;
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function AltFire(float Value)
{
	if(PZoomLevel == 0)
	{
		PZoomLevel = 1;			//Zoomed
		FireRate = 7.0;
	}
	else if(PZoomLevel == 1)
	{
		PZoomLevel = 0;			//UnZoomed
		FireRate = Default.FireRate;
	}
	ClientAltFire(Value);
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function Reload()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
    if ((AmmoType.AmmoAmount > 0) && (ClipCount < Default.ClipCount)) 
    {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
					MuzzleScale = default.MuzzleScale;
				}
			}
		}
    }
}

simulated function ClientReload()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
          GoToState('ClientReloading');
          PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
					MuzzleScale = default.MuzzleScale;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		PZoomLevel = 0;
		FireRate = Default.FireRate;
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	PZoomLevel = 0;
		FireRate = Default.FireRate;
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	FireRate=12.00
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz6'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=236.00
	WallPenetrationValue=220.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=1.300000
	ReloadSounds(0)=Sound'CSSWeapons.Aug.AugBoltPull'
	ReloadSounds(1)=Sound'CSSWeapons.Aug.AugClipOut'
    ReloadSounds(2)=Sound'CSSWeapons.Aug.AugClipIn'
    ReloadSounds(3)=Sound'CSSWeapons.Aug.AugBoltSlap'
    ReloadSounds(4)=Sound'CSSWeapons.Aug.AugForeArm'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.Aug.AugFire'
    EjectOffset=(X=25.000000,Y=17.000000,Z=-10.000000)
    HitDamage=38
    ClipCount=30
    PickupAmmoCount=120
    Recoil=(Vertical=0.220000,Horizontal=1.020000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-7.200000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.790000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.700000
    NFlashY=0.210000
    NFlashO=0.024000
    FlashY=0.100000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
    AutoSwitchPriority=6
    InventoryGroup=6
    PickupMessage="You got a Aug."
    ItemName="Aug"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'AugMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'AugFirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'AugFirst3rd'
    ThirdPersonScale=1.85
    bMuzzleFlashParticles=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.AugRifleMuzzle'
    MuzzleFlashScale=0.750000
    Mesh=LodMesh'CSSWeapons.AugFirstPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CSSWeapons.Aug.AugIcon'
    StatusIcon=Texture'CSSWeapons.Aug.AugIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}