class Rifle_AK47 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=AK47Mesh MODELFILE=ModelsSkeletal\Rifles\AK47\AK47Mesh.psk
#exec MESH ORIGIN MESH=AK47Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=AK47FirstPick ANIVFILE=MODELS\Rifles\AK47\AK47FirstPick_a.3d DATAFILE=MODELS\Rifles\AK47\AK47FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK47FirstPick X=0 Y=0 Z=19

//3rd Person
#exec MESH IMPORT MESH=AK47First3rd ANIVFILE=MODELS\Rifles\AK47\AK47First3rd_a.3d DATAFILE=MODELS\Rifles\AK47\AK47First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK47First3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=AK47MeshAnims ANIMFILE=ModelsSkeletal\Rifles\AK47\AK47MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=AK47MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=158
#exec ANIM SEQUENCE ANIM=AK47MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=AK47MeshAnims SEQ=Still STARTFRAME=33 NUMFRAMES=16
#exec ANIM SEQUENCE ANIM=AK47MeshAnims SEQ=Reload STARTFRAME=50 NUMFRAMES=91
#exec ANIM SEQUENCE ANIM=AK47MeshAnims SEQ=Fire STARTFRAME=142 NUMFRAMES=16
#exec ANIM SEQUENCE ANIM=AK47MeshAnims SEQ=AfterFire STARTFRAME=148 NUMFRAMES=10

#exec ANIM DIGEST ANIM=AK47MeshAnims
#exec MESH DEFAULTANIM MESH=AK47Mesh ANIM=AK47MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=AK47FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK47FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=AK47First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK47First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=AK47Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=AK47FirstPick MESH=AK47FirstPick
#exec MESHMAP SCALE MESHMAP=AK47FirstPick X=0.08 Y=0.08 Z=0.18

//3rd Person
#exec MESHMAP NEW MESHMAP=AK47First3rd MESH=AK47First3rd
#exec MESHMAP SCALE MESHMAP=AK47First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=AK47MeshSkin00 FILE=Textures\Rifles\AK47\AK47Body.bmp GROUP=AK47 LODSET=2
#exec TEXTURE IMPORT NAME=AK47MeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=AK47MeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=AK47MeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=AK47BodyPick FILE=Textures\Rifles\AK47\AK47BodyPick.bmp GROUP=AK47 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=AK47Mesh NUM=0 TEXTURE=AK47MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=AK47Mesh NUM=1 TEXTURE=AK47MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=AK47Mesh NUM=2 TEXTURE=AK47MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=AK47Mesh NUM=3 TEXTURE=AK47MeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=AK47FirstPick NUM=1 TEXTURE=AK47BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=AK47First3rd NUM=1 TEXTURE=AK47BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="AK47Fire" FILE=Sounds\Rifles\AK47\AK47_fire.wav GROUP="AK47"
#exec AUDIO IMPORT NAME="AK47ClipOut" FILE=Sounds\Rifles\AK47\AK47_clipout.wav GROUP="AK47"
#exec AUDIO IMPORT NAME="AK47ClipIn" FILE=Sounds\Rifles\AK47\AK47_clipin.wav GROUP="AK47"
#exec AUDIO IMPORT NAME="AK47BoltPull" FILE=Sounds\Rifles\AK47\AK47_boltpull.wav GROUP="AK47"

//=========================================================================================

//Taken from Nali Weapons 3 - WRE weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=AK47RifleMuzzle ANIVFILE=MODELS\MuzzleFMesh\RifleMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\RifleMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=AK47RifleMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=AK47RifleMuzzle X=52 Y=0 Z=-9 Yaw=128

#exec MESH SEQUENCE MESH=AK47RifleMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK47RifleMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=AK47RifleMuzzle MESH=AK47RifleMuzzle
#exec MESHMAP SCALE MESHMAP=AK47RifleMuzzle X=0.375 Y=0.375 Z=0.750

#exec TEXTURE IMPORT NAME=RifleMuzzle01 FILE=Textures\RifleMuzzle01.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=AK47RifleMuzzle NUM=1 TEXTURE=RifleMuzzle01

#exec TEXTURE IMPORT NAME=RifleMuzzle02 FILE=Textures\RifleMuzzle02.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=AK47RifleMuzzle NUM=2 TEXTURE=RifleMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=AK47Icon FILE=Textures\Icons\AK47Icon.bmp GROUP=AK47 MIPS=OFF

//=========================================================================================

var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(6)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 0.7, 0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		//Play1stSelectionSound();
		Sleep(0.4);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.7, 0.04);
	GoToState('Selector');	
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 5.2, 0.04);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.27); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.27); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz6'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=236.00
	WallPenetrationValue=220.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=1.300000
	ReloadSounds(0)=Sound'CSSWeapons.AK47.AK47ClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.AK47.AK47ClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.AK47.AK47BoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.AK47.AK47Fire'
    EjectOffset=(X=25.000000,Y=17.000000,Z=-10.000000)
    HitDamage=38
    ClipCount=30
    PickupAmmoCount=120
    Recoil=(Vertical=0.220000,Horizontal=1.020000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-7.200000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.770000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.700000
    FlashY=0.100000
    FlashO=0.015000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
    AutoSwitchPriority=5
    InventoryGroup=5
    PickupMessage="You got a AK47."
    ItemName="AK47"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'AK47Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.AK47FirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'CSSWeapons.AK47First3rd'
    ThirdPersonScale=1.85
    bMuzzleFlashParticles=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.AK47RifleMuzzle'
    MuzzleFlashScale=0.750000
    Mesh=LodMesh'CSSWeapons.AK47FirstPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CSSWeapons.AK47.AK47Icon'
    StatusIcon=Texture'CSSWeapons.AK47.AK47Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}