class Pistol_USP extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=USPFirstMesh MODELFILE=ModelsSkeletal/Pistols/USP/USPFirst.psk
#exec MESH ORIGIN MESH=USPFirstMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=USPFirstPick ANIVFILE=MODELS\Pistols\USP\USPFirstPick_a.3d DATAFILE=MODELS\Pistols\USP\USPFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=USPFirstPick X=0 Y=0 Z=13

//3rd Person
#exec MESH IMPORT MESH=USPFirst3rd ANIVFILE=MODELS\Pistols\USP\USPFirst3rd_a.3d DATAFILE=MODELS\Pistols\USP\USPFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=USPFirst3rd X=13 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=USPFirstAnims ANIMFILE=ModelsSkeletal/Pistols/USP/USPFirstAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=All STARTFRAME=0 NUMFRAMES=662
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=SelectUnSilenced STARTFRAME=0 NUMFRAMES=50
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=SelectSilenced STARTFRAME=51 NUMFRAMES=49
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=StillUnSilenced STARTFRAME=101 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=StillSilenced STARTFRAME=133 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=AddSilencer STARTFRAME=165 NUMFRAMES=115
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=RemoveSilencer STARTFRAME=281 NUMFRAMES=115
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=ReloadUnSilenced STARTFRAME=397 NUMFRAMES=100
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=ReloadSilenced STARTFRAME=498 NUMFRAMES=100
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=FireUnSilenced STARTFRAME=599 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=USPFirstAnims SEQ=FireSilenced STARTFRAME=631 NUMFRAMES=31

#exec ANIM DIGEST ANIM=USPFirstAnims
#exec MESH DEFAULTANIM MESH=USPFirstMesh ANIM=USPFirstAnims

//Pickup
#exec MESH SEQUENCE MESH=USPFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=USPFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=USPFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=USPFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=USPFirstMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=USPFirstPick MESH=USPFirstPick
#exec MESHMAP SCALE MESHMAP=USPFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=USPFirst3rd MESH=USPFirst3rd
#exec MESHMAP SCALE MESHMAP=USPFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=USPFirstMeshSkin00 FILE=Textures\Pistols\USP\USPBody.bmp GROUP=USP LODSET=2
#exec TEXTURE IMPORT NAME=USPBodyPick FILE=Textures\Pistols\USP\USPPick.bmp GROUP=USP LODSET=2

#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=USPFirstMesh NUM=0 TEXTURE=USPFirstMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=USPFirstMesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=USPFirstPick NUM=1 TEXTURE=USPBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=USPFirst3rd NUM=1 TEXTURE=USPBodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="USPFire" FILE=Sounds\Pistols\USP\usp_unsil_fire.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPFire_Sil" FILE=Sounds\Pistols\USP\usp_sil_fire.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPAddSil" FILE=Sounds\Pistols\USP\usp_silencer_on.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPRemoveSil" FILE=Sounds\Pistols\USP\usp_silencer_off.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPSlideBack" FILE=Sounds\Pistols\USP\usp_slideback.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPSlideBack2" FILE=Sounds\Pistols\USP\usp_slideback2.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPSlideRelease" FILE=Sounds\Pistols\USP\usp_sliderelease.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPClipOut" FILE=Sounds\Pistols\USP\usp_clipout.wav GROUP="USP"
#exec AUDIO IMPORT NAME="USPClipIn" FILE=Sounds\Pistols\USP\usp_clipin.wav GROUP="USP"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=USPMuzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=USPMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=USPMuzzle X=-560 Y=0 Z=-15

#exec MESH SEQUENCE MESH=USPMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=USPMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=USPMuzzle MESH=USPMuzzle
#exec MESHMAP SCALE MESHMAP=USPMuzzle X=0.055 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=USPMuzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle02.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=USPMuzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=USPIcon FILE=Textures\Icons\USPIcon.bmp GROUP=USP MIPS=OFF

//=========================================================================================

var Sound AddSilencerSound;
var Sound RemoveSilencerSound;

simulated event RenderOverlays(canvas Canvas)
{
	if(FireMode == 0)
		bDrawMuzzleFlash = True;
	else if(FireMode == 1)
		bDrawMuzzleFlash = False;
	Super.RenderOverlays(Canvas);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	if(FireMode == 0)
		PlayAnim('SelectUnSilenced', 1.4, 0.04);
	else if(FireMode == 1)
		PlayAnim('SelectSilenced', 1.4, 0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'DoSilencer')
		PlaySilencer();
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	if(FireMode == 0)
		PlayAnim('SelectUnSilenced', 1.4, 0.04);
	else if(FireMode == 1)
		PlayAnim('SelectSilenced', 1.4, 0.04);
	GoToState('Selector');	
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));

	if(FireMode == 0)
		PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	else if(FireMode == 1)
		PlayOwnedSound(AltFireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	if(!Owner.IsA('Bot'))
	{
		if(FireMode == 0)
			PlayAnim('FireUnSilenced', 1.3, 0.04);
		else if(FireMode == 1)
			PlayAnim('FireSilenced', 1.3, 0.04);
	}
	else if(Owner.IsA('Bot'))
		PlayAnim('FireUnSilenced',4.5, 0.04);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if (PlayerPawn(Owner) != None)
	{
		if(FireMode == 0)
			bMuzzleFlash++;
		else if(FireMode == 1)
			bMuzzleFlash = 0;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		bCanClientFire = true;
        ClientFire(Value);
        if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');

		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			MuzzleFlashMesh = None;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		MuzzleFlashMesh = Default.MuzzleFlashMesh;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if(Pawn(Owner) != None)
	{
		if (Pawn(Owner).bFire != 0)
		{
			MuzzleFlashMesh = None;
			GoTo('Begin');
		}
		else
			Finish();
	}
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

simulated function PlayAltFiring()
{
	if(FireMode == 0)
	{
		PlayAnim('RemoveSilencer', 1.3, 0.04);
	}
	else if(FireMode == 1)
	{
		PlayAnim('AddSilencer', 1.3, 0.04);
	}
}

simulated function PlaySilencer()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		if(FireMode == 0)
		{
			PlayAnim('AddSilencer', 1.3, 0.04);
		}
		else if(FireMode == 1)
		{
			PlayAnim('RemoveSilencer', 1.3, 0.04);
		}
	}
}

function AltFire(float Value)
{
	if(FireMode == 0)
		FireMode = 1;
	else if(FireMode == 1)
		FireMode = 0;

	if(Level.NetMode == NM_DedicatedServer)
	{
		if (PlayerPawn(Owner) != None) 
			PlayerPawn(Owner).ClientWeaponEvent('DoSilencer');
	}

	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;

Begin:
	if(FireMode == 0)
	{
		Sleep(0.5);
		Owner.PlaySound(AddSilencerSound,SLOT_None,Pawn(Owner).SoundDampening);
	}
	else if(FireMode == 1)
	{
		Sleep(0.95);
		Owner.PlaySound(RemoveSilencerSound,SLOT_None,Pawn(Owner).SoundDampening);
	}
	FinishAnim();
	Finish();
}

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
        GoToState('NewClip');
        PlayReloading();
        ClientReload();
    }
}

simulated function ClientReload()
{
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
        GoToState('ClientReloading');
        PlayReloading();
    }
}

simulated function PlayReloading()
{
    //Play reloading animation and sound
    if ( (Owner == None) )
        return;
    if(FireMode == 0)
		PlayAnim('ReloadUnSilenced', 1.0, 0.05);
	else if(FireMode == 1)
		PlayAnim('ReloadSilenced', 1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
    	Sleep(0.35);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.6); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
    	Sleep(0.35);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.6); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated function TweenToStill()
{
	if(FireMode == 0)
		TweenAnim('StillUnSilenced',1.0);
	else if(FireMode == 1)
		TweenAnim('StillSilenced',1.0);
}

simulated state Idle
{
Begin:
	if(isAnimating())
    	FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	if(FireMode == 0)
		TweenAnim('StillUnSilenced',1.0);
	else if(FireMode == 1)
		TweenAnim('StillSilenced',1.0);
	GoToState('Idle','Checks');
}

defaultproperties
{
	HeadShotMultiplier=1.50
	PawnPenetrationValue=86.00
	WallPenetrationValue=80.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.800000
	ReloadSounds(0)=Sound'CSSWeapons.USP.USPClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.USP.USPClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.USP.USPSlideBack'
    ReloadSounds(3)=Sound'CSSWeapons.USP.USPSlideRelease'
    ReloadSounds(4)=Sound'CSSWeapons.USP.USPSlideBack2'
    AddSilencerSound=Sound'CSSWeapons.USP.USPRemoveSil'
    RemoveSilencerSound=Sound'CSSWeapons.USP.USPAddSil'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.USP.USPFire'
    AltFireSound=Sound'CSSWeapons.USP.USPFire_Sil'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=17
    ClipCount=12
    PickupAmmoCount=60
    Recoil=(Vertical=0.370000,Horizontal=0.220000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.250000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.012000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a USP."
    ItemName="USP"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.USPFirstMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.USPFirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'CSSWeapons.USPFirst3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=False
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.USPMuzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.USPFirstPick'
    bNoSmooth=False
    Icon=Texture'CSSWeapons.USP.USPIcon'
    StatusIcon=Texture'CSSWeapons.USP.USPIcon'
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=15.00
}