class Pistol_P228 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=P228Mesh MODELFILE=ModelsSkeletal\Pistols\P228\P228Mesh.psk
#exec MESH ORIGIN MESH=P228Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=P228FirstPick ANIVFILE=MODELS\Pistols\P228\P228FirstPick_a.3d DATAFILE=MODELS\Pistols\P228\P228FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P228FirstPick X=0 Y=0 Z=13

//3rd Person
#exec MESH IMPORT MESH=P228First3rd ANIVFILE=MODELS\Pistols\P228\P228First3rd_a.3d DATAFILE=MODELS\Pistols\P228\P228First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P228First3rd X=17 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=P228Anims ANIMFILE=ModelsSkeletal\Pistols\P228\P228MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=P228Anims SEQ=All STARTFRAME=0 NUMFRAMES=187
#exec ANIM SEQUENCE ANIM=P228Anims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=P228Anims SEQ=Still STARTFRAME=33 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=P228Anims SEQ=Reload STARTFRAME=65 NUMFRAMES=96
#exec ANIM SEQUENCE ANIM=P228Anims SEQ=Fire STARTFRAME=162 NUMFRAMES=25

#exec ANIM DIGEST ANIM=P228Anims
#exec MESH DEFAULTANIM MESH=P228Mesh ANIM=P228Anims

//Pickup
#exec MESH SEQUENCE MESH=P228FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P228FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=P228First3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=P228First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=P228Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=P228FirstPick MESH=P228FirstPick
#exec MESHMAP SCALE MESHMAP=P228FirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=P228First3rd MESH=P228First3rd
#exec MESHMAP SCALE MESHMAP=P228First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=P228MeshSkin00 FILE=Textures\Pistols\P228\P228Body.bmp GROUP=P228 LODSET=2
#exec TEXTURE IMPORT NAME=P228BodyPick FILE=Textures\Pistols\P228\P228BodyPick.bmp GROUP=P228 LODSET=2
#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=P228Mesh NUM=0 TEXTURE=P228MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=P228Mesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=P228FirstPick NUM=1 TEXTURE=P228BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=P228First3rd NUM=1 TEXTURE=P228BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="P228Fire" FILE=Sounds\Pistols\P228\p228_fire.wav GROUP="P228"
#exec AUDIO IMPORT NAME="P228ClipOut" FILE=Sounds\Pistols\P228\p228_clipout.wav GROUP="P228"
#exec AUDIO IMPORT NAME="P228ClipIn" FILE=Sounds\Pistols\P228\p228_clipin.wav GROUP="P228"
#exec AUDIO IMPORT NAME="P228SlideBack" FILE=Sounds\Pistols\P228\p228_slideback.wav GROUP="P228"
#exec AUDIO IMPORT NAME="P228SlideRelease" FILE=Sounds\Pistols\P228\p228_sliderelease.wav GROUP="P228"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=P228Muzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=P228Muzzle STRENGTH=0
#exec MESH ORIGIN MESH=P228Muzzle X=-230 Y=0 Z=-24

#exec MESH SEQUENCE MESH=P228Muzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P228Muzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=P228Muzzle MESH=P228Muzzle
#exec MESHMAP SCALE MESHMAP=P228Muzzle X=0.055 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=P228Muzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle02.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=P228Muzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=P228Icon FILE=Textures\Icons\P228Icon.bmp GROUP=P228 MIPS=OFF

//=========================================================================================

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.0, 0.04);
	Sleep(0.4);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.4);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[3], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	GoToState('Selector');	
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if(!Owner.IsA('Bot'))
		PlayAnim('Fire', 1.3, 0.04);
	else if(Owner.IsA('Bot'))
		PlayAnim('Fire', 4.3, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			MuzzleFlashScale = 0.0;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		MuzzleFlashScale = Default.MuzzleFlashScale;
		Super.EndState();
	}

Begin:
	FlashCount++;
Begin2:
	Sleep(0.16);
	if(Pawn(Owner) != None)
	{
		if (Pawn(Owner).bFire != 0)
		{
			MuzzleFlashScale = 0.0;
			GoTo('Begin2');
		}
		else
			Finish();
	}
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 								
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 								
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	HeadShotMultiplier=1.50
	PawnPenetrationValue=86.00
	WallPenetrationValue=80.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.800000
	ReloadSounds(0)=Sound'CSSWeapons.P228.P228SlideBack'
	ReloadSounds(1)=Sound'CSSWeapons.P228.P228ClipOut'
    ReloadSounds(2)=Sound'CSSWeapons.P228.P228ClipIn'
    ReloadSounds(3)=Sound'CSSWeapons.P228.P228SlideRelease'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.P228.P228Fire'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=18
    ClipCount=13
    PickupAmmoCount=65
    Recoil=(Vertical=0.370000,Horizontal=0.220000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.260000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.115000
    FlashO=0.014000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a P228."
    ItemName="P228"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.P228Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.P228FirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'CSSWeapons.P228First3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=False
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.P228Muzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.P228FirstPick'
    bNoSmooth=False
    Icon=Texture'CSSWeapons.P228.P228Icon'
    StatusIcon=Texture'CSSWeapons.P228.P228Icon'
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}