class Pistol_Glock extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=GlockMesh MODELFILE=ModelsSkeletal\Pistols\Glock\GlockMesh.psk
#exec MESH ORIGIN MESH=GlockMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=GlockFirstPick ANIVFILE=MODELS\Pistols\Glock\GlockFirstPick_a.3d DATAFILE=MODELS\Pistols\Glock\GlockFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GlockFirstPick X=0 Y=0 Z=14.1

//3rd Person
#exec MESH IMPORT MESH=GlockFirst3rd ANIVFILE=MODELS\Pistols\Glock\GlockFirst3rd_a.3d DATAFILE=MODELS\Pistols\Glock\GlockFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GlockFirst3rd X=14 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=GlockMeshAnims ANIMFILE=ModelsSkeletal\Pistols\Glock\GlockMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=192
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=50
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=Still STARTFRAME=51 NUMFRAMES=10
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=Reload STARTFRAME=62 NUMFRAMES=76
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=BurstFire STARTFRAME=139 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=Fire STARTFRAME=171 NUMFRAMES=21

#exec ANIM DIGEST ANIM=GlockMeshAnims
#exec MESH DEFAULTANIM MESH=GlockMesh ANIM=GlockMeshAnims

#exec ANIM NOTIFY ANIM=GlockMeshAnims SEQ=BurstFire Time=0.1 FUNCTION=BurstEffects
#exec ANIM NOTIFY ANIM=GlockMeshAnims SEQ=BurstFire Time=0.2 FUNCTION=BurstEffects

//Pickup
#exec MESH SEQUENCE MESH=GlockFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GlockFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=GlockFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=GlockFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=GlockMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=GlockFirstPick MESH=GlockFirstPick
#exec MESHMAP SCALE MESHMAP=GlockFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=GlockFirst3rd MESH=GlockFirst3rd
#exec MESHMAP SCALE MESHMAP=GlockFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=GlockMeshSkin00 FILE=Textures\Pistols\Glock\GlockBody.bmp GROUP=Glock LODSET=2
#exec TEXTURE IMPORT NAME=GlockBodyPick FILE=Textures\Pistols\Glock\GlockBodyPick.bmp GROUP=Glock LODSET=2
#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=0 TEXTURE=GlockMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=GlockFirstPick NUM=1 TEXTURE=GlockBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=GlockFirst3rd NUM=1 TEXTURE=GlockBodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="GlockFire" FILE=Sounds\Pistols\Glock\glock_fire.wav GROUP="Glock"
#exec AUDIO IMPORT NAME="GlockClipOut" FILE=Sounds\Pistols\Glock\glock_clipout.wav GROUP="Glock"
#exec AUDIO IMPORT NAME="GlockCLipIn" FILE=Sounds\Pistols\Glock\glock_clipin.wav GROUP="Glock"
#exec AUDIO IMPORT NAME="GlockSlideBack" FILE=Sounds\Pistols\Glock\glock_slideback.wav GROUP="Glock"
#exec AUDIO IMPORT NAME="GlockSlideRelease" FILE=Sounds\Pistols\Glock\glock_sliderelease.wav GROUP="Glock"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=GlockMuzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GlockMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=GlockMuzzle X=-240 Y=0 Z=-15

#exec MESH SEQUENCE MESH=GlockMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GlockMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=GlockMuzzle MESH=GlockMuzzle
#exec MESHMAP SCALE MESHMAP=GlockMuzzle X=0.055 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=GlockMuzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle02.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=GlockMuzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=GlockIcon FILE=Textures\Icons\GlockIcon.bmp GROUP=Glock MIPS=OFF

//=========================================================================================

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[3], SLOT_Misc, Pawn(Owner).SoundDampening * 1.0);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	GoToState('Selector');	
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));

	if(!Owner.IsA('Bot'))
	{
		if(FireMode == 0)
		{
			ClipCount--;
			if(ClipCount <= 0)
				ClipCount = 0;
			PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
			PlayAnim('Fire', 1.3, 0.04);
		}
		else if(FireMode == 1)
		{
			ClipCount--;
			if(ClipCount <= 0)
				ClipCount = 0;
			PlayOwnedSound(AltFireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
			PlayAnim('BurstFire', 1.3, 0.04);
		}
	}
	else if(Owner.IsA('Bot') || (Owner.IsA('SkaarjTrooper')))
	{
		PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
		PlayAnim('Fire', 4.3, 0.04);
	}

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0)
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
		{
			if(FireMode == 0 && AmmoType.UseAmmo(1))
				GotoState('NormalFire');
			else if(FireMode == 1 && AmmoType.UseAmmo(1))
				GoToState('BurstFire');
		}
		else if(Owner.IsA('Bot') && AmmoType.UseAmmo(1))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			MuzzleFlashScale = 0.0;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		MuzzleFlashScale = Default.MuzzleFlashScale;
		Super.EndState();
	}

Begin:
	FlashCount++;
Begin2:
	Sleep(0.16);
	if(Pawn(Owner) != None)
	{
		if (Pawn(Owner).bFire != 0)
		{
			MuzzleFlashScale = 0.0;
			GoTo('Begin2');
		}
		else
			Finish();
	}
}

state BurstFire
{
	Ignores fire, altfire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.1);
	FlashCount++;
	Sleep(0.1);
	FlashCount++;
	FinishAnim();
	Finish();
}

simulated function BurstEffects()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	SpawnShellCase(vect(10,-500,1));
	ClipCount--;

	if(ClipCount <= 0)
		ClipCount = 0;

	TraceFire(5.0);

	if(AmmoType != None)
		AmmoType.UseAmmo(1);

	if(PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

simulated function JustAltFire()
{
	PlayAnim('Still', 1.0, 0.04);
}

function AltFire(float Value)
{
	if(FireMode == 0 && ClipCount >= 3)
	{
		FireMode = 1;
		if((Pawn(Owner) != None) && (Pawn(Owner).PlayerReplicationInfo != None))
			Pawn(Owner).ReceiveLocalizedMessage(Class'Pistol_GlockModeMessage',1,Pawn(Owner).PlayerReplicationInfo);
	}
	else if(FireMode == 1 && ClipCount >= 1)
	{
		FireMode = 0;
		if((Pawn(Owner) != None) && (Pawn(Owner).PlayerReplicationInfo != None))
			Pawn(Owner).ReceiveLocalizedMessage(Class'Pistol_GlockModeMessage',0,Pawn(Owner).PlayerReplicationInfo);
	}

	GotoState('AltFiring');
	PlayAltFire();
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire;

Begin:
	Sleep(0.16);
	if (Pawn(Owner).bAltFire != 0)
		GoTo('Begin');
	Else
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.78);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.78);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
   	Begin:
        if(isAnimating())
        	FinishAnim();

        if(FireMode == 1 && ClipCount <= 2 && AmmoType.AmmoAmount > 0)
        	FireMode = 0;

        PlayIdleAnim();
        if(AmmoType.AmmoAmount<=0 && Pawn(Owner) != None)
        	Pawn(Owner).SwitchToBestWeapon();

    Checks:
        if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
            Reload();

        Sleep(0.0);
        GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

defaultproperties
{
	HeadShotMultiplier=1.50
	PawnPenetrationValue=86.00
	WallPenetrationValue=80.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.800000
    ReloadSounds(0)=Sound'CSSWeapons.Glock.GlockSlideBack'
    ReloadSounds(1)=Sound'CSSWeapons.Glock.GlockClipOut'
    ReloadSounds(2)=Sound'CSSWeapons.Glock.GlockClipIn'
    ReloadSounds(3)=Sound'CSSWeapons.Glock.GlockSlideRelease'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.Glock.GlockFire'
    AltFireSound=Sound'CSSWeapons.Glock.GlockFire'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=18
    ClipCount=20
    PickupAmmoCount=80
    AmmoName=Class'CSSWeapons.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.270000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.012000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Glock-18."
    ItemName="Glock-18"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.GlockMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.GlockFirstPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'CSSWeapons.GlockFirst3rd'
    ThirdPersonScale=2.200000
    bMuzzleFlashParticles=False
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.GlockMuzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.GlockFirstPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CSSWeapons.Glock.GlockIcon'
    StatusIcon=Texture'CSSWeapons.Glock.GlockIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}