class Pistol_FiveSeven extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=FiveSevenMesh MODELFILE=ModelsSkeletal\Pistols\FiveSeven\FiveSevenMesh.psk
#exec MESH ORIGIN MESH=FiveSevenMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=FiveSevenFirstPick ANIVFILE=MODELS\Pistols\FiveSeven\FiveSevenFirstPick_a.3d DATAFILE=MODELS\Pistols\FiveSeven\FiveSevenFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FiveSevenFirstPick X=0 Y=0 Z=12.7

//3rd Person
#exec MESH IMPORT MESH=FiveSevenFirst3rd ANIVFILE=MODELS\Pistols\FiveSeven\FiveSevenFirst3rd_a.3d DATAFILE=MODELS\Pistols\FiveSeven\FiveSevenFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FiveSevenFirst3rd X=16 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=FiveSevenAnims ANIMFILE=ModelsSkeletal\Pistols\FiveSeven\FiveSevenMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=All STARTFRAME=0 NUMFRAMES=165
#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=Still STARTFRAME=33 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=97
#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=Fire STARTFRAME=141 NUMFRAMES=24

#exec ANIM DIGEST ANIM=FiveSevenAnims
#exec MESH DEFAULTANIM MESH=FiveSevenMesh ANIM=FiveSevenAnims

//Pickup
#exec MESH SEQUENCE MESH=FiveSevenFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FiveSevenFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=FiveSevenFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=FiveSevenFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=FiveSevenMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=FiveSevenFirstPick MESH=FiveSevenFirstPick
#exec MESHMAP SCALE MESHMAP=FiveSevenFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=FiveSevenFirst3rd MESH=FiveSevenFirst3rd
#exec MESHMAP SCALE MESHMAP=FiveSevenFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=FiveSevenMeshSkin00 FILE=Textures\Pistols\FiveSeven\FiveSevenBody.bmp GROUP=FiveSeven FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=FiveSevenBodyPick FILE=Textures\Pistols\FiveSeven\FiveSevenBodyPick.bmp GROUP=FiveSeven FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMesh NUM=0 TEXTURE=FiveSevenMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenFirstPick NUM=1 TEXTURE=FiveSevenBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenFirst3rd NUM=1 TEXTURE=FiveSevenBodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="FiveSevenFire" FILE=Sounds\Pistols\FiveSeven\FiveSeven_fire.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FiveSevenClipOut" FILE=Sounds\Pistols\FiveSeven\FiveSeven_clipout.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FiveSevenClipIn" FILE=Sounds\Pistols\FiveSeven\FiveSeven_clipin.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FiveSevenSlidePull" FILE=Sounds\Pistols\FiveSeven\FiveSeven_slidepull.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FiveSevenSlideRelease" FILE=Sounds\Pistols\FiveSeven\FiveSeven_sliderelease.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FiveSevenSlideBack" FILE=Sounds\Pistols\FiveSeven\FiveSeven_slideback.wav GROUP="FiveSeven"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=FiveSevenMuzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=FiveSevenMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=FiveSevenMuzzle X=-270 Y=0 Z=-15

#exec MESH SEQUENCE MESH=FiveSevenMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FiveSevenMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=FiveSevenMuzzle MESH=FiveSevenMuzzle
#exec MESHMAP SCALE MESHMAP=FiveSevenMuzzle X=0.055 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMuzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle02.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMuzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=FiveSevenIcon FILE=Textures\Icons\FiveSevenIcon.bmp GROUP=FiveSeven MIPS=OFF

//=========================================================================================

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.04);
	Sleep(0.4);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.4);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[4], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	GoToState('Selector');	
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if(!Owner.IsA('Bot'))
		PlayAnim('Fire', 1.3, 0.04);
	else if(Owner.IsA('Bot'))
		PlayAnim('Fire', 4.3, 0.04);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		bCanClientFire = true;
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
        ClientFire(Value);
        if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			MuzzleFlashScale = 0.0;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		MuzzleFlashScale = Default.MuzzleFlashScale;
		Super.EndState();
	}

Begin:
	FlashCount++;
Begin2:
	Sleep(0.16);
	if(Pawn(Owner) != None)
	{
		if (Pawn(Owner).bFire != 0)
		{
			MuzzleFlashScale = 0.0;
			GoTo('Begin2');
		}
		else
			Finish();
	}
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	HeadShotMultiplier=1.50
	PawnPenetrationValue=86.00
	WallPenetrationValue=80.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.800000
	ReloadSounds(0)=Sound'CSSWeapons.FiveSeven.FiveSevenSlideBack'
	ReloadSounds(1)=Sound'CSSWeapons.FiveSeven.FiveSevenClipOut'
    ReloadSounds(2)=Sound'CSSWeapons.FiveSeven.FiveSevenClipIn'
    ReloadSounds(3)=Sound'CSSWeapons.FiveSeven.FiveSevenSlideRelease'
    ReloadSounds(4)=Sound'CSSWeapons.FiveSeven.FiveSevenSlidePull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.FiveSeven.FiveSevenFire'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=18
    ClipCount=20
    Recoil=(Vertical=0.370000,Horizontal=0.220000,duration=0.100000)
    PickupAmmoCount=80
    AmmoName=Class'CSSWeapons.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.280000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=400.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.014000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Five-Seven."
    ItemName="Five-Seven"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.FiveSevenMesh'
    PlayerViewScale=12.000000
    PickupViewMesh=LodMesh'CSSWeapons.FiveSevenFirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'CSSWeapons.FiveSevenFirst3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=False
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.FiveSevenMuzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.FiveSevenFirstPick'
    Icon=Texture'CSSWeapons.FiveSeven.FiveSevenIcon'
    StatusIcon=Texture'CSSWeapons.FiveSeven.FiveSevenIcon'
    bNoSmooth=False
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}