class Pistol_DualElites extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=ElitesMesh MODELFILE=ModelsSkeletal\Pistols\DualElites\ElitesMesh.psk
#exec MESH ORIGIN MESH=ElitesMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=ElitesFirstPick ANIVFILE=MODELS\Pistols\DualElites\ElitesFirstPick_a.3d DATAFILE=MODELS\Pistols\DualElites\ElitesFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ElitesFirstPick X=0 Y=0 Z=15.1

//3rd Person
#exec MESH IMPORT MESH=ElitesFirst3rd ANIVFILE=MODELS\Pistols\DualElites\ElitesFirst3rd_a.3d DATAFILE=MODELS\Pistols\DualElites\ElitesFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ElitesFirst3rd X=14 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=ElitesMeshAnims ANIMFILE=ModelsSkeletal\Pistols\DualElites\ElitesMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=175
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=42
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=Still STARTFRAME=43 NUMFRAMES=2
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=Reload STARTFRAME=46 NUMFRAMES=95
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=FireRight STARTFRAME=142 NUMFRAMES=16
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=FireLeft STARTFRAME=159 NUMFRAMES=16

#exec ANIM DIGEST ANIM=ElitesMeshAnims
#exec MESH DEFAULTANIM MESH=ElitesMesh ANIM=ElitesMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=ElitesFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ElitesFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=ElitesFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=ElitesFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=ElitesMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=ElitesFirstPick MESH=ElitesFirstPick
#exec MESHMAP SCALE MESHMAP=ElitesFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=ElitesFirst3rd MESH=ElitesFirst3rd
#exec MESHMAP SCALE MESHMAP=ElitesFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=ElitesMeshSkin00 FILE=Textures\Pistols\DualElites\ElitesBody.bmp GROUP=DualElites LODSET=2
#exec TEXTURE IMPORT NAME=ElitesPick FILE=Textures\Pistols\DualElites\ElitesBodyPick.bmp GROUP=DualElites LODSET=2
#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=0 TEXTURE=ElitesMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=ElitesFirstPick NUM=1 TEXTURE=ElitesPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=ElitesFirst3rd NUM=1 TEXTURE=ElitesPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="EliteFire" FILE=Sounds\Pistols\DualElites\elite_fire.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteSelect" FILE=Sounds\Pistols\DualElites\elite_deploy.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteClipOut" FILE=Sounds\Pistols\DualElites\elite_clipout.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteRClipIn" FILE=Sounds\Pistols\DualElites\elite_rightclipin.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteLClipIn" FILE=Sounds\Pistols\DualElites\elite_leftclipin.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteSlideRelease" FILE=Sounds\Pistols\DualElites\elite_sliderelease.wav GROUP="DualElites"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=ElitesMuzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=ElitesMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=ElitesMuzzle X=-310 Y=0 Z=-15

#exec MESH SEQUENCE MESH=ElitesMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ElitesMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=ElitesMuzzle MESH=ElitesMuzzle
#exec MESHMAP SCALE MESHMAP=ElitesMuzzle X=0.055 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMuzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle02.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMuzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=ElitesIcon FILE=Textures\Icons\DualElitesIcon.bmp GROUP=DualElites MIPS=OFF

//=========================================================================================

var byte AnimNo;
var float LFlashO;

simulated event RenderOverlays( canvas Canvas )
{
	local int Hand;
	local PlayerPawn PlayerOwner;
	local bool bPlayerOwner;
	local rotator NewRot;
	local bool bHasInvisibility;
	
	if(PlayerPawn(Owner) != None)
		PlayerOwner = PlayerPawn(Owner);
	
	if ( PlayerOwner != None )
   	{
        if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
            return;
        bPlayerOwner = true;
        Hand = PlayerOwner.Handedness;
		
		if (  (Level.NetMode == NM_Client) && (Hand == 2) )
        {
            bHideWeapon = true;
            return;
        }
   	}
	
	if ( !bPlayerOwner || (PlayerOwner.Player == None) )
      Pawn(Owner).WalkBob = vect(0,0,0);

   	if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash /*&& Level.bHighDetailMode*/ && (MFTexture != None) )
   	{
      	MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
      	if ( !bSetFlashTime )
      	{
         	bSetFlashTime = true;
         	FlashTime = Level.TimeSeconds + FlashLength;
      	}
      	else if ( FlashTime < Level.TimeSeconds )
         	bMuzzleFlash = 0;
      	if ( bMuzzleFlash > 0 )
      	{
      		if(AnimNo == 0)
      			FlashO = default.FlashO;
      		else if(AnimNo == 1)
      			FlashO = default.LFlashO;

         	//if ( Hand == 0 )
            	//Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
         	//else
            Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);

            Canvas.Style = 3;
            Canvas.DrawIcon(MFTexture, MuzzleScale);
            Canvas.Style = 1;
      	}
   	}
   	else
    	bSetFlashTime = false;

   	SetLocation( Owner.Location + CSSCalcDrawOffset());
   	NewRot = Pawn(Owner).ViewRotation;

    if ( Hand == 0 )
        newRot.Roll = -2 * Default.Rotation.Roll;
    else
        newRot.Roll = Default.Rotation.Roll * Hand;

   	setRotation(newRot);
   	Canvas.DrawActor(self, False, True);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	PlayOwnedSound(SelectSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	GoToState('Selector');	
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if(!Owner.IsA('Bot'))
	{
		if(AnimNo == 0)
		{
			EjectOffset.Y = default.EjectOffset.Y;
			PlayAnim('FireRight', 0.7, 0.04);
			AnimNo++;
		}
		else if(AnimNo == 1)
		{
			EjectOffset.Y = -5.000000;
			PlayAnim('FireLeft', 0.7, 0.04);
			AnimNo = 0;	
		}
	}
	else if(Owner.IsA('Bot'))
	{
		if(AnimNo == 0)
		{
			PlayAnim('FireRight', 4.3, 0.04);
			AnimNo++;
		}
		else if(AnimNo == 1)
		{
			PlayAnim('FireLeft', 4.3, 0.04);
			AnimNo = 0;	
		}
	}
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			MuzzleFlashScale = 0.0;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		MuzzleFlashScale = Default.MuzzleFlashScale;
		Super.EndState();
	}

Begin:
	FlashCount++;
Begin2:
	Sleep(0.16);
	if(Pawn(Owner) != None)
	{
		if (Pawn(Owner).bFire != 0)
		{
			MuzzleFlashScale = 0.0;
			GoTo('Begin2');
		}
		else
			Finish();
	}
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.7, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 								
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.3);
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 								
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.3);
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

function SpawnShellCase(Vector Offset)
{
   local BaseShellCase s;
   local vector X,Y,Z;
   
   GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
   s = Spawn(ShellCaseType, Pawn(Owner), '', Owner.Location + CalcDrawOffset() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
   if(s!=None)
   {
      s.bNoSmooth = False;
      s.DrawScale = 0.80;
      s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
   }
}

defaultproperties
{
	HeadShotMultiplier=1.50
	PawnPenetrationValue=86.00
	WallPenetrationValue=80.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.800000
	ReloadSounds(0)=Sound'CSSWeapons.DualElites.EliteSlideRelease'
	ReloadSounds(1)=Sound'CSSWeapons.DualElites.EliteClipOut'
    ReloadSounds(2)=Sound'CSSWeapons.DualElites.EliteRClipIn'
    ReloadSounds(3)=Sound'CSSWeapons.DualElites.EliteLClipIn'
    ReloadSounds(4)=Sound'CSSWeapons.DualElites.P228SlideRelease'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.DualElites.EliteFire'
    SelectSound=Sound'CSSWeapons.DualElites.EliteSelect'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=18
    ClipCount=30
    PickupAmmoCount=90
    Recoil=(Vertical=0.370000,Horizontal=0.220000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.290000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.150000
    FlashO=0.015000
    LFlashO=-0.015000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Dual Elites."
    ItemName="Dual Elites"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.ElitesMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'CSSWeapons.ElitesFirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'CSSWeapons.ElitesFirst3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=False
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.ElitesMuzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.ElitesFirstPick'
    bNoSmooth=False
    Icon=Texture'CSSWeapons.DualElites.ElitesIcon'
    StatusIcon=Texture'CSSWeapons.DualElites.ElitesIcon'
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}