class Pistol_Deagle extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=DeagleMesh MODELFILE=ModelsSkeletal\Pistols\Deagle\DeagleMesh.psk
#exec MESH ORIGIN MESH=DeagleMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=DeagleFirstPick ANIVFILE=MODELS\Pistols\Deagle\DeagleFirstPick_a.3d DATAFILE=MODELS\Pistols\Deagle\DeagleFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DeagleFirstPick X=0 Y=0 Z=14.5

//3rd Person
#exec MESH IMPORT MESH=DeagleFirst3rd ANIVFILE=MODELS\Pistols\Deagle\DeagleFirst3rd_a.3d DATAFILE=MODELS\Pistols\Deagle\DeagleFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DeagleFirst3rd X=20 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=DeagleAnims ANIMFILE=ModelsSkeletal\Pistols\Deagle\DeagleMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=DeagleAnims SEQ=All STARTFRAME=0 NUMFRAMES=160
#exec ANIM SEQUENCE ANIM=DeagleAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=DeagleAnims SEQ=Still STARTFRAME=33 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=DeagleAnims SEQ=Reload STARTFRAME=65 NUMFRAMES=66
#exec ANIM SEQUENCE ANIM=DeagleAnims SEQ=Fire STARTFRAME=132 NUMFRAMES=28

#exec ANIM DIGEST ANIM=DeagleAnims
#exec MESH DEFAULTANIM MESH=DeagleMesh ANIM=DeagleAnims

//Pickup
#exec MESH SEQUENCE MESH=DeagleFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DeagleFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=DeagleFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=DeagleFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=DeagleMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=DeagleFirstPick MESH=DeagleFirstPick
#exec MESHMAP SCALE MESHMAP=DeagleFirstPick X=0.12 Y=0.12 Z=0.22

//3rd Person
#exec MESHMAP NEW MESHMAP=DeagleFirst3rd MESH=DeagleFirst3rd
#exec MESHMAP SCALE MESHMAP=DeagleFirst3rd X=0.11 Y=0.11 Z=0.21

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=DeagleMeshSkin00 FILE=Textures\Pistols\Deagle\DeagleBody.bmp GROUP=Deagle LODSET=2
#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=DeagleMesh NUM=0 TEXTURE=DeagleMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=DeagleMesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec TEXTURE IMPORT NAME=DPick FILE=Textures\Pistols\Deagle\DeaglePick.bmp GROUP=Deagle LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=DeagleFirstPick NUM=1 TEXTURE=DPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=DeagleFirst3rd NUM=1 TEXTURE=DPick

//=========================================================================================
//Sounds
#exec AUDIO IMPORT NAME="DeFire" FILE=Sounds\Pistols\Deagle\de_fire.wav GROUP="Deagle"
#exec AUDIO IMPORT NAME="DeSelect" FILE=Sounds\Pistols\Deagle\de_deploy.wav GROUP="Deagle"
#exec AUDIO IMPORT NAME="DeClipIn" FILE=Sounds\Pistols\Deagle\de_clipin.wav GROUP="Deagle"
#exec AUDIO IMPORT NAME="DeClipOut" FILE=Sounds\Pistols\Deagle\de_clipout.wav GROUP="Deagle"
#exec AUDIO IMPORT NAME="DeSlide" FILE=Sounds\Pistols\Deagle\de_slideBack.wav GROUP="Deagle"

//=========================================================================================

//Taken from Nali Weapons 3 - Vulcan weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=DeagleMuzzle ANIVFILE=MODELS\MuzzleFMesh\SMGMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\SMGMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=DeagleMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=DeagleMuzzle X=-380 Y=0 Z=-15

#exec MESH SEQUENCE MESH=DeagleMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DeagleMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=DeagleMuzzle MESH=DeagleMuzzle
#exec MESHMAP SCALE MESHMAP=DeagleMuzzle X=0.055 Y=0.225 Z=0.45

#exec TEXTURE IMPORT NAME=SMGMuzzle01 FILE=Textures\SMGMuzzle01.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=DeagleMuzzle NUM=0 TEXTURE=SMGMuzzle01

#exec TEXTURE IMPORT NAME=SMGMuzzle02 FILE=Textures\SMGMuzzle02.bmp GROUP=USPMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=DeagleMuzzle NUM=1 TEXTURE=SMGMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=DeagleIcon FILE=Textures\Icons\DeagleIcon.bmp GROUP=Deagle MIPS=OFF

//=========================================================================================

simulated function PlaySelect()
{
   PlayAnim('Select', 1.0, 0.04);
   PlaySound(SelectSound,,255.00);
   GoToState('Selector');
}

simulated state Selector
{
   	ignores Fire,AltFire;

   	Begin:
    	FinishAnim();
      	Finish();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if(!Owner.IsA('Bot'))
		PlayAnim('Fire', 1.3, 0.05);
	else if(Owner.IsA('Bot'))
		PlayAnim('Fire', 4.3, 0.05);

	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();

	ClipCount--;

	if ( (PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			MuzzleFlashScale = 0.0;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		MuzzleFlashScale = Default.MuzzleFlashScale;
		Super.EndState();
	}

Begin:
	FlashCount++;
Begin2:
	Sleep(0.16);
	if(Pawn(Owner) != None)
	{
		if (Pawn(Owner).bFire != 0)
		{
			MuzzleFlashScale = 0.0;
			GoTo('Begin2');
		}
		else
			Finish();
	}
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.1);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.1);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	HeadShotMultiplier=1.50
	PawnPenetrationValue=86.00
	WallPenetrationValue=80.00
	ShellCaseType=Class'CSSWeapons.CSSShellCase'
	ShellCaseScale=0.850000
	ReloadSounds(0)=Sound'CSSWeapons.Deagle.DeClipOut'
    ReloadSounds(1)=Sound'CSSWeapons.Deagle.DeClipIn'
    ReloadSounds(2)=Sound'CSSWeapons.Deagle.DeSlide'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    SelectSound=Sound'CSSWeapons.Deagle.DeSelect'
    FireSound=Sound'CSSWeapons.Deagle.DeFire'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=30
    ClipCount=7
    Recoil=(Vertical=0.370000,Horizontal=0.220000,duration=0.100000)
    PickupAmmoCount=35
    AmmoName=Class'CSSWeapons.AmmoPistols'
    bInstantHit=True
    bRapidFire=False
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.300000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.011400
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSPistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Deagle."
    ItemName="Deagle"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CSSWeapons.DeagleMesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'DeagleFirstPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'DeagleFirst3rd'
    ThirdPersonScale=2.200000
    bMuzzleFlashParticles=False
    bSteadyFlash3rd=False
    bToggleSteadyFlash=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.DeagleMuzzle'
    MuzzleFlashScale=0.500000
    Mesh=LodMesh'CSSWeapons.DeagleFirstPick'
    DrawScale=3.000000
    bNoSmooth=False
    Icon=Texture'CSSWeapons.Deagle.DeagleIcon'
    StatusIcon=Texture'CSSWeapons.Deagle.DeagleIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.000000
    Mass=10.000000
}