class Melee_Knife extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=KnifeMesh MODELFILE=ModelsSkeletal\Melee\Knife\KnifeMesh.psk
#exec MESH ORIGIN MESH=KnifeMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=KnifeFirstPick ANIVFILE=Models\Melee\Knife\KnifeFirstPick_a.3d DATAFILE=Models\Melee\Knife\KnifeFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=KnifeFirstPick X=0 Y=0 Z=24

//3rd Person
#exec MESH IMPORT MESH=KnifeFirst3rd ANIVFILE=MODELS\Melee\Knife\KnifeFirst3rd_a.3d DATAFILE=MODELS\Melee\Knife\KnifeFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=KnifeFirst3rd X=0 Y=0 Z=-7 Yaw=64

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=KnifeAnims ANIMFILE=ModelsSkeletal\Melee\Knife\KnifeMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=KnifeAnims SEQ=All STARTFRAME=0 NUMFRAMES=375
#exec ANIM SEQUENCE ANIM=KnifeAnims SEQ=Select STARTFRAME=0 NUMFRAMES=47
#exec ANIM SEQUENCE ANIM=KnifeAnims SEQ=Still STARTFRAME=48 NUMFRAMES=151
#exec ANIM SEQUENCE ANIM=KnifeAnims SEQ=Slash STARTFRAME=200 NUMFRAMES=66
#exec ANIM SEQUENCE ANIM=KnifeAnims SEQ=Stab STARTFRAME=267 NUMFRAMES=46
#exec ANIM SEQUENCE ANIM=KnifeAnims SEQ=StabMiss STARTFRAME=314 NUMFRAMES=61

#exec ANIM DIGEST ANIM=KnifeAnims
#exec MESH DEFAULTANIM MESH=KnifeMesh ANIM=KnifeAnims

#exec ANIM NOTIFY ANIM=KnifeAnims SEQ=Slash TIME=0.1 FUNCTION=TraceFire2
#exec ANIM NOTIFY ANIM=KnifeAnims SEQ=Stab TIME=0.15 FUNCTION=TraceAltFire
#exec ANIM NOTIFY ANIM=KnifeAnims SEQ=StabMiss TIME=0.1 FUNCTION=TraceFire2

//Pickup
#exec MESH SEQUENCE MESH=KnifeFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=KnifeFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=KnifeFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=KnifeFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=KnifeMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=KnifeFirstPick MESH=KnifeFirstPick
#exec MESHMAP SCALE MESHMAP=KnifeFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=KnifeFirst3rd MESH=KnifeFirst3rd
#exec MESHMAP SCALE MESHMAP=KnifeFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=KnifeMeshSkin00 FILE=Textures\Melee\Knife\KnifeBody.bmp GROUP=Knife LODSET=2
#exec TEXTURE IMPORT NAME=KnifeMeshSkin01  FILE=Textures\Generic\GenericHand.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=KnfBlade FILE=Textures\Melee\Knife\KnifeBlade.bmp GROUP=Knife LODSET=2
#exec TEXTURE IMPORT NAME=KnfHandle FILE=Textures\Melee\Knife\KnifeHandle.bmp GROUP=Knife LODSET=2
#exec TEXTURE IMPORT NAME=KnfTop FILE=Textures\Melee\Knife\KnifeTop.bmp GROUP=Knife LODSET=2

#exec TEXTURE IMPORT NAME=KnfBody3 FILE=Textures\Melee\Knife\KnifeBody3rd.bmp GROUP=Knife LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=KnifeMesh NUM=0 TEXTURE=KnifeMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=KnifeMesh NUM=1 TEXTURE=KnifeMeshSkin01

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=KnifeFirstPick NUM=1 TEXTURE=KnfHandle
#exec MESHMAP SETTEXTURE MESHMAP=KnifeFirstPick NUM=2 TEXTURE=KnfTop
#exec MESHMAP SETTEXTURE MESHMAP=KnifeFirstPick NUM=3 TEXTURE=KnfBlade

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=KnifeFirst3rd NUM=1 TEXTURE=KnfBody3

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="KnfDeploy" FILE=Sounds\Melee\Knife\Knife_deploy.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnfHit1" FILE=Sounds\Melee\Knife\Knife_hit1.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnfHit2" FILE=Sounds\Melee\Knife\Knife_hit2.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnfHit3" FILE=Sounds\Melee\Knife\Knife_hit3.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnfHit4" FILE=Sounds\Melee\Knife\Knife_hit4.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnfHitWall" FILE=Sounds\Melee\Knife\Knife_hitwall.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnfSlash" FILE=Sounds\Melee\Knife\Knife_slash.wav GROUP="Knife"
#exec AUDIO IMPORT NAME="KnfStab" FILE=Sounds\Melee\Knife\Knife_stab.wav GROUP="Knife"

//=========================================================================================

#exec TEXTURE IMPORT NAME=KnfIcon FILE=Textures\Icons\KnifeIcon.bmp GROUP=Knife MIPS=OFF

//=========================================================================================

var Sound HitWallSound, SlashSound, HitSound[4], StabSound;
var Playerpawn LastHit;
var int HitAltDamage;
var float Range;
var byte AnimNo;

simulated function PostRender(Canvas C)
{
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;
	local bool bRetreating;
	local Pawn P;

	bUseAltMode = 0;
	P = Pawn(Owner);

	if ( (P == None) || (P.Enemy == None) )
		return 0;

	EnemyDist = VSize(P.Enemy.Location - Owner.Location);
	if ( (EnemyDist < 750) && P.IsA('Bot') && Bot(P).bNovice && (P.Skill <= 2) && !P.Enemy.IsA('Bot') && (ImpactHammer(P.Enemy.Weapon) != None) )
		return FClamp(300/(EnemyDist + 1), 0.6, 0.75);

	if ( EnemyDist > 400 )
		return 0.1;
	if ( (P.Weapon != self) && (EnemyDist < 120) )
		return 0.25;

	return ( FMin(0.8, 81/(EnemyDist + 1)) );
}

function float SuggestAttackStyle()
{
	return 10.0;
}

function float SuggestDefenseStyle()
{
	return -2.0;
}

simulated function PlaySelect()
{
	PlayAnim('Select',1.3, 0.04);
	Owner.PlaySound(SelectSound,,255.00);
}

function PlayFire()
{
	JustFire();
	PlayerFire();
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority )) 
		JustFire();
}

simulated function JustFire()
{
	if(AnimNo == 0)
	{
		PlayAnim('Slash', 3, 0.04);
		AnimNo++;
	}
	else if(AnimNo == 1)
	{
		PlayAnim('StabMiss', 1.5, 0.04);
		AnimNo = 0;
	}
	PlayOwnedSound(SlashSound,SLOT_Misc, Pawn(Owner).SoundDampening);
}

function Fire( float Value )
{
	GotoState('NormalFire');
	bPointing=True;
	PlayFire();
	bCanClientFire = true;
	ClientFire(value);
	//TraceFire(0.0);
}

state NormalFire
{
	Begin:
		FinishAnim();
		Finish();
}

simulated function PlayAltFiring()
{
}

function PlayAltFire()
{
	JustAltFire();
	PlayerAltFire();
}

simulated function PlayerAltFire()
{
	if ( ( Role < ROLE_Authority )) 
		JustAltFire();
}

simulated function JustAltFire()
{
	PlayAnim('Stab', 1, 0.04);
	PlayOwnedSound(SlashSound,,255.0);
}

function AltFire( float Value )
{
	GotoState('AltFiring');
	PlayAltFire();
	bCanClientFire = true;
	bPointing=True;
	ClientAltFire(value);
	//TraceAltFire(0.0);
}

state AltFiring
{
	Begin:
		FinishAnim();
		Finish();
}

function TraceFire2()
{
	local vector HitLocation, HitNormal, EndTrace, X, Y, Z, Start;
	local actor Other;

	LastHit = None;
	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	Start =  Owner.Location + CSSCalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = pawn(owner).AdjustAim(1000000, Start, 2 * AimError, False, False);	
	EndTrace = Owner.Location + (1 + Range) * vector(AdjustedAim); 
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, Start);

	if ( (Other == None) || (Other == Owner) || (Other == self) )
		return;

	if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) && (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
	else
		Other.TakeDamage(HitDamage * HeadShotMultiplier, Pawn(Owner), HitLocation, 66 * X, MyDamageType);
				
	if( Other.bIsPawn || Other.IsA('Carcass'))
	{
		//if (PlayerPawn(Owner) != None) 
			//PlayerPawn(Owner).ClientWeaponEvent('');
		Owner.PlaySound(HitSound[Rand(4)],SLOT_Misc,255.0);
	}
		
	if ( !Other.bIsPawn && !Other.IsA('Carcass') )
		Owner.PlaySound(HitWallSound,,255.0);
		
	if ( Other.IsA('PlayerPawn') && (Pawn(Other).Health > 0) )
		LastHit = PlayerPawn(Other);
}

function TraceAltFire()
{
	local vector HitLocation, HitNormal, EndTrace, X, Y, Z, Start;
	local actor Other;

	LastHit = None;
	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	Start =  Owner.Location + CSSCalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = pawn(owner).AdjustAim(1000000, Start, 2 * AimError, False, False);	
	EndTrace = Owner.Location + (1 + Range) * vector(AdjustedAim); 
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, Start);

	if ( (Other == None) || (Other == Owner) || (Other == self) )
		return;

	if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) && (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
		Other.TakeDamage(HitAltDamage * HeadShotMultiplier, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
	else
		Other.TakeDamage(HitAltDamage, Pawn(Owner), HitLocation, 66 * X, MyDamageType);
				
	if( Other.bIsPawn || Other.IsA('Carcass'))
	{
		Owner.PlaySound(StabSound,,255.0);
	}
		
	if ( !Other.bIsPawn && !Other.IsA('Carcass') )
		Owner.PlaySound(HitWallSound,,255.0);
		
	if ( Other.IsA('PlayerPawn') && (Pawn(Other).Health > 0) )
		LastHit = PlayerPawn(Other);
}

function Finish()
{
	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if ( PlayerPawn(Owner) == None )
	{
		if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			Global.Fire(0);
		else if ( (Pawn(Owner).bAltFire != 0) && (FRand() < AltRefireRate) )
			Global.AltFire(0);	
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}
	if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}

simulated state Idle
{
   Begin:
        if(isAnimating())
			FinishAnim();
        PlayIdleAnim();
}

simulated function PlayIdleAnim()
{
	PlayAnim('Still', 0.5, 0.04);
}

defaultproperties
{
	HeadShotMultiplier=1.50
	ShellCaseType=None
	ShellCaseScale=0.00
	PawnPenetrationValue=0.0
	WallPenetrationValue=0.0
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=None
    StabSound=Sound'CSSWeapons.Knife.KnfStab'
    HitSound(0)=Sound'CSSWeapons.Knife.KnfHit1'
    HitSound(1)=Sound'CSSWeapons.Knife.KnfHit2'
    HitSound(2)=Sound'CSSWeapons.Knife.KnfHit3'
    HitSound(3)=Sound'CSSWeapons.Knife.KnfHit4'
    HitWallSound=Sound'CSSWeapons.Knife.KnfHitWall'
    SlashSound=Sound'CSSWeapons.Knife.KnfSlash'
    SelectSound=Sound'CSSWeapons.Knife.KnfDeploy'
    Range=70.000000
    HitDamage=30
    HitAltDamage=55
   	bMeleeWeapon=True
    bInstantHit=True
    bAltInstantHit=True
    bWarnTarget=False
    bCanThrow=False
    bRapidFire=True
    FireOffset=(Y=0.000000,Z=0.000000)
    MyDamageType=Slashed
    AltDamageType=Decapitated
    AIRating=0.090000
    RefireRate=1.000000
    AltRefireRate=1.000000
    BobDamping=1.11
    AutoSwitchPriority=1
    InventoryGroup=1
    PickupMessage="You got a Knife."
    ItemName="Knife"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=7.00
    PlayerViewMesh=SkeletalMesh'CSSWeapons.KnifeMesh'
    PickupViewMesh=LodMesh'CSSWeapons.KnifeFirstPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CSSWeapons.KnifeFirst3rd'
    ThirdPersonScale=1.80
    Mesh=LodMesh'CSSWeapons.KnifeFirstPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CSSWeapons.Knife.KnfIcon'
    StatusIcon=Texture'CSSWeapons.Knife.KnfIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}