class HeavyRifle_M249 extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=M249Mesh MODELFILE=ModelsSkeletal\HeavyRifles\M249\M249Mesh.psk
#exec MESH ORIGIN MESH=M249Mesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=M249FirstPick ANIVFILE=MODELS\HeavyRifles\M249\M249FirstPick_a.3d DATAFILE=MODELS\HeavyRifles\M249\M249FirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M249FirstPick X=0 Y=0 Z=18

//3rd Person
#exec MESH IMPORT MESH=M249First3rd ANIVFILE=MODELS\HeavyRifles\M249\M249First3rd_a.3d DATAFILE=MODELS\HeavyRifles\M249\M249First3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M249First3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=M249MeshAnims ANIMFILE=ModelsSkeletal\HeavyRifles\M249\M249MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=239
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=26
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=Still STARTFRAME=27 NUMFRAMES=2
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=Reload STARTFRAME=30 NUMFRAMES=172
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=Fire STARTFRAME=203 NUMFRAMES=36
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=AfterFire STARTFRAME=210 NUMFRAMES=29

#exec ANIM DIGEST ANIM=M249MeshAnims
#exec MESH DEFAULTANIM MESH=M249Mesh ANIM=M249MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=M249FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M249FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=M249First3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M249First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=M249Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=M249FirstPick MESH=M249FirstPick
#exec MESHMAP SCALE MESHMAP=M249FirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=M249First3rd MESH=M249First3rd
#exec MESHMAP SCALE MESHMAP=M249First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=M249MeshSkin00 FILE=Textures\HeavyRifles\M249\M249Body.bmp GROUP=M249 LODSET=2
#exec TEXTURE IMPORT NAME=M249MeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M249MeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=M249MeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=M249BodyPick FILE=Textures\HeavyRifles\M249\M249BodyPick.bmp GROUP=M249 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=0 TEXTURE=M249MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=1 TEXTURE=M249MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=2 TEXTURE=M249MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=3 TEXTURE=M249MeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=M249FirstPick NUM=1 TEXTURE=M249BodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=M249First3rd NUM=1 TEXTURE=M249BodyPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="M249Fire" FILE=Sounds\HeavyRifles\M249\M249_fire.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249BoxOut" FILE=Sounds\HeavyRifles\M249\M249_boxout.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249BoxIn" FILE=Sounds\HeavyRifles\M249\M249_boxin.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249Chain" FILE=Sounds\HeavyRifles\M249\M249_chain.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249CoverUp" FILE=Sounds\HeavyRifles\M249\M249_coverup.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249CoverDown" FILE=Sounds\HeavyRifles\M249\M249_coverdown.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249BoltPull" FILE=Sounds\HeavyRifles\M249\M249_boltpull.wav GROUP="M249"

//=========================================================================================

//Taken from Nali Weapons 3 - WRE weapon. Thanks FeraliDragon
#exec MESH IMPORT MESH=M249RifleMuzzle ANIVFILE=MODELS\MuzzleFMesh\RifleMuzzle_a.3d DATAFILE=MODELS\MuzzleFMesh\RifleMuzzle_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=M249RifleMuzzle STRENGTH=0
#exec MESH ORIGIN MESH=M249RifleMuzzle X=30 Y=0 Z=-9 Yaw=128

#exec MESH SEQUENCE MESH=M249RifleMuzzle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M249RifleMuzzle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=M249RifleMuzzle MESH=M249RifleMuzzle
#exec MESHMAP SCALE MESHMAP=M249RifleMuzzle X=0.375 Y=0.375 Z=0.750

#exec TEXTURE IMPORT NAME=RifleMuzzle01 FILE=Textures\RifleMuzzle01.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=M249RifleMuzzle NUM=1 TEXTURE=RifleMuzzle01

#exec TEXTURE IMPORT NAME=RifleMuzzle02 FILE=Textures\RifleMuzzle02.bmp GROUP=GalilRifleMuzzleFlashes FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=M249RifleMuzzle NUM=2 TEXTURE=RifleMuzzle02

//=========================================================================================

#exec TEXTURE IMPORT NAME=M249Icon FILE=Textures\Icons\M249Icon.bmp GROUP=M249 MIPS=OFF

//=========================================================================================

var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(6)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.7, 0.04);
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 12.5, 0.04);
	
	if(Class'CSSMutator'.default.bEnableRecoil)
		AddRecoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(6.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.9, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.4);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.46);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.26);
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	Sleep(0.4);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.46);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.26);
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

defaultproperties
{
	RandFlash(0)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
	RandFlash(1)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz2'
	RandFlash(2)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz3'
	RandFlash(3)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz4'
	RandFlash(4)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz5'
	RandFlash(5)=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz6'
	HeadShotMultiplier=1.50
	PawnPenetrationValue=366.00
	WallPenetrationValue=360.00
	ShellCaseType=Class'CSSWeapons.CSSM249ShellCase'
	ShellCaseScale=1.100000
	ReloadSounds(0)=Sound'CSSWeapons.M249.M249BoxOut'
    ReloadSounds(1)=Sound'CSSWeapons.M249.M249CoverUp'
    ReloadSounds(2)=Sound'CSSWeapons.M249.M249BoxIn'
    ReloadSounds(3)=Sound'CSSWeapons.M249.M249Chain'
    ReloadSounds(4)=Sound'CSSWeapons.M249.M249CoverDown'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CSSWeapons.M249.M249Fire'
    EjectOffset=(X=25.000000,Y=17.000000,Z=-10.000000)
    HitDamage=38
    ClipCount=100
    PickupAmmoCount=200
    Recoil=(Vertical=0.220000,Horizontal=1.020000,duration=0.100000)
    AmmoName=Class'CSSWeapons.AmmoMachine'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-7.200000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.880000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=1.200000
    FlashY=0.085000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CSSWeapons.MuzzleFlashes.CSSRifleMuzz1'
    AutoSwitchPriority=8
    InventoryGroup=8
    PickupMessage="You got a M249."
    ItemName="M249"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'M249Mesh'
    PlayerViewScale=17.000000
    PickupViewMesh=LodMesh'M249FirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'M249First3rd'
    ThirdPersonScale=1.85
    bMuzzleFlashParticles=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CSSWeapons.M249RifleMuzzle'
    MuzzleFlashScale=0.900000
    Mesh=LodMesh'CSSWeapons.M249FirstPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CSSWeapons.M249.M294Icon'
    StatusIcon=Texture'CSSWeapons.M249.M249Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}