class Grenade_SmokeProj extends Grenade_FragProj;

#exec AUDIO IMPORT NAME="GrenadeSmokeBounce" FILE=Sounds\Grenades\GrenadeSmoke\SmokeBounce.wav GROUP="GrenadeSmoke"

var bool bEnableSmokeTrail;

simulated function PostBeginPlay()
{
	bEnableSmokeTrail = False;
	Super.PostBeginPlay();
}

function SpawnGrenade()
{
	bEnableSmokeTrail = False;
	Super.SpawnGrenade();
}

simulated function Explosion(vector HitLocation)
{
	SpawnStuff(HitLocation);
	bEnableSmokeTrail = True;
	LifeSpan=10.00;
}

function SpawnStuff(vector HitNormal)
{
	Spawn(Class'Grenade_SmokeEffectA',,,Location);
	Spawn(Class'Grenade_SmokeEffectB',,,Location + Vect(0,0,1) * 1);
	Spawn(Class'Grenade_SmokeEffectB',,,Location + Vect(0,1,0) * 1);
	Spawn(Class'Grenade_SmokeEffectB',,,Location + Vect(1,0,0) * 1);
	Spawn(Class'Grenade_SmokeEffectB',,,Location + Vect(0,1,0) * 1);

	Spawn(Class'Grenade_SmokeEffectB',,,Location + Vect(0,0,1) * 50);
	Spawn(Class'Grenade_SmokeEffectB',,,Location + Vect(0,1,0) * 50);
	Spawn(Class'Grenade_SmokeEffectB',,,Location + Vect(1,0,0) * 50);
	Spawn(Class'Grenade_SmokeEffectB',,,Location + Vect(0,1,0) * 50);
}

simulated function Tick(float DeltaTime)
{
	local UT_SpriteSmokePuff b;

	if(bEnableSmokeTrail)
	{
		if ( bHitWater || Level.bDropDetail ) 
		{
			Disable('Tick');
			return;
		}
		b = Spawn(class'UT_SpriteSmokePuff');
		b.RemoteRole = ROLE_None;
		b.DrawScale = 0.7;
	}
}

defaultproperties
{
	speed=150.000000
	MaxSpeed=2000.000000
	Damage=0.000000
	MomentumTransfer=0
	bUnlit=False
	AmbientGlow=0
	Physics=PHYS_Falling
	ImpactSound=Sound'CSSWeapons.GrenadeSmoke.GrenadeSmokeBounce'
	Mesh=LodMesh'CSSWeapons.GrenadeSmokeFirstPick'
	DrawScale=2.000000
	RemoteRole=ROLE_SimulatedProxy
	bBounce=True
	LODBias=20.000000
    bFixedRotationDir=True
    DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334)
	CollisionRadius=6.000000
	CollisionHeight=7.000000
}