class Grenade_Smoke extends Grenade_Frag;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=GrenadeSmokeMesh MODELFILE=ModelsSkeletal\Grenades\GrenadeSmoke\GrenadeFlashMesh.psk
#exec MESH ORIGIN MESH=GrenadeSmokeMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=GrenadeSmokeFirstPick ANIVFILE=MODELS\Grenades\GrenadeSmoke\GrenadeFlashFirstPick_a.3d DATAFILE=MODELS\Grenades\GrenadeSmoke\GrenadeFlashFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GrenadeSmokeFirstPick X=0 Y=-60 Z=25.5

//3rd Person
#exec MESH IMPORT MESH=GrenadeSmokeFirst3rd ANIVFILE=MODELS\Grenades\GrenadeSmoke\GrenadeFlashFirst3rd_a.3d DATAFILE=MODELS\Grenades\GrenadeSmoke\GrenadeFlashFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GrenadeSmokeFirst3rd X=0 Y=7 Z=-5 Yaw=64

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=GrenadeSmokeMeshAnims ANIMFILE=ModelsSkeletal\Grenades\GrenadeSmoke\GrenadeFlashMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=98
#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=22
#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=Still STARTFRAME=23 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=PullPin STARTFRAME=33 NUMFRAMES=40
#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=Throw STARTFRAME=74 NUMFRAMES=24

#exec ANIM DIGEST ANIM=GrenadeSmokeMeshAnims
#exec MESH DEFAULTANIM MESH=GrenadeSmokeMesh ANIM=GrenadeSmokeMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=GrenadeSmokeFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GrenadeSmokeFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=GrenadeSmokeFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GrenadeSmokeFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=GrenadeSmokeMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=GrenadeSmokeFirstPick MESH=GrenadeSmokeFirstPick
#exec MESHMAP SCALE MESHMAP=GrenadeSmokeFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=GrenadeSmokeFirst3rd MESH=GrenadeSmokeFirst3rd
#exec MESHMAP SCALE MESHMAP=GrenadeSmokeFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=GrenadeSmokeMeshSkin00 FILE=Textures\Grenades\GrenadeSmoke\GrenadeSmokeBody.bmp GROUP=GrenadeSmoke LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeSmokeMeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeSmokeMeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeSmokeMeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=GrenadeSmokeBodyPick FILE=Textures\Grenades\GrenadeSmoke\GrenadeSmokeBodyPick.bmp GROUP=GrenadeSmoke LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=0 TEXTURE=GrenadeSmokeMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=1 TEXTURE=GrenadeSmokeMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=2 TEXTURE=GrenadeSmokeMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=3 TEXTURE=GrenadeSmokeMeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeFirstPick NUM=1 TEXTURE=GrenadeSmokeBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeFirst3rd NUM=1 TEXTURE=GrenadeSmokeBodyPick

//=========================================================================================

simulated function SpawnGrenade( float grenadeSpeed )
{
	Local Grenade_SmokeProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CSSCalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn(class'Grenade_SmokeProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
}

defaultproperties
{
	ThrowOffset=(Y=7.000000)
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CSSWeapons.GrenadeFrag.GrenadeFragPinPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    PickupAmmoCount=2
    AmmoName=Class'CSSWeapons.AmmoGrenade_Smoke'
    FireOffset=(X=0.00,Y=0.000000,Z=0.00),
	AIRating=0.160000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bSplashDamage=True
    bRecommendSplashDamage=True
    bWarnTarget=True
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a Smoke Grenade."
    ItemName="Smoke Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=17.00
    PlayerViewMesh=SkeletalMesh'CSSWeapons.GrenadeSmokeMesh'
    PickupViewMesh=LodMesh'CSSWeapons.GrenadeSmokeFirstPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CSSWeapons.GrenadeSmokeFirst3rd'
    ThirdPersonScale=2.50
    Mesh=LodMesh'CSSWeapons.GrenadeSmokeFirstPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CSSWeapons.GrenadeFlash.GFlashIcon'
    StatusIcon=Texture'CSSWeapons.GrenadeFlash.GFlashIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}