class Grenade_FragSmokeRing extends Effects;

#exec MESH IMPORT MESH=CSSSmokeRing ANIVFILE=MODELS\SmokeEffects\SmkRing_a.3d DATAFILE=MODELS\SmokeEffects\SmkRing_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=CSSSmokeRing STRENGTH=0.25
#exec MESH ORIGIN MESH=CSSSmokeRing X=0 Y=0 Z=0 PITCH=64

#exec MESH SEQUENCE MESH=CSSSmokeRing SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=CSSSmokeRing SEQ=Expand STARTFRAME=0 NUMFRAMES=2 RATE=1.0

#exec MESHMAP NEW MESHMAP=CSSSmokeRing MESH=CSSSmokeRing
#exec MESHMAP SCALE MESHMAP=CSSSmokeRing X=0.8 Y=0.8 Z=1.6

#exec TEXTURE IMPORT NAME=SmokeTex FILE=Textures\SmokeEffects\SmokeTex.bmp GROUP=SmokeEffects FLAGS=2 LODSET=2

simulated function BeginPlay()
{
    Velocity = Vect(0,0,1) * 100.00;
}

simulated function Tick( float DeltaTime)
{
    ScaleGlow = 2 * LifeSpan;
    DrawScale += 0.001;
}

defaultproperties
{
    RemoteRole=ROLE_SimulatedProxy
    LifeSpan=3.00
    DrawType=DT_Mesh
    Style=STY_Translucent
    Texture=Texture'CSSWeapons.SmokeEffects.SmokeTex'
    Mesh=LodMesh'CSSWeapons.CSSSmokeRing'
    DrawScale=0.10
    ScaleGlow=4.00
    bParticles=True
    AmbientGlow=0
    bRandomFrame=False
    MultiSkins(0)=Texture'CSSWeapons.SmokeEffects.SmokeTex'
    MultiSkins(1)=Texture'CSSWeapons.SmokeEffects.SmokeTex'
    MultiSkins(2)=Texture'CSSWeapons.SmokeEffects.SmokeTex'
    MultiSkins(3)=Texture'CSSWeapons.SmokeEffects.SmokeTex'
    MultiSkins(4)=Texture'CSSWeapons.SmokeEffects.SmokeTex'
    MultiSkins(5)=Texture'CSSWeapons.SmokeEffects.SmokeTex'
    MultiSkins(6)=Texture'CSSWeapons.SmokeEffects.SmokeTex'
    MultiSkins(7)=Texture'CSSWeapons.SmokeEffects.SmokeTex'
}