class Grenade_FragProj extends Projectile;

#exec AUDIO IMPORT NAME="GrenadeFragBounce" FILE=Sounds\Grenades\GrenadeFrag\FragBounce.wav GROUP="GrenadeFrag"

var bool bCanHitOwner, bHitWater;
var float Count, SmokeRate;
var ScriptedPawn WarnTarget;	// warn this pawn away
var int NumExtraGrenades;

simulated function PostBeginPlay()
{
	local vector X,Y,Z;
	local rotator RandRot;

	Super.PostBeginPlay();
	
	SetTimer(2.5+FRand()*0.5,false);                  //Grenade begins unarmed

	if ( Role == ROLE_Authority && Instigator != None )
	{
		GetAxes(Instigator.ViewRotation,X,Y,Z);	
		Velocity = X * (Instigator.Velocity Dot X)*0.4 + Vector(Rotation) * (Speed + FRand() * 100);
		Velocity.z += 210;
		RandRot.Pitch = FRand() * 1400 - 700;
		RandRot.Yaw = FRand() * 1400 - 700;
		RandRot.Roll = FRand() * 1400 - 700;
		MaxSpeed = 1000;
		Velocity = Velocity >> RandRot;
		RandSpin(50000);	
		bCanHitOwner = False;
		if( (Instigator != None) && Instigator.HeadRegion.Zone.bWaterZone)
		{
			bHitWater = True;
			Velocity=0.6 * Velocity;			
		}
	}	
}

function SpawnGrenade()
{
	local vector X,Y,Z;
	local rotator RandRot;

	GetAxes(Rotation,X,Y,Z);	
	Velocity = X * speed + Z*250;
			
	RandRot.Pitch = FRand() * 1400 - 700;
	RandRot.Yaw = FRand() * 1400 - 700;
	RandRot.Roll = FRand() * 1400 - 700;
	MaxSpeed = 1000;
	Velocity = Velocity >> RandRot;
	RandSpin(50000);	
	bCanHitOwner = False;
	if( (Instigator != None) && Instigator.HeadRegion.Zone.bWaterZone)
	{
		bHitWater = True;
		Velocity=0.6 * Velocity;			
	}	
}

simulated function ProcessTouch( actor Other, vector HitLocation )
{
	if ( (Other!=instigator) || bCanHitOwner )
		Explosion(HitLocation);
}

simulated function Timer()
{
	Explosion(Location+Vect(0,0,1)*16);
}

simulated function Landed( vector HitNormal )
{
	HitWall( HitNormal, None );
}

simulated function ZoneChange( Zoneinfo NewZone )
{
	local waterring w;
	
	if (!NewZone.bWaterZone || bHitWater) Return;

	bHitWater = True;
	w = Spawn(class'WaterRing',,,,rot(16384,0,0));
	w.DrawScale = 0.2;
	w.RemoteRole = ROLE_None;
	Velocity=0.6*Velocity;
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	Velocity = 0.5*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	RandSpin(100000);
	speed = VSize(Velocity);
	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(ImpactSound/*, SLOT_Misc, FMax(0.5, speed/800)*/ );
	if ( Velocity.Z > 400 )
		Velocity.Z = 0.5 * (400 + Velocity.Z);	
	else if ( speed < 30 ) 
	{
		bBounce = False;
		SetPhysics(PHYS_None);
	}
}

Simulated function BlowUp(vector HitLocation)
{
	//PlaySound(MiscSound);
	HurtRadius(Damage, 300, MyDamageType, MomentumTransfer, HitLocation);
	MakeNoise(1.0);
}

simulated function Explosion(vector HitLocation)
{
	BlowUp(HitLocation);
	if ( Level.NetMode != NM_DedicatedServer )
	{
		Spawn(class'Grenade_FragBlastMark',,,,rot(16384,0,0));
		Spawn(class'Grenade_FragExplosionA',,,HitLocation);
		Spawn(class'Grenade_FragExplosionB',,,HitLocation);
	}

	if(!Region.Zone.bWaterZone)
		SpawnStuff(HitLocation);
	Destroy();
}

function SpawnStuff(vector HitNormal)
{
	Spawn(Class'Grenade_FragSmokeRing',,,, rot(16384,0,0));
	Spawn(Class'Grenade_FragSmoke',,,Location);
	Spawn(Class'Grenade_FragSmoke',,,Location + Vect(0,0,1) * 50);
	Spawn(Class'Grenade_FragSmoke',,,Location + Vect(0,1,0) * 50);
}

simulated function Tick(float DeltaTime);

defaultproperties
{
	speed=150.000000
	MaxSpeed=2000.000000
	Damage=350.000000
	MomentumTransfer=100000
	bUnlit=False
	AmbientGlow=0
	Physics=PHYS_Falling
	ImpactSound=Sound'CSSWeapons.GrenadeFrag.GrenadeFragBounce'
	Mesh=LodMesh'CSSWeapons.GrenadeFragFirstPick'
	DrawScale=2.000000
	RemoteRole=ROLE_SimulatedProxy
	bBounce=True
	LODBias=20.000000
    bFixedRotationDir=True
    DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334)
	CollisionRadius=6.000000
	CollisionHeight=7.000000
}